<?php

require_once(__DIR__ . "/db.pr_agent.php");
require_once(__DIR__ . "/db.pr_agent_rate.php");
require_once(__DIR__ . "/db.pr_business.php");
require_once(__DIR__ . "/db.rf_currency.php");
require_once(__DIR__ . "/db.rt_rate_type.php");

function db_pr_agent_prop_exists($pr_agent_prop_id) {
	global $lDB;

	$check = $lDB->get("
		SELECT COUNT(pr_agent_prop_ix) FROM pr_agent_prop WHERE pr_agent_prop_ix = '" . $lDB->escape($pr_agent_prop_id) . "'
	",4);
	if($check > 0) { return true; } else { return false; }
}

function db_pr_agent_prop_exists_by_all($pr_agent_id, $pr_business_id, $rt_rate_type_id=false) {
	global $lDB;

	if(!db_rt_rate_type_exists($rt_rate_type_id)) {
		$rateTypeJoin = "LEFT JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = pr_agent_prop.rt_rate_type_id";
		$rateTypeWhere = "AND rt_rate_type.rt_rate_type_ix IS NULL";
	} else {
		$rateTypeJoin = "INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = pr_agent_prop.rt_rate_type_id";
		$rateTypeWhere = "AND rt_rate_type.rt_rate_type_ix = '" . $lDB->escape($rt_rate_type_id) . "'";
	}

	$check = $lDB->get("
		SELECT
			COUNT(pr_agent_prop_ix)
		FROM
			pr_agent_prop
			$rateTypeJoin
		WHERE
			pr_agent_id = '" . $lDB->escape($pr_agent_id) . "'
			AND pr_business_id = '" . $lDB->escape($pr_business_id) . "'
			$rateTypeWhere
	",4);
	if($check > 0) { return true; } else { return false; }
}

function db_pr_agent_prop_exists_by_currency($pr_agent_id, $pr_business_id, $rf_currency_id) {
	global $lDB;

	$check = $lDB->get("
		SELECT
			COUNT(pr_agent_prop_ix)
		FROM
			pr_agent_prop
			INNER JOIN rt_rate_type ON pr_agent_prop.rt_rate_type_id = rt_rate_type.rt_rate_type_ix
		WHERE
			pr_agent_id = '" . $lDB->escape($pr_agent_id) . "'
			AND pr_business_id = '" . $lDB->escape($pr_business_id) . "'
			AND rt_rate_type.rf_currency_id = '" . $lDB->escape($rf_currency_id) . "'
	",4);
	if($check > 0) { return true; } else { return false; }
}

function db_pr_agent_prop_insert($pr_agent_id, $pr_business_id, $rt_rate_type_id, $pr_agent_prop_comm_perc) {
	global $lDB;
	global $dbcode;

	if(!db_pr_agent_exists($pr_agent_id) || !db_pr_business_exists($pr_business_id)) {
		return false;
	}

	if(!db_rt_rate_type_exists($rt_rate_type_id)) {
		$rt_rate_type_id = "NULL";
		if(db_pr_agent_prop_exists_by_all($pr_agent_id, $pr_business_id)) {
			return false;
		}
	} else {
		$rf_currency_id = db_rt_rate_type_get_currency($rt_rate_type_id);
		if(db_pr_agent_prop_exists_by_currency($pr_agent_id, $pr_business_id, $rf_currency_id)) {
			return false;
		}
		db_pr_agent_rate_insert($pr_agent_id, $rt_rate_type_id);
		$rt_rate_type_id = "'" . $lDB->escape($rt_rate_type_id) . "'";
	}

	if(!is_numeric($pr_agent_prop_comm_perc)) {
		$pr_agent_prop_comm_perc = "NULL";
	} else {
		$pr_agent_prop_comm_perc = "'" . $lDB->escape($pr_agent_prop_comm_perc) . "'";
	}

	$lDB->put("
		INSERT INTO pr_agent_prop (
			pr_agent_prop_db,
			pr_agent_id,
			pr_business_id,
			rt_rate_type_id,
			pr_agent_prop_comm_perc
		) VALUES (
			'" . $lDB->escape($dbcode) . "',
			'" . $lDB->escape($pr_agent_id) . "',
			'" . $lDB->escape($pr_business_id) . "',
			$rt_rate_type_id,
			$pr_agent_prop_comm_perc
		)
	");

	$pr_agent_prop_id = $lDB->insert_id;

	return $pr_agent_prop_id;
}

function db_pr_agent_prop_get_by_all($pr_agent_id, $pr_business_id) {
	global $lDB;

	return $lDB->get("
		SELECT pr_agent_prop_ix FROM pr_agent_prop WHERE
			pr_agent_id = '" . $lDB->escape($pr_agent_id) . "'
			AND pr_business_id = '" . $lDB->escape($pr_business_id) . "'
	",4);
}

function db_pr_agent_prop_delete($pr_agent_prop_id) {
	global $lDB;

	if(!db_pr_agent_prop_exists($pr_agent_prop_id)) {
		return false;
	}

	$lDB->put("DELETE FROM pr_agent_prop WHERE pr_agent_prop_ix = '" . $lDB->escape($pr_agent_prop_id) . "'");
	return true;
}

function db_pr_agent_prop_delete_by_agent($pr_agent_id) {
	global $lDB;

	if(!db_pr_agent_exists($pr_agent_id)) {
		return false;
	}

	$pr_agent_prop_ids = $lDB->get("
		SELECT pr_agent_prop_ix FROM pr_agent_prop WHERE pr_agent_id = '" . $lDB->escape($pr_agent_id) . "'
	",3);
	foreach($pr_agent_prop_ids as $pr_agent_prop_id) {
		db_pr_agent_prop_delete($pr_agent_prop_id);
	}

	return true;
}

function db_pr_agent_prop_clear_rate_type($pr_agent_id, $rt_rate_type_id) {
	global $lDB;

	if(!db_pr_agent_exists($pr_agent_id) || !db_rt_rate_type_exists($rt_rate_type_id)) {
		return false;
	}

	$list = $lDB->get("
		SELECT
			pr_agent_prop_ix
		FROM
			pr_agent_prop
		WHERE
			pr_agent_prop.pr_agent_id = '" . $lDB->escape($pr_agent_id) . "'
			AND pr_agent_prop.rt_rate_type_id = '" . $lDB->escape($rt_rate_type_id) . "'
	",3);
	foreach($list as $item) {
		db_pr_agent_prop_delete($item);
	}

	return true;
}
