<?php

require_once(__DIR__ . "/db.pr_agent.php");
require_once(__DIR__ . "/db.pr_agent_prop.php");
require_once(__DIR__ . "/db.rt_rate_type.php");

function db_pr_agent_rate_exists($pr_agent_rate_id) {
	global $lDB;

	$check = $lDB->get("
		SELECT COUNT(pr_agent_rate_ix) FROM pr_agent_rate WHERE pr_agent_rate_ix = '" . $lDB->escape($pr_agent_rate_id) . "'
	",4);
	if($check > 0) { return true; } else { return false; }
}

function db_pr_agent_rate_exists_by_agent($pr_agent_id) {
	global $lDB;

	$check = $lDB->get("
		SELECT COUNT(pr_agent_rate_ix) FROM pr_agent_rate WHERE pr_agent_id = '" . $lDB->escape($pr_agent_id) . "'
	",4);
	if($check > 0) { return true; } else { return false; }
}

function db_pr_agent_rate_exists_by_all($pr_agent_id, $rt_rate_type_id) {
	global $lDB;

	$check = $lDB->get("
		SELECT
			COUNT(pr_agent_rate_ix)
		FROM
			pr_agent_rate
		WHERE
			pr_agent_id = '" . $lDB->escape($pr_agent_id) . "'
			AND rt_rate_type_id = '" . $lDB->escape($rt_rate_type_id) . "'
	",4);
	if($check > 0) { return true; } else { return false; }
}

function db_pr_agent_rate_insert($pr_agent_id, $rt_rate_type_id) {
	global $lDB;
	global $dbcode;

	if(!db_pr_agent_exists($pr_agent_id) || !db_rt_rate_type_exists($rt_rate_type_id)) {
		return false;
	}

	if(db_pr_agent_rate_exists_by_all($pr_agent_id, $rt_rate_type_id)) {
		return false;
	}

	$pr_agent_rate_default_yn = "0";
	if(!db_pr_agent_rate_exists_by_agent($pr_agent_id)) {
		$pr_agent_rate_default_yn = "1";
	}

	$lDB->put("
		INSERT INTO pr_agent_rate (
			pr_agent_rate_db,
			pr_agent_id,
			rt_rate_type_id,
			pr_agent_rate_default_yn
		) VALUES (
			'" . $lDB->escape($dbcode) . "',
			'" . $lDB->escape($pr_agent_id) . "',
			'" . $lDB->escape($rt_rate_type_id) . "',
			'" . $lDB->escape($pr_agent_rate_default_yn) . "'
		)
	");

	$pr_agent_rate_id = $lDB->insert_id;

	return $pr_agent_rate_id;
}

function db_pr_agent_rate_get_by_all($pr_agent_id, $rt_rate_type_id) {
	global $lDB;

	return $lDB->get("
		SELECT pr_agent_rate_ix FROM pr_agent_rate WHERE
			pr_agent_id = '" . $lDB->escape($pr_agent_id) . "'
			AND rt_rate_type_id = '" . $lDB->escape($rt_rate_type_id) . "'
	",3);
}

function db_pr_agent_rate_delete($pr_agent_rate_id) {
	global $lDB;

	if(!db_pr_agent_rate_exists($pr_agent_rate_id)) {
		return false;
	}

	$lDB->put("DELETE FROM pr_agent_rate WHERE pr_agent_rate_ix = '" . $lDB->escape($pr_agent_rate_id) . "'");

	return true;
}

function db_pr_agent_rate_delete_by_all($pr_agent_id, $rt_rate_type_id) {
	global $lDB;

	if(!db_pr_agent_rate_exists_by_all($pr_agent_id, $rt_rate_type_id)) {
		return false;
	}

	$pr_agent_rate_ids = db_pr_agent_rate_get_by_all($pr_agent_id, $rt_rate_type_id);

	foreach($pr_agent_rate_ids as $pr_agent_rate_id) {
		db_pr_agent_rate_delete($pr_agent_rate_id);
	}
	db_pr_agent_prop_clear_rate_type($pr_agent_id, $rt_rate_type_id);

	// Apply new default if required
	$defaults = $lDB->get("
		SELECT
			COUNT(*)
		FROM
			pr_agent_rate
		WHERE
			pr_agent_rate_default_yn = '1'
	",4);
	if($defaults == 0 && db_pr_agent_rate_exists_by_agent($pr_agent_id)) {
		$pr_agent_rate_id = $lDB->get("
			SELECT
				pr_agent_rate_ix
			FROM
				pr_agent_rate
			WHERE
				pr_agent_id = '" . $lDB->escape($pr_agent_id) . "'
			LIMIT 1
		",4);
		return db_pr_agent_rate_set_default($pr_agent_rate_id);
	}
}

function db_pr_agent_rate_delete_by_agent($pr_agent_id) {
	global $lDB;

	if(!db_pr_agent_exists($pr_agent_id)) {
		return false;
	}

	$pr_agent_rate_ids = $lDB->get("
		SELECT pr_agent_rate_ix FROM pr_agent_rate WHERE pr_agent_id = '" . $lDB->escape($pr_agent_id) . "'
	",3);
	foreach($pr_agent_rate_ids as $pr_agent_rate_id) {
		db_pr_agent_rate_delete($pr_agent_rate_id);
	}

	return true;
}

function db_pr_agent_rate_set_default($pr_agent_rate_id) {
	global $lDB;

	if(!db_pr_agent_rate_exists($pr_agent_rate_id)) {
		return false;
	}

	$pr_agent_id = $lDB->get("SELECT pr_agent_id FROM pr_agent_rate WHERE pr_agent_rate_ix = '" . $lDB->escape($pr_agent_rate_id) . "'",4);
	$defaults = $lDB->get("SELECT pr_agent_rate_ix FROM pr_agent_rate WHERE pr_agent_id = '" . $lDB->escape($pr_agent_id) . "' AND pr_agent_rate_default_yn = '1'",3);
	foreach($defaults as $default_agent_rate_id) {
		$lDB->put("UPDATE pr_agent_rate SET pr_agent_rate_default_yn = '0' WHERE pr_agent_rate_ix = '" . $lDB->escape($default_agent_rate_id) . "'");
	}

	$lDB->put("UPDATE pr_agent_rate SET pr_agent_rate_default_yn = '1' WHERE pr_agent_rate_ix = '" . $lDB->escape($pr_agent_rate_id) . "'");
	
	return true;
}

function db_pr_agent_rate_set_default_by_all($pr_agent_id, $rt_rate_type_id) {
	if(!db_pr_agent_rate_exists_by_all($pr_agent_id, $rt_rate_type_id)) {
		return false;
	}

	$pr_agent_rate_ids = db_pr_agent_rate_get_by_all($pr_agent_id, $rt_rate_type_id);
	return db_pr_agent_rate_set_default($pr_agent_rate_ids[0]);
}

