<?php

function insert_bus_uploaded_image($pr_bus_image_filename, $pr_bus_image_desc, $pr_business_id) {
	global $lDB;
	global $dbcode;

	$lDB->put("
		INSERT INTO pr_bus_image (
			pr_bus_image.pr_bus_image_db,
			pr_bus_image.pr_bus_image_id,
			pr_bus_image.pr_bus_image_desc,
			pr_bus_image.pr_bus_image_filename,
			pr_bus_image.pr_business_id
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'',
			'".$lDB->escape($pr_bus_image_desc)."',
			'".$lDB->escape($pr_bus_image_filename)."',
			'".$lDB->escape($pr_business_id)."'
		)
	");

	$pr_bus_image_id = $lDB->insert_id;

	return $pr_bus_image_id;
}

function delete_bus_image($pr_bus_image_id) {
	global $lDB;

	$lDB->put("
		DELETE FROM 
			pr_bus_image 
		WHERE 
			pr_bus_image_ix = '$pr_bus_image_id'
	");
}


function get_bus_image_listing_names($pr_business_id) {
	global $lDB;
	global $principal_id;
	global $server;

	$imageList = $lDB->get("
		SELECT DISTINCT
			pr_bus_image.pr_bus_image_desc,
			pr_bus_image.pr_bus_image_filename,
			pr_bus_image.pr_bus_image_ix
		FROM
			pr_bus_image
		WHERE
			pr_bus_image.pr_business_id = '".$pr_business_id."'
		ORDER BY
			pr_bus_image.pr_bus_image_desc ASC
	",2);

	return $imageList;
}


function get_bus_image_listing_data($pr_business_id) {
	global $lDB;
	global $principal_id;
	global $domain;

	$imageList = $lDB->get("
		SELECT DISTINCT
			pr_bus_image.pr_bus_image_desc,
			pr_bus_image.pr_bus_image_filename,
			pr_bus_image.pr_bus_image_ix
		FROM
			pr_bus_image
		WHERE
			pr_bus_image.pr_business_id = '".$pr_business_id."'
		ORDER BY
			pr_bus_image.pr_bus_image_desc ASC
	",2);

	$imageData = array();

	foreach ($imageList as $image) {
		// Forcing http to avoid SSL errors on getimagesize function
		$imageFile = "http://".$GLOBALS['images_dir'].'/'.$principal_id.'/business_structure/'.$pr_business_id.'/'.$image['pr_bus_image_filename'];
		$realFile = __DIR__.'/../../../../../../../images/'.$principal_id.'/business_structure/'.$pr_business_id.'/'.$image['pr_bus_image_filename'];
		$imageName = substr( $imageFile, (strrpos($imageFile, "/")+ 1) );
		$imageExtension = strtoupper( substr( $imageFile, (strrpos($imageFile, ".")+ 1) ) );
		
        if (file_exists($imageFile)) {
            $imageSize = getimagesize($imageFile);
            $imageWidth = $imageHeight = $imageSize = 0;
            list($imageWidth, $imageHeight) = getimagesize($imageFile);
            $imageSize = ceil(filesize($realFile)/1000).'KB';
        } else {
            $imageSize = 0;
            $imageWidth = $imageHeight = $imageSize = 0;
            list($imageWidth, $imageHeight) = array(0, 0);
            $imageSize = '0KB';
        }
		
		$imageData[] = [
			"imageID" => $image['pr_bus_image_ix'],
			"imageFile" => $imageFile,
			"imageDescription" => $image['pr_bus_image_desc'],
			"imageName" => $imageName,
			"imageExtension" => $imageExtension,
			"imageSize" => $imageSize,
			"imageHeight" => $imageHeight,
			"imageWidth" => $imageWidth
		];
	}
	return $imageData;	
}

function get_bus_image_listing_html($pr_business_id) {
	$imageData = get_bus_image_listing_data($pr_business_id);
	$imageHtml = '<table width="100%" cellspacing="0" align="center" class="colLt">';

	foreach ($imageData as $image) {
		$imageHtml .= '<tr>
			<td width="10" valign="middle">
				<input type="checkbox" class="imageCheckbox" value="'.$image['imageID'].'" imageFile="'.$image['imageFile'].'">
			</td>
			<td valign="middle">
				<img src="'.$image['imageFile'].'" style="width:100px;">
			</td>
			<td valign="middle">
				<div>'.$image['imageDescription'].'</div>
				<div title="'.$image['imageFile'].'">'.$image['imageName'].'</div>
				<div>'.$image['imageExtension'].' - '.$image['imageSize'].' - '.$image['imageWidth'].' x '.$image['imageHeight'].'
			</td>
		</tr>
		<tr>
			<td height="5" colspan="3"><img src="/resource/Resrequest/Application/public/img/1x1.gif"></td>
		</tr>';
	}
	$imageHtml .= '</table>';

	return $imageHtml;
}
