<?php

/*
 * $Id: db.pr_bus_tax.php,v 1.1 2013-08-23 13:40:41 light Exp $
 *
 * $Log
 *
 */


/**
 * db.pr_bus_tax - Database functions for table pr_bus_tax
*/

require_once(__DIR__ . '/db.pr_business.php');
require_once(__DIR__ . '/db.rf_tax_rate.php');

function db_pr_bus_tax_exists($pr_bus_tax_id) {
	global $lDB;

	$check = $lDB->get("SELECT COUNT(pr_bus_tax_ix) FROM pr_bus_tax WHERE pr_bus_tax_ix = '$pr_bus_tax_id'",4);
	if($check > 0) { return true; } else { return false; }
}

function db_pr_bus_tax_exists_by_business($pr_business_id) {
	global $lDB;

	$check = $lDB->get("SELECT COUNT(pr_bus_tax_ix) FROM pr_bus_tax WHERE pr_business_id = '$pr_business_id'",4);
	if($check > 0) { return true; } else { return false; }
}

function db_pr_bus_tax_exists_by_all($pr_business_id,$rf_tax_rate_id) {
	global $lDB;

	$check = $lDB->get("SELECT COUNT(pr_bus_tax_ix) FROM pr_bus_tax WHERE pr_business_id = '$pr_business_id' AND rf_tax_rate_id = '$rf_tax_rate_id'",4);
	if($check > 0) { return true; } else { return false; }
}

function db_pr_bus_tax_insert($pr_business_id,$rf_tax_rate_id,$pr_bus_tax_seq) {
	global $dbcode;
	global $lDB;

	if(!db_pr_business_exists($pr_business_id)) {
		return false;
	}

	if(!db_rf_tax_rate_exists($rf_tax_rate_id)) {
		return false;
	}

	$lDB->put("
		INSERT INTO pr_bus_tax (
			pr_bus_tax_db,
			pr_business_id,
			rf_tax_rate_id,
			pr_bus_tax_seq
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($pr_business_id)."',
			'".$lDB->escape($rf_tax_rate_id)."',
			'".$lDB->escape($pr_bus_tax_seq)."'
		)
	");

	$pr_bus_tax_id = $lDB->insert_id;

	return $pr_bus_tax_id;
}

function db_pr_bus_tax_delete($pr_bus_tax_id) {
	global $lDB;

	if(!db_pr_bus_tax_exists($pr_bus_tax_id)) {
		return false;
	}

	$lDB->put("DELETE FROM pr_bus_tax WHERE pr_bus_tax.pr_bus_tax_ix = '$pr_bus_tax_id'");

	return true;
}

function db_pr_bus_tax_delete_by_business($pr_business_id) {
	global $lDB;

	if(!db_pr_business_exists($pr_business_id)) {
		return false;
	}

	$list = $lDB->get("SELECT pr_bus_tax_ix FROM pr_bus_tax WHERE pr_business_id = '$pr_business_id'",3);
	foreach($list as $pr_bus_tax_id) {
		db_pr_bus_tax_delete($pr_bus_tax_id);
	}
}

function db_pr_bus_tax_by_all($pr_business_id,$rf_tax_rate_id) {
	global $lDB;

	if(!db_pr_bus_tax_exists_by_all($pr_business_id,$rf_tax_rate_id)) {
		return 0;
	}

	return $lDB->get("SELECT pr_bus_tax_seq FROM pr_bus_tax WHERE pr_business_id = '$pr_business_id' AND rf_tax_rate_id = '$rf_tax_rate_id'",4);
}
