<?php

require_once(__DIR__ . '/db.fn_debtor.php');
require_once(__DIR__ . "/functions.persona.php");

define("DB_PR_BUSINESS_BILLING_RES_OFFICE",1);
define("DB_PR_BUSINESS_BILLING_PROPERTY",2);

function db_pr_business_exists($pr_business_id) {
	$check = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM pr_business WHERE pr_business_id = '$pr_business_id'",4);
	if($check > 0) {
		return true;
	} else {
		return false;
	}
}

function db_pr_business_ledger_update($pr_business_id, $fn_ledger_id_debtors, $fn_ledger_id_cash, $fn_debtor_id_cash, $fn_ledger_id_suspense, $fn_debtor_id_suspense, $fn_ledger_id_suspense_foreign, $fn_debtor_id_suspense_foreign, $fn_cost_centre_1_default_id, $pr_bus_post_tax_cost_ctr_yn, $pr_bus_post_level_gl, $pr_bus_post_level_dtrs, $pr_bus_post_env_id, $pr_bus_post_clear_dtrs_yn, $fn_system_email, $pr_bus_post_source_curr_yn, $fn_system_id, $pr_bus_post_pmt_yn, $pr_bus_ignore_past_pmt_yn, $pr_bus_post_dep_yn, $pr_bus_post_inv_yn,$fn_meal_component_default_id,$fn_ledger_id_input_vat,$pr_bus_post_inventory_yn,$pr_bus_post_in_po_yn,$pr_bus_api_url_po,$pr_bus_post_in_returns_yn,$pr_bus_api_url_returns,$pr_bus_post_in_cos_yn,$pr_bus_api_url_cos,$pr_bus_post_in_issues_yn,$pr_bus_api_url_issues,$pr_bus_post_in_trfs_yn,$pr_bus_api_url_transfers,$pr_bus_api_client,$pr_bus_api_token,$pr_bus_api_url_base) {
	global $lDB;

	if(db_pr_business_ledger_allow($pr_business_id)) {
		$systemSql = "";

		if (isCensysadUser()) {
			$systemSql = "
				fn_system_id = '" . $lDB->escape($fn_system_id) ."',
				pr_bus_post_pmt_yn = '" . $lDB->escape($pr_bus_post_pmt_yn) ."',
				pr_bus_ignore_past_pmt_yn = '" . $lDB->escape($pr_bus_ignore_past_pmt_yn) ."',
				pr_bus_post_dep_yn = '" . $lDB->escape($pr_bus_post_dep_yn) ."',
				pr_bus_post_inv_yn = '" . $lDB->escape($pr_bus_post_inv_yn) ."',
			";
		}

		$master = $lDB->isMaster;
		$lDB->isMaster = "1";
		$lDB->put("
			UPDATE 
				pr_business
			SET 
				fn_ledger_id_debtors = '".$lDB->escape($fn_ledger_id_debtors)."',
				fn_ledger_id_cash = '".$lDB->escape($fn_ledger_id_cash)."',
				fn_debtor_id_cash = '".$lDB->escape($fn_debtor_id_cash)."',
				fn_ledger_id_suspense = '".$lDB->escape($fn_ledger_id_suspense)."',
				fn_debtor_id_suspense = '".$lDB->escape($fn_debtor_id_suspense)."',
				fn_ledger_id_suspense_foreign = '".$lDB->escape($fn_ledger_id_suspense_foreign)."',
				fn_debtor_id_suspense_foreign = '".$lDB->escape($fn_debtor_id_suspense_foreign)."',
				fn_cost_centre_1_default_id = '".$lDB->escape($fn_cost_centre_1_default_id)."',
				pr_bus_post_tax_cost_ctr_yn = '".$lDB->escape($pr_bus_post_tax_cost_ctr_yn)."',
				pr_bus_post_source_curr_yn = '".$lDB->escape($pr_bus_post_source_curr_yn)."',
				pr_bus_post_level_gl = '".$lDB->escape($pr_bus_post_level_gl)."',
				pr_bus_post_level_dtrs = '".$lDB->escape($pr_bus_post_level_dtrs)."',
				pr_bus_post_env_id = '".$lDB->escape($pr_bus_post_env_id)."',
				pr_bus_post_clear_dtrs_yn = '".$lDB->escape($pr_bus_post_clear_dtrs_yn)."',

				fn_ledger_id_input_vat = '".$lDB->escape($fn_ledger_id_input_vat)."',
				pr_bus_post_inventory_yn = '".$lDB->escape($pr_bus_post_inventory_yn)."',
				pr_bus_post_in_po_yn = '".$lDB->escape($pr_bus_post_in_po_yn)."',
				pr_bus_post_in_returns_yn = '".$lDB->escape($pr_bus_post_in_returns_yn)."',
				pr_bus_post_in_cos_yn = '".$lDB->escape($pr_bus_post_in_cos_yn)."',
				pr_bus_post_in_issues_yn = '".$lDB->escape($pr_bus_post_in_issues_yn)."',
				pr_bus_post_in_trfs_yn = '".$lDB->escape($pr_bus_post_in_trfs_yn)."',
				pr_bus_api_client = '".$lDB->escape($pr_bus_api_client)."',
				pr_bus_api_token = '".$lDB->escape($pr_bus_api_token)."',
				pr_bus_api_url_base = '".$lDB->escape($pr_bus_api_url_base)."',
				pr_bus_api_url_po = '".$lDB->escape($pr_bus_api_url_po)."',
				pr_bus_api_url_returns = '".$lDB->escape($pr_bus_api_url_returns)."',
				pr_bus_api_url_cos = '".$lDB->escape($pr_bus_api_url_cos)."',
				pr_bus_api_url_issues = '".$lDB->escape($pr_bus_api_url_issues)."',
				pr_bus_api_url_transfers = '".$lDB->escape($pr_bus_api_url_transfers)."',
				
				$systemSql
				fn_system_email = '".$lDB->escape($fn_system_email)."',
				fn_meal_component_default_id = '".$lDB->escape($fn_meal_component_default_id)."'
			WHERE
				pr_business.pr_business_id = '$pr_business_id' 
		");
		$lDB->isMaster = $master;
		return true;
	} else {
		return false;
	}
}

function db_pr_business_ledger_allow($pr_business_id) {
	global $dbcode;
	global $lDB;

	$post_dbcode = $lDB->get("
		SELECT
			rf_database.rf_db_code
		FROM
			pr_business
			INNER JOIN rf_database ON rf_database.rf_database_id = pr_business.pr_bus_post_env_id
		WHERE
			pr_business_id = '$pr_business_id'
	",4);

	if($post_dbcode == "0" || trim($post_dbcode) == "") {
		$post_dbcode = $dbcode;
	}

	if($post_dbcode == $dbcode) {
		return true;
	} else {
		return false;
	}
}

function db_pr_business_get_billing($pr_business_id, $type=false) {
	// See DB_PR_BUSINESS_BILLING_* constants for types
	global $lDB;

	$billingId = "";
	$currId = $pr_business_id;
	while(empty($billingId) && !empty($currId)) {
		if(
			(
				!$GLOBALS['isPropServer']
				&& $type === false
			) || (
				$type === DB_PR_BUSINESS_BILLING_RES_OFFICE
			)
		) {
			$billingYN = $lDB->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
		} else {
			$billingYN = $lDB->get("SELECT pr_bus_billing_prop_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
		}
		if($billingYN == "1") {
			$billingId = $currId;
		} else {
			$currId = $lDB->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
		}
	}
	if(empty($billingId)) {
		return false;
	}

	return $billingId;
}

function db_pr_business_gps_update($pr_business_id, $pr_bus_prop_latitude, $pr_bus_prop_longitude) {
	global $lDB;

	$lDB->put("
		UPDATE 
			pr_business
		SET 
			pr_business.pr_bus_prop_latitude = '".$lDB->escape($pr_bus_prop_latitude)."',
			pr_business.pr_bus_prop_longitude = '".$lDB->escape($pr_bus_prop_longitude)."'
		WHERE
			pr_business.pr_business_id = '$pr_business_id' 
	");
}

function db_pr_business_set_cash_debtor($pr_business_id, $fn_debtor_id) {
	global $lDB;

	if(!db_pr_business_exists($pr_business_id)) {
		return false;
	}

	if(!db_fn_debtor_exists($fn_debtor_id)) {
		$fn_debtor_id = "";
	}

	$lDB->put("
		UPDATE 
			pr_business
		SET
			fn_debtor_id_cash = '".$lDB->escape($fn_debtor_id)."'
		WHERE
			pr_business.pr_business_id = '$pr_business_id' 
	");
}

function db_pr_business_is_property($pr_business_id) {
	global $lDB;

	$check = $lDB->get("
		SELECT COUNT(*) FROM pr_business WHERE
			pr_business_id = '" . $lDB->escape($pr_business_id) . "'
			AND pr_bus_property_yn = '1'
	",4);

	if($check > 0) {
		return true;
	} else {
		return false;
	}
}

function db_pr_business_get_properties($pr_business_id, $type=false) {
	// See DB_PR_BUSINESS_BILLING_* constants for types
	global $lDB;
	if(
		(
			!$GLOBALS['isPropServer']
			&& $type === false
		) || (
			$type === DB_PR_BUSINESS_BILLING_RES_OFFICE
		)
	) {
		$billingCheck = "pr_business.pr_bus_billing_yn = '0'";
	} else {
		$billingCheck = "pr_business.pr_bus_billing_prop_yn = '0'";
	}

	$properties = [];
	$children = [$pr_business_id];
	while($child = array_shift($children)) {
		if(db_pr_business_is_property($child)) {
			$properties[] = $child;
		}
		$children = array_merge($children, $lDB->get("
			SELECT pr_business_id FROM pr_business WHERE
				pr_business_parent = '" . $lDB->escape($child) . "'
				AND $billingCheck
		",3));
	}
	
	return $properties;
}

function db_pr_business_is_inventory($pr_business_id) {
	global $lDB;
	return $lDB->get("SELECT pr_bus_post_inventory_yn FROM pr_business WHERE pr_business_id = '" . $pr_business_id . "'",4);
}
