<?php

require_once(__DIR__ . "/db.rc_event.php");
require_once(__DIR__ . "/db.rc_action.php");

function db_pr_event_exists($pr_event_id) {
	$eventCheck = $GLOBALS['lDB']->get("
		SELECT
			COUNT(pr_event_ix)
		FROM
			pr_event
		WHERE
			pr_event_ix = '$pr_event_id'
	",4);
	if($eventCheck > 0) {
		return true;
	} else {
		return false;
	}
}

function db_pr_event_insert($rc_action_id, $rc_event_id, $pr_event_date="0000-00-00", $pr_event_note="", $pr_event_duration="", $pr_event_completed_yn='0') {
	global $lDB;
	if(!db_rc_action_exists($rc_action_id)) {
		return false;
	}
	if(!db_rc_event_exists($rc_event_id)) {
		return false;
	}
	$pr_event_completed_date = "0000-00-00 00:00:00";
	if($pr_event_completed_yn == "1") {
		$pr_event_completed_date = date("Y-m-d H:i:s");
	}
	$pr_event_completed_date_tz = date("e");
	$lDB->put ("
		INSERT INTO
			pr_event (
				pr_event_db,
				rc_action_id,
				pr_event_date,
				pr_event_completed_date,
				pr_event_completed_date_tz,
				rc_event_id,
				pr_event_note,
				pr_event_duration,
				pr_event_completed_yn
			) VALUES (
				'".$lDB->escape($GLOBALS['dbcode'])."',
				'".$lDB->escape($rc_action_id)."',
				'".$lDB->escape($pr_event_date)."',
				'".$lDB->escape($pr_event_completed_date)."',
				'".$lDB->escape($pr_event_completed_date_tz)."',
				'".$lDB->escape($rc_event_id)."',
				'".$lDB->escape($pr_event_note)."',
				'".$lDB->escape($pr_event_duration)."',
				'".$lDB->escape($pr_event_completed_yn)."'
			)
	");
	
	$pr_event_id = $GLOBALS['lDB']->insert_id;

	return $pr_event_id;	
}

function db_pr_event_update ($pr_event_id, $rc_action_id, $rc_event_id, $pr_event_date="0000-00-00", $pr_event_note="", $pr_event_duration="", $pr_event_completed_yn='0') {
	global $lDB;
	if(!db_pr_event_exists($pr_event_id)) {
		return false;
	}
	if(!db_rc_action_exists($rc_action_id)) {
		return false;
	}
	if(!db_rc_event_exists($rc_event_id)) {
		return false;
	}
	$pr_event_completed_date = "0000-00-00 00:00:00";
	if($pr_event_completed_yn == "1") {
		$pr_event_completed_date = date("Y-m-d H:i:s");
	}
	$pr_event_completed_date_tz = date("e");
	
	$lDB->put("
		UPDATE
			pr_event
		SET
			rc_action_id = '".$lDB->escape($rc_action_id)."',
			rc_event_id = '".$lDB->escape($rc_event_id)."',
			pr_event_date = '".$lDB->escape($pr_event_date)."',
			pr_event_completed_date = '".$lDB->escape($pr_event_completed_date)."',
			pr_event_completed_date_tz = '".$lDB->escape($pr_event_completed_date_tz)."',
			pr_event_note = '".$lDB->escape($pr_event_note)."',
			pr_event_duration = '".$lDB->escape($pr_event_duration)."',
			pr_event_completed_yn = '".$lDB->escape($pr_event_completed_yn)."'
		WHERE
			pr_event_ix = '$pr_event_id'
	");
}

function db_pr_event_set_inactive($pr_event_id,$pr_event_inactive_yn=1) {
	global $lDB;
	if(!db_pr_event_exists($pr_event_id)) {
		return false;
	}
	$lDB->put("
		UPDATE
			pr_event
		SET
			pr_event_inactive_yn = '".$lDB->escape($pr_event_inactive_yn)."'
		WHERE
			pr_event_ix = '$pr_event_id'
	");
}

function db_pr_event_delete($pr_event_id) {
	if(!db_pr_event_exists($pr_event_id)) {
		return false;
	}
	$GLOBALS['lDB']->put("
		DELETE
		FROM
			pr_event
		WHERE
			pr_event_ix = '$pr_event_id'
	");
}

function db_pr_event_count_action($rc_action_id) {
	if(!db_rc_action_exists($rc_action_id)) {
		return false;
	}
	$count = $GLOBALS['lDB']->get("SELECT COUNT(rc_action_id) FROM pr_event WHERE rc_action_id = '$rc_action_id'", 4);
	return $count; 
}

function db_pr_event_count_event($rc_event_id) {
	if(!db_rc_event_exists($rc_event_id)) {
		return false;
	}
	$count = $GLOBALS['lDB']->get("SELECT COUNT(rc_event_id) FROM pr_event WHERE rc_event_id = '$rc_event_id'", 4);
	return $count; 
}
