<?php

require_once(__DIR__ . "/db.pr_event.php");
require_once(__DIR__ . "/db.pr_persona.php");

function db_pr_event_persona_exists($pr_event_persona_id) {
	$eventCheck = $GLOBALS['lDB']->get("
		SELECT
			COUNT(pr_event_persona_ix)
		FROM
			pr_event_persona
		WHERE
			pr_event_persona_ix = '$pr_event_persona_id'
	",4);
	if($eventCheck > 0) {
		return true;
	} else {
		return false;
	}
}

function db_pr_event_persona_insert($pr_event_id, $pr_persona_id, $pr_event_rep_ind="0", $pr_event_inactive_yn='0') {
	global $lDB;
	if(!db_pr_event_exists($pr_event_id)) {
		return false;
	}
	if(!db_pr_persona_exists($pr_persona_id)) {
		return false;
	}	
	$lDB->put ("
		INSERT INTO
			pr_event_persona (
				pr_event_persona_db,
				pr_event_id,
				pr_persona_id,
				pr_event_rep_ind,
				pr_event_inactive_yn
			) VALUES (
				'".$lDB->escape($GLOBALS['dbcode'])."',
				'".$lDB->escape($pr_event_id)."',
				'".$lDB->escape($pr_persona_id)."',
				'".$lDB->escape($pr_event_rep_ind)."',
				'".$lDB->escape($pr_event_inactive_yn)."'
			)
	");
	
	$pr_event_persona_id = $GLOBALS['lDB']->insert_id;

	return $pr_event_persona_id;
}

function db_pr_event_persona_update ($pr_event_persona_id, $pr_event_id, $pr_persona_id, $pr_event_rep_ind="0", $pr_event_inactive_yn='0') {
	global $lDB;
	if(!db_pr_event_persona_exists($pr_event_persona_id)) {
		return false;
	}
	if(!db_pr_event_exists($pr_event_id)) {
		return false;
	}
	if(!db_pr_persona_exists($pr_persona_id)) {
		return false;
	}	
	
	$lDB->put("
		UPDATE
			pr_event_persona
		SET
			pr_event_id = '".$lDB->escape($pr_event_id)."',
			pr_persona_id = '".$lDB->escape($pr_persona_id)."',
			pr_event_rep_ind = '".$lDB->escape($pr_event_rep_ind)."',
			pr_event_inactive_yn = '".$lDB->escape($pr_event_inactive_yn)."'
		WHERE
			pr_event_persona_ix = '$pr_event_persona_id'
	");
}

function db_pr_event_persona_set_inactive($pr_event_persona_id,$pr_event_persona_inactive_yn=1) {
	global $lDB;
	if(!db_pr_event_persona_exists($pr_event_persona_id)) {
		return false;
	}
	$lDB->put("
		UPDATE
			pr_event_persona
		SET
			pr_event_persona_inactive_yn = '".$lDB->escape($pr_event_persona_inactive_yn)."'
		WHERE
			pr_event_persona_ix = '$pr_event_persona_id'
	");
}

function db_pr_event_persona_delete($pr_event_persona_id) {
	if(!db_pr_event_persona_exists($pr_event_persona_id)) {
		return false;
	}
	$GLOBALS['lDB']->put("
		DELETE
		FROM
			pr_event_persona
		WHERE
			pr_event_persona_ix = '$pr_event_persona_id'
	");
}

function db_pr_event_get_event_persona($pr_event_id, $pr_event_rep_ind="0") {
	$pr_event_persona_id = $GLOBALS['lDB']->get("
		SELECT
			pr_event_persona_ix
		FROM
			pr_event_persona
		WHERE
			pr_event_id = '$pr_event_id'
			AND pr_event_rep_ind = '$pr_event_rep_ind'
	",4);
	
	return $pr_event_persona_id;
	
}

function db_pr_event_set_rep ($pr_event_persona_id, $pr_persona_id) {
	global $lDB;
	if(!db_pr_event_persona_exists($pr_event_persona_id)) {
		return false;
	}
	
	if(!db_pr_persona_exists($pr_persona_id)) {
		return false;
	}
	
	$lDB->put("
		UPDATE
			pr_event_persona
		SET
			pr_persona_id = '".$lDB->escape($pr_persona_id)."'
		WHERE
			pr_event_persona_ix = '$pr_event_persona_id'
	");
}
