<?php
require_once(__DIR__ . "/db.pr_guest.php");
require_once(__DIR__ . "/db.rf_obj_guest.php");

function db_pr_guest_obj_data_exists($fieldVal, $field = "pr_guest_obj_data_ix", $ignoreEmpty=true) {
	global $lDB;

	$extraWhere = "";
	if($ignoreEmpty) {
		$extraWhere = "
			AND (
				pr_guest_obj_data_text != ''
				OR pr_guest_obj_data_text != ''
				OR rf_obj_guest_data_id != ''
			)
		";
	}
	$check = $lDB->get("
		SELECT
			COUNT(pr_guest_obj_data_ix)
		FROM
			pr_guest_obj_data
		WHERE
			$field = '$fieldVal'
			$extraWhere
	",4);
	if($check > 0) { 
		return true; 
	} else { 
		return false; 
	}
}

function db_pr_guest_obj_data_exists_by_guest($pr_guest_id, $rf_obj_guest_id) {
	global $lDB;

	$check = $lDB->get("SELECT COUNT(pr_guest_obj_data_ix) FROM pr_guest_obj_data WHERE pr_guest_id = '$pr_guest_id' AND rf_obj_guest_id = '$rf_obj_guest_id'",4);
	if($check > 0) { 
		return true; 
	} else { 
		return false; 
	}
}

function db_pr_guest_obj_data_select_by_guest($pr_guest_id, $rf_obj_guest_id) {
	global $lDB;

	$pr_guest_obj_data_ix = $lDB->get("SELECT pr_guest_obj_data_ix FROM pr_guest_obj_data WHERE pr_guest_id = '$pr_guest_id' AND rf_obj_guest_id = '$rf_obj_guest_id'",4);
	if($pr_guest_obj_data_ix != '') { 
		return $pr_guest_obj_data_ix; 
	} else { 
		return false; 
	}
}

function db_pr_guest_obj_data_field_by_type($rf_obj_guest_type_ind) {
	switch($rf_obj_guest_type_ind) {
	case DB_RF_OBJ_GUEST_TEXTAREA:
		return 'pr_guest_obj_data_memo';
	case DB_RF_OBJ_GUEST_RADIO:
	case DB_RF_OBJ_GUEST_SELECTBOX:
	case DB_RF_OBJ_GUEST_CHECKBOX:
		return 'rf_obj_guest_data_id';
	case DB_RF_OBJ_GUEST_NATION_LOOKUP:
	case DB_RF_OBJ_GUEST_TEXTBOX:
	case DB_RF_OBJ_GUEST_NUMERIC:
	case DB_RF_OBJ_GUEST_DATE:
	default:
		return 'pr_guest_obj_data_text';
	}
}

function db_pr_guest_obj_data_get_all($pr_guest_obj_data_id) {
	global $lDB;

	if(!db_pr_guest_obj_data_exists($pr_guest_obj_data_id,"pr_guest_obj_data_ix",false)) {
		return false;
	}

	$pr_guest_obj_data = $lDB->get("
		SELECT
			pr_guest_obj_data.rf_obj_guest_id,
			pr_guest_obj_data.pr_guest_obj_data_memo,
			pr_guest_obj_data.pr_guest_obj_data_text,
			pr_guest_obj_data.rf_obj_guest_data_id,
			rf_obj_guest.rf_obj_guest_type_ind
		FROM
			pr_guest_obj_data
			INNER JOIN rf_obj_guest ON rf_obj_guest.rf_obj_guest_ix = pr_guest_obj_data.rf_obj_guest_id
		WHERE
			pr_guest_obj_data.pr_guest_obj_data_ix = '".$lDB->escape($pr_guest_obj_data_id)."'
	",1);

	$value = $pr_guest_obj_data[db_pr_guest_obj_data_field_by_type($pr_guest_obj_data['rf_obj_guest_type_ind'])];
	return db_rf_obj_guest_get_all($pr_guest_obj_data['rf_obj_guest_id'], $value);
}

function db_pr_guest_obj_data_insert($pr_guest_id, $rf_obj_guest_id, $pr_guest_obj_data_content) {
	global $lDB;
	global $dbcode;
	if(!db_pr_guest_exists($pr_guest_id)) {
		return false;
	}
	
	if(!db_rf_obj_guest_exists($rf_obj_guest_id)) {
		return false;
	}


	$data_field = db_pr_guest_obj_data_field_by_type(db_rf_obj_guest_select_type($rf_obj_guest_id));

	$lDB->put("
		INSERT INTO pr_guest_obj_data (
			pr_guest_obj_data_db,
			$data_field,
			pr_guest_id,
			rf_obj_guest_id
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($pr_guest_obj_data_content)."',
			'".$lDB->escape($pr_guest_id)."',
			'".$lDB->escape($rf_obj_guest_id)."'
		)
	");
	
	$pr_guest_obj_data_id = $lDB->insert_id;

	return $pr_guest_obj_data_id;	
}

function db_pr_guest_obj_data_update($pr_guest_obj_data_id, $rf_obj_guest_id,$pr_guest_obj_data_content ) {
	global $lDB;

	$data_field = db_pr_guest_obj_data_field_by_type(db_rf_obj_guest_select_type($rf_obj_guest_id));
	
	$lDB->put("
		UPDATE pr_guest_obj_data SET
			$data_field = '".$lDB->escape($pr_guest_obj_data_content)."'
		WHERE
			pr_guest_obj_data_ix = '$pr_guest_obj_data_id' 
	");
}

function db_pr_guest_obj_data_delete($pr_guest_obj_data_id) {
	global $lDB;

	if(!db_pr_guest_obj_data_exists($pr_guest_obj_data_id,"pr_guest_obj_data_ix",false)) {
		return false;
	}
	$res = $lDB->put("
		DELETE FROM 
			pr_guest_obj_data 
		WHERE 
			pr_guest_obj_data_ix = '$pr_guest_obj_data_id'
	");
	
	return $res;
}

function db_pr_guest_obj_data_select($rf_obj_guest_id) {
	global $lDB;
	
	$obj_guest_data = $lDB->get("SELECT * FROM rf_obj_guest_data WHERE rf_obj_guest_id = '$rf_obj_guest_id' ORDER BY rf_obj_guest_data_sort_seq", 2);

	if(count($obj_guest_data) > 0) {
		return $obj_guest_data; 
	} else { 
		return false; 
	}
}
