<?php

require_once(__DIR__ . '/class.audit.php');
require_once(__DIR__ . "/db.ad_persona_detail.php");
require_once(__DIR__ . "/db.rf_title.php");
require_once(__DIR__ . "/db.rf_name_suffix.php");
require_once(__DIR__ . "/db.rf_country.php");
require_once(__DIR__ . "/db.rf_comms_preference.php");

function db_pr_persona_exists($pr_persona_id) {
	global $lDB;

	$personaCheck = $lDB->get("SELECT COUNT(pr_persona_ix) FROM pr_persona WHERE pr_persona_ix = '".$lDB->escape($pr_persona_id)."'",4);
	if($personaCheck > 0) { return true; } else { return false; }
}

function db_pr_persona_insert($pr_org_yn,$pr_name_last,$pr_name_first='',$pr_title_id='',$pr_name_suffix_id='',$pr_email='',$pr_corr_addr_line1='',$pr_corr_addr_line2='',$pr_corr_addr_line3='',$pr_corr_city='',$pr_corr_country_id='',$pr_corr_post_code='',$pr_phys_addr_line1='',$pr_phys_addr_line2='',$pr_phys_addr_line3='',$pr_phys_city='',$pr_phys_country_id='',$pr_phys_post_code='',$rf_comms_preference_id='',$pr_web_addr='',$pr_statutory_1='',$pr_statutory_2='',$pr_statutory_3='',$pr_persona_link_id='',$pr_persona_fwd_id='') {
	global $lDB;

	if($pr_org_yn) {
		$pr_org_yn = "1";
	} else {
		$pr_org_yn = "0";
	}

	if(!db_rf_title_exists($pr_title_id)) {
		$pr_title_id = "";
	}

	if(!db_rf_name_suffix_exists($pr_name_suffix_id)) {
		$pr_name_suffix_id = "";
	}

	if(!db_rf_country_exists($pr_corr_country_id)) {
		$pr_corr_country_id = "0";
	}

	if(!db_rf_country_exists($pr_phys_country_id)) {
		$pr_phys_country_id = "0";
	}

	if(!db_rf_comms_preference_exists($rf_comms_preference_id)) {
		$rf_comms_preference_id = "0";
	}

	if(!db_pr_persona_exists($pr_persona_link_id)) {
		$pr_persona_link_id = "0";
	}

	if(!db_pr_persona_exists($pr_persona_fwd_id)) {
		$pr_persona_fwd_id = "0";
	}


	$lDB->put("
		INSERT INTO pr_persona (
			pr_persona_db,
			pr_org_yn,
			pr_name_last,
			pr_name_first,
			pr_title_id,
			pr_name_suffix_id,
			pr_email,
			pr_corr_addr_line1,
			pr_corr_addr_line2,
			pr_corr_addr_line3,
			pr_corr_city,
			pr_corr_country_id,
			pr_corr_post_code,
			pr_phys_addr_line1,
			pr_phys_addr_line2,
			pr_phys_addr_line3,
			pr_phys_city,
			pr_phys_country_id,
			pr_phys_post_code,
			rf_comms_preference_id,
			pr_web_addr,
			pr_statutory_1,
			pr_statutory_2,
			pr_statutory_3,
			pr_persona_link_id,
			pr_persona_fwd_id
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'".$lDB->escape($pr_org_yn)."',
			'".$lDB->escape($pr_name_last)."',
			'".$lDB->escape($pr_name_first)."',
			'".$lDB->escape($pr_title_id)."',
			'".$lDB->escape($pr_name_suffix_id)."',
			'".$lDB->escape($pr_email)."',
			'".$lDB->escape($pr_corr_addr_line1)."',
			'".$lDB->escape($pr_corr_addr_line2)."',
			'".$lDB->escape($pr_corr_addr_line3)."',
			'".$lDB->escape($pr_corr_city)."',
			'".$lDB->escape($pr_corr_country_id)."',
			'".$lDB->escape($pr_corr_post_code)."',
			'".$lDB->escape($pr_phys_addr_line1)."',
			'".$lDB->escape($pr_phys_addr_line2)."',
			'".$lDB->escape($pr_phys_addr_line3)."',
			'".$lDB->escape($pr_phys_city)."',
			'".$lDB->escape($pr_phys_country_id)."',
			'".$lDB->escape($pr_phys_post_code)."',
			'".$lDB->escape($rf_comms_preference_id)."',
			'".$lDB->escape($pr_web_addr)."',
			'".$lDB->escape($pr_statutory_1)."',
			'".$lDB->escape($pr_statutory_2)."',
			'".$lDB->escape($pr_statutory_3)."',
			'".$lDB->escape($pr_persona_link_id)."',
			'".$lDB->escape($pr_persona_fwd_id)."'
		)
	");
	$pr_persona_id = $lDB->insert_id;

	if(!empty($pr_persona_id)) {
		$audit = new AuditTrail($pr_persona_id,TYPE_PERSONA);
		$audit->addDetail("", $pr_org_yn, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_org_yn");
		$audit->addDetail("", $pr_name_last, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_name_last");
		$audit->addDetail("", $pr_name_first, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_name_first");
		$audit->addDetail("", $pr_title_id, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_title_id");
		$audit->addDetail("", $pr_name_suffix_id, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_name_suffix_id");
		$audit->addDetail("", $pr_email, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_email");
		$audit->addDetail("", $pr_corr_addr_line1, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_corr_addr_line1");
		$audit->addDetail("", $pr_corr_addr_line2, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_corr_addr_line2");
		$audit->addDetail("", $pr_corr_addr_line3, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_corr_addr_line3");
		$audit->addDetail("", $pr_corr_city, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_corr_city");
		$audit->addDetail("", $pr_corr_country_id, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_corr_country_id");
		$audit->addDetail("", $pr_corr_post_code, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_corr_post_code");
		$audit->addDetail("", $pr_phys_addr_line1, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_phys_addr_line1");
		$audit->addDetail("", $pr_phys_addr_line2, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_phys_addr_line2");
		$audit->addDetail("", $pr_phys_addr_line3, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_phys_addr_line3");
		$audit->addDetail("", $pr_phys_city, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_phys_city");
		$audit->addDetail("", $pr_phys_country_id, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_phys_country_id");
		$audit->addDetail("", $pr_phys_post_code, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_phys_post_code");
		$audit->addDetail("", $pr_web_addr, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_web_addr");
		$audit->addDetail("", $pr_statutory_1, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_statutory_1");
		$audit->addDetail("", $pr_statutory_2, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_statutory_2");
		$audit->addDetail("", $pr_statutory_3, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_statutory_3");
		$audit->addDetail("", $pr_persona_link_id, "", $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "persona", "pr_persona.pr_persona_link_id");
		$audit->save("Contact details (Add)");
	}

	return $pr_persona_id;
}

function db_pr_persona_update($pr_persona_id,$pr_name_last,$pr_name_first='',$pr_title_id='',$pr_name_suffix_id='',$pr_email='',$pr_corr_addr_line1='',$pr_corr_addr_line2='',$pr_corr_addr_line3='',$pr_corr_city='',$pr_corr_country_id='',$pr_corr_post_code='',$pr_phys_addr_line1='',$pr_phys_addr_line2='',$pr_phys_addr_line3='',$pr_phys_city='',$pr_phys_country_id='',$pr_phys_post_code='',$rf_comms_preference_id='',$pr_web_addr=false,$pr_statutory_1=false,$pr_statutory_2=false,$pr_statutory_3=false,$pr_persona_link_id=false,$pr_persona_fwd_id=false) {
	global $lDB;

	if(!db_pr_persona_exists($pr_persona_id)) {
		return false;
	}	

	if(!db_rf_title_exists($pr_title_id)) {
		$pr_title_id = "";
	}

	if(!db_rf_name_suffix_exists($pr_name_suffix_id)) {
		$pr_name_suffix_id = "";
	}

	if(!db_rf_country_exists($pr_corr_country_id)) {
		$pr_corr_country_id = "0";
	}

	if(!db_rf_country_exists($pr_phys_country_id)) {
		$pr_phys_country_id = "0";
	}

	if(!db_rf_comms_preference_exists($rf_comms_preference_id)) {
		$rf_comms_preference_id = "0";
	}

	if(!db_pr_persona_exists($pr_persona_link_id)) {
		$pr_persona_link_id = false;
	}

	if(!db_pr_persona_exists($pr_persona_fwd_id)) {
		$pr_persona_fwd_id = false;
	}


	$extra = array();
	if($pr_web_addr !== false) {
		$extra['pr_web_addr'] = $pr_web_addr;
	}
	if($pr_statutory_1 !== false) {
		$extra['pr_statutory_1'] = $pr_statutory_1;
	}
	if($pr_statutory_2 !== false) {
		$extra['pr_statutory_2'] = $pr_statutory_2;
	}
	if($pr_statutory_3 !== false) {
		$extra['pr_statutory_3'] = $pr_statutory_3;
	}
	if($pr_persona_link_id !== false) {
		$extra['pr_persona_link_id'] = $pr_persona_link_id;
	}
	if($pr_persona_fwd_id !== false) {
		$extra['pr_persona_fwd_id'] = $pr_persona_fwd_id;
	}

	$extraSQL = "";	
	if(sizeof($extra) > 0) {
		$extra = "";
		foreach($extra as $key=>$item) {
			$extra[$key] = "$key = '$item'";
		}
		$extraSQL = "," . join(",",$extra);
	}

	$current = $lDB->get("
		SELECT
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			pr_persona.pr_title_id,
			pr_persona.pr_name_suffix_id,
			pr_persona.pr_email,
			pr_persona.pr_corr_addr_line1,
			pr_persona.pr_corr_addr_line2,
			pr_persona.pr_corr_addr_line3,
			pr_persona.pr_corr_city,
			pr_persona.pr_corr_country_id,
			pr_persona.pr_corr_post_code,
			pr_persona.pr_phys_addr_line1,
			pr_persona.pr_phys_addr_line2,
			pr_persona.pr_phys_addr_line3,
			pr_persona.pr_phys_city,
			pr_persona.pr_phys_country_id,
			pr_persona.pr_phys_post_code,
			pr_persona.pr_web_addr,
			pr_persona.pr_statutory_1,
			pr_persona.pr_statutory_2,
			pr_persona.pr_statutory_3,
			pr_persona.pr_persona_link_id
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '".$lDB->escape($pr_persona_id)."'
	",6)[0];
	$audit = new AuditTrail($pr_persona_id,TYPE_PERSONA);
	$changes = false;
	foreach($current as $field=>$oldValue) {
		if(array_key_exists($field,$extra)) {
			$newValue = $extra[$field];
		} else {
			$newValue = $oldValue;
		}
		if($newValue != $oldValue) {
			$changes = true;
			$audit->addDetail($oldValue, $newValue, $pr_persona_id, $pr_persona_id, DB_AD_PERSONA_DETAIL_ACTION_EDIT, "persona", "pr_persona.".$field);
		}
	}
	if($changes) {
		$audit->save("Contact details (Edit)");
	}
	
	$lDB->put("
		UPDATE pr_persona SET
			pr_name_last = '".$lDB->escape($pr_name_last)."',
			pr_name_first = '".$lDB->escape($pr_name_first)."',
			pr_title_id = '".$lDB->escape($pr_title_id)."',
			pr_name_suffix_id = '".$lDB->escape($pr_name_suffix_id)."',
			pr_email = '".$lDB->escape($pr_email)."',
			pr_corr_addr_line1 = '".$lDB->escape($pr_corr_addr_line1)."',
			pr_corr_addr_line2 = '".$lDB->escape($pr_corr_addr_line2)."',
			pr_corr_addr_line3 = '".$lDB->escape($pr_corr_addr_line3)."',
			pr_corr_city = '".$lDB->escape($pr_corr_city)."',
			pr_corr_country_id = '".$lDB->escape($pr_corr_country_id)."',
			pr_corr_post_code = '".$lDB->escape($pr_corr_post_code)."',
			pr_phys_addr_line1 = '".$lDB->escape($pr_phys_addr_line1)."',
			pr_phys_addr_line2 = '".$lDB->escape($pr_phys_addr_line2)."',
			pr_phys_addr_line3 = '".$lDB->escape($pr_phys_addr_line3)."',
			pr_phys_city = '".$lDB->escape($pr_phys_city)."',
			pr_phys_country_id = '".$lDB->escape($pr_phys_country_id)."',
			pr_phys_post_code = '".$lDB->escape($pr_phys_post_code)."',
			rf_comms_preference_id = '".$lDB->escape($rf_comms_preference_id)."'
			$extraSQL
		WHERE
			pr_persona_ix = '$pr_persona_id'
	");
}


function db_pr_persona_update_identity($pr_persona_id, $pr_identity_no) {
	global $lDB;
	if(!db_pr_persona_exists($pr_persona_id)) {
		return false;
	}
	$lDB->put("
		UPDATE
			pr_persona
		SET
			pr_identity_no = '".$lDB->escape($pr_identity_no)."'
		WHERE
			pr_persona_ix = '$pr_persona_id'
	");

}

function db_pr_persona_update_birthdate($pr_persona_id, $pr_birthdate) {
	global $lDB;
	if(!db_pr_persona_exists($pr_persona_id)) {
		return false;
	}
	
	$lDB->put("
		UPDATE
			pr_persona
		SET
			pr_birthdate = '".$lDB->escape($pr_birthdate)."'
		WHERE
			pr_persona_ix = '$pr_persona_id'
	");

}

function db_pr_persona_update_anniversary($pr_persona_id, $pr_anniversary) {
	global $lDB;
	if(!db_pr_persona_exists($pr_persona_id)) {
		return false;
	}
	$lDB->put("
		UPDATE
			pr_persona
		SET
			pr_anniversary = '".$lDB->escape($pr_anniversary)."'
		WHERE
			pr_persona_ix = '$pr_persona_id'
	");

}

function db_pr_persona_set_name($pr_persona_id, $pr_name_last, $pr_name_first=false, $pr_title_id=false, $pr_name_suffix_id=false) {
	global $lDB;
	if(!db_pr_persona_exists($pr_persona_id)) {
		return false;
	}

	$sql = "UPDATE pr_persona SET pr_name_last = '".$lDB->escape($pr_name_last)."'";
	if(isset($pr_name_first)) {
		$sql .= ", pr_name_first = '".$lDB->escape($pr_name_first)."'"; 
	}
	if(isset($pr_title_id)) {
		$sql .= ", pr_title_id = '".$lDB->escape($pr_title_id)."'"; 
	}
	if(isset($pr_name_suffix_id)) {
		$sql .= ", pr_name_suffix_id = '".$lDB->escape($pr_name_suffix_id)."'"; 
	}
	$sql .= " WHERE pr_persona_ix = '$pr_persona_id'";
	
	$lDB->put($sql);

}

function db_pr_persona_select($pr_persona_id) {
	global $lDB;
	
	if(db_pr_persona_exists($pr_persona_id)) {
		$persona = $lDB->get("SELECT * FROM pr_persona WHERE pr_persona_ix = '$pr_persona_id'",2);

		return $persona[0];
	} else {
		return false;
	}
}

function db_per_persona_get_name_last($pr_persona_id) {
	global $lDB;
	
	$pr_name_last = $lDB->get("
		SELECT
			pr_persona.pr_name_last
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '".$pr_persona_id."'
	",4);

	if ($pr_name_last != ""){
		return $pr_name_last;	
	} else {
		return "";
	}
}

function db_per_persona_get_name($pr_persona_id) {
    global $lDB;
    
    $pr_name = $lDB->get("
        SELECT
            TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) AS name
        FROM
            pr_persona
        WHERE
            pr_persona.pr_persona_ix = '".$pr_persona_id."'
    ",4);

    if ($pr_name != ""){
        return $pr_name;   
    } else {
        return "";
    }
}

function db_pr_persona_fields_custom() {
	return [
		'pr_name_first'=>"string",
		'pr_name_last'=>"string",
		'pr_title_id'=>[
			'link'=>"rf_title"
		],
		'pr_name_suffix_id'=>[
			'link'=>"rf_name_suffix"
		],
		'pr_email'=>"string",
		'pr_corr_addr_line1'=>"string",
		'pr_corr_addr_line2'=>"string",
		'pr_corr_addr_line3'=>"string",
		'pr_corr_city'=>"string",
		'pr_corr_post_code'=>"string",
		'pr_corr_country_id'=>[
			'link'=>"rf_country"
		],
		'pr_phys_addr_line1'=>"string",
		'pr_phys_addr_line2'=>"string",
		'pr_phys_addr_line3'=>"string",
		'pr_phys_city'=>"string",
		'pr_phys_post_code'=>"string",
		'pr_phys_country_id'=>[
			'link'=>"rf_country"
		]
	];
}

function db_pr_persona_insert_custom($values=array()) {
	global $lDB;

	if(!is_array($values) || empty($values)) {
		throw new Exception("Invalid or empty changes");
	}

	$fields = db_pr_persona_fields_custom();


	$inserts = array();
	foreach($values as $field=>$value) {
		if(!array_key_exists($field, $fields)) {
			throw new Exception("Unknown field $field");
		}
		$type = $fields[$field];
		if(is_array($type)) {
			$link = $type['link'];
			if($value !== "" && !$lDB->get("SELECT COUNT(*) FROM {$link} WHERE {$link}.{$link}_ix = '".$lDB->escape($value)."'",4)) {
				throw new Exception("Unknown value for field $field of $value");
			}
		}
		$inserts[$field] = $lDB->escape($value);
	}

	if(sizeof($inserts) == 0) {
		return false;
	}
	$lDB->put("
		INSERT INTO pr_persona (
			" . join(",", array_keys($inserts)) . "
		) VALUES (
			" . join(",", array_map(function($value) use ($lDB) {
					return "'" . $lDB->escape($value) . "'";
				}, array_values($inserts))) . "
		)
	");
	$pr_persona_id = $lDB->insert_id;
	
	$audit = new AuditTrail($pr_persona_id,TYPE_PERSONA);
	foreach($inserts as $field=>$value) {
		$audit->addDetail(
			"",
			$value,
			"",
			$pr_persona_id,
			DB_AD_PERSONA_DETAIL_ACTION_ADD,
			"persona",
			"pr_persona.".$field
		);
	}
	$audit->save("Contact details (Add)");

	return $pr_persona_id;
}

function db_pr_persona_update_custom($pr_persona_id, $changes=array()) {
	global $lDB;

	if(!is_array($changes) || empty($changes)) {
		throw new Exception("Invalid or empty changes");
	}

	if(!db_pr_persona_exists($pr_persona_id)) {
		throw new Exception("Unknown contact");
	}

	$fields = db_pr_persona_fields_custom();

	// Audit trail
	$current = $GLOBALS['lDB']->get("
		SELECT
			*
		FROM
			pr_persona
		WHERE
			pr_persona.pr_persona_ix = '".$lDB->escape($pr_persona_id)."'
	",1);
	$audit = new AuditTrail($pr_persona_id,TYPE_PERSONA);

	$updates = array();
	foreach($changes as $field=>$value) {
		if(!array_key_exists($field, $fields)) {
			throw new Exception("Unknown field $field");
		}
		$type = $fields[$field];
		if(is_array($type)) {
			$link = $type['link'];
			if($value !== "" && !$lDB->get("SELECT COUNT(*) FROM {$link} WHERE {$link}.{$link}_ix = '".$lDB->escape($value)."'",4)) {
				throw new Exception("Unknown value for field $field of $value");
			}
		}
		if($current[$field] != $value) {
			$updates[] = "$field = '" . $lDB->escape($value) . "'";
			$audit->addDetail(
				$current[$field],
				$value,
				$pr_persona_id,
				$pr_persona_id,
				DB_AD_PERSONA_DETAIL_ACTION_EDIT,
				"persona",
				"pr_persona.".$field
			);
		}
	}

	if(sizeof($updates) > 0) {
		$audit->save("Contact details (Edit)");

		if(!$lDB->put("
			UPDATE pr_persona SET
				" . join(",\n", $updates) . "
			WHERE
				pr_persona.pr_persona_ix = '" . $lDB->escape($pr_persona_id) . "'
		")) {
			return false;
		}
	}

	return true;
}
