<?php

require_once(__DIR__ . '/class.audit.php');
require_once(__DIR__ . "/db.ad_persona_detail.php");
require_once(__DIR__ . "/db.pr_persona.php");
require_once(__DIR__ . "/db.rf_phone_type.php");

function db_pr_phone_exists($pr_phone_id) {
	global $lDB;

	$check = $lDB->get("SELECT COUNT(*) FROM pr_phone WHERE pr_phone_ix = '".$lDB->escape($pr_phone_id)."'",4);
	if($check > 0) { return true; } else { return false; }
}

function db_pr_phone_insert($pr_persona_id,$rf_phone_type_id,$pr_phone_number,$pr_phone_detail=false,$pr_default_yn=false) {
	global $lDB;

	if(!db_pr_persona_exists($pr_persona_id)) {
		return false;
	}

	if(!db_rf_phone_type_exists($rf_phone_type_id)) {
		return false;
	}

	$extra = [];
	if($pr_phone_detail !== false) {
		$extra['pr_phone_detail'] = $pr_phone_detail;
	}

	$extraFields = "";
	$extraValues = "";
	if(sizeof($extra) > 0) {
		$extraFields = [];
		$extraValues = [];
		foreach($extra as $field=>$value) {
			$extraFields[] = $field;
			$extraValues[] = "'" . $lDB->escape($value) . "'";
		}
		$extraFields = "," . join(",", $extraFields);
		$extraValues = "," . join(",", $extraValues);
	}

	if($pr_default_yn === "1") {
		$pr_default_yn = true;
	}

	if($pr_default_yn === "0" || trim($pr_default_yn) == "") {
		$pr_default_yn = false;
	}

	$lDB->put("
		INSERT INTO pr_phone (
			pr_phone_db,
			pr_persona_id,
			rf_phone_type_id,
			pr_phone_number
			$extraFields
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'".$lDB->escape($pr_persona_id)."',
			'".$lDB->escape($rf_phone_type_id)."',
			'".$lDB->escape($pr_phone_number)."'
			$extraValues
		)
	");
	$pr_phone_id = $lDB->insert_id;

	$audit = new AuditTrail($pr_persona_id,TYPE_PERSONA);
	$audit->addDetail("", ($pr_default_yn?"1":"0"), "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.pr_default_yn");
	$audit->addDetail("", $pr_phone_number, "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.pr_phone_number");
	$audit->addDetail("", $rf_phone_type_id, "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.rf_phone_type_id");
	if($pr_phone_detail !== false) {
		$audit->addDetail("", $pr_phone_detail, "", $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "phone", "pr_phone.pr_phone_detail");
	}
	$audit->save("Phone details (Add)");

	if($pr_default_yn) {
		db_pr_phone_set_default($pr_phone_id,$pr_persona_id);
	}

	return $pr_phone_id;
}

function db_pr_phone_update($pr_phone_id,$rf_phone_type_id,$pr_phone_number,$pr_phone_detail=false,$pr_default_yn=false) {
	global $lDB;

	if(!db_pr_phone_exists($pr_phone_id)) {
		return false;
	}

	if(!db_rf_phone_type_exists($rf_phone_type_id)) {
		return false;
	}

	$extra = "";
	if($pr_phone_detail !== false) {
		$extra .= ",pr_phone_detail = '".$lDB->escape($pr_phone_detail)."'";
	}

	$current = $lDB->get("
		SELECT
			pr_phone.pr_default_yn,
			pr_phone.pr_phone_detail,
			pr_phone.pr_phone_number,
			pr_phone.rf_phone_type_id,
			pr_phone.pr_persona_id
		FROM
			pr_phone
		WHERE
			pr_phone.pr_phone_ix = '".$lDB->escape($pr_phone_id)."'
	",6)[0];
	$pr_persona_id = array_pop($current);
	$audit = new AuditTrail($pr_persona_id,TYPE_PERSONA);
	$changes = false;
	foreach($current as $field=>$oldValue) {
		switch($field) {
		case "pr_default_yn":
			$newValue = ($pr_default_yn?"1":"0");
			break;
		case "pr_phone_detail":
			$newValue = ($pr_phone_detail===false?$oldValue:$pr_phone_detail);
			break;
		default:
			$newValue = $$field;
			break;
		}
		if($newValue != $oldValue) {
			$changes = true;
			$audit->addDetail($oldValue, $newValue, $pr_phone_id, $pr_phone_id, DB_AD_PERSONA_DETAIL_ACTION_EDIT, "phone", "pr_phone.".$field);
		}
	}
	if($changes) {
		$audit->save("Phone details (Edit)");
	}

	$lDB->put("
		UPDATE pr_phone SET
			rf_phone_type_id = '".$lDB->escape($rf_phone_type_id)."',
			pr_phone_number = '".$lDB->escape($pr_phone_number)."'
			$extra
		WHERE
			pr_phone_ix = '".$lDB->escape($pr_phone_id)."'
	");
	if($pr_default_yn) {
		db_pr_phone_set_default($pr_phone_id);
	}
}

function db_pr_phone_set_default($pr_phone_id,$pr_persona_id=false) {
	global $lDB;

	if(!db_pr_phone_exists($pr_phone_id)) {
		return false;
	}

	if(empty($pr_persona_id)) {
		$pr_persona_id = $lDB->get("SELECT pr_persona_id FROM pr_phone WHERE pr_phone_ix = '".$lDB->escape($pr_phone_id)."'",4);
	}

	$oldDefaults = $lDB->get("
		SELECT
			pr_phone_ix
		FROM
			pr_phone
		WHERE
			pr_persona_id = '".$lDB->escape($pr_persona_id)."'
			AND pr_default_yn = '1'
	",3);
	foreach($oldDefaults as $id) {
		$lDB->put("UPDATE pr_phone SET pr_default_yn = '0' WHERE pr_phone_ix = '".$lDB->escape($id)."'");
	}

	$lDB->put("UPDATE pr_phone SET pr_default_yn = '1' WHERE pr_phone_ix = '".$lDB->escape($pr_phone_id)."'");

	return true;
}

function db_pr_phone_delete($pr_phone_id) {
	global $lDB;

	if(!db_pr_phone_exists($pr_phone_id)) {
		return false;
	}

	$pr_persona_id = $lDB->get("SELECT pr_persona_id FROM pr_phone WHERE pr_phone_ix = '".$lDB->escape($pr_phone_id)."'",4);
	$pr_email = $lDB->get("SELECT pr_email FROM pr_persona WHERE pr_persona_ix = '".$lDB->escape($pr_persona_id)."'",4);
	$phoneCount = $lDB->get("SELECT COUNT(*) FROM pr_phone WHERE pr_persona_id = '".$lDB->escape($pr_persona_id)."'",4);

	// Ensure at least one contact detail remains (email or phone)
	if(empty($pr_email) && $phoneCount <= 1) {
		return false;
	}

	$audit = new AuditTrail($pr_persona_id,TYPE_PERSONA);
	$audit->save("Phone details (Delete)");

	return $lDB->put("DELETE FROM pr_phone WHERE pr_phone_ix = '".$lDB->escape($pr_phone_id)."'");
}
