<?php
require_once(__DIR__ . "/db.pr_persona.php");
require_once(__DIR__ . "/db.rc_obj_sales.php");

function db_pr_sales_obj_data_exists($fieldVal, $field = "pr_sales_obj_data_ix") {
	global $lDB;
	$check = $lDB->get("SELECT COUNT(pr_sales_obj_data_ix) FROM pr_sales_obj_data WHERE $field = '$fieldVal'", 4);
	if($check > 0) { 
		return true; 
	} else { 
		return false; 
	}
}

function db_pr_sales_obj_data_exists_by_persona($pr_persona_id, $rc_obj_sales_id) {
	global $lDB;
	$check = $lDB->get("SELECT COUNT(pr_sales_obj_data_ix) FROM pr_sales_obj_data WHERE pr_persona_id = '$pr_persona_id' AND rc_obj_sales_id = '$rc_obj_sales_id'",4);
	if($check > 0) { 
		return true; 
	} else { 
		return false; 
	}
}

function db_pr_sales_obj_data_select_by_persona($pr_persona_id, $rc_obj_sales_id) {
	global $lDB;
	$pr_sales_obj_data_ix = $lDB->get("SELECT pr_sales_obj_data_ix FROM pr_sales_obj_data WHERE pr_persona_id = '$pr_persona_id' AND rc_obj_sales_id = '$rc_obj_sales_id'",4);
	if($pr_sales_obj_data_ix != '') { 
		return $pr_sales_obj_data_ix; 
	} else { 
		return false; 
	}
}

function db_pr_sales_obj_data_insert($pr_persona_id, $rc_obj_sales_id, $pr_sales_obj_data_content) {
	global $lDB;
	global $dbcode;
	if(!db_pr_persona_exists($pr_persona_id)) {
		return false;
	}
	
	if(!db_rc_obj_sales_exists($rc_obj_sales_id)) {
		return false;
	}
	
	$obj_ind = db_rc_obj_sales_select_type($rc_obj_sales_id);
	
	if($obj_ind == DB_RC_OBJ_SALES_TEXTAREA) {
		$data_field = 'pr_sales_obj_data_memo';
	} elseif($obj_ind == DB_RC_OBJ_SALES_RADIO || $obj_ind == DB_RC_OBJ_SALES_CHECKBOX || $obj_ind == DB_RC_OBJ_SALES_SELECTBOX || $obj_ind == DB_RC_OBJ_SALES_NATION_LOOKUP) {
		$data_field = 'rc_obj_sales_data_id';
	} else {
		$data_field = 'pr_sales_obj_data_text';
	}
	
	$lDB->put("
		INSERT INTO pr_sales_obj_data (
			pr_sales_obj_data_db,
			$data_field,
			pr_persona_id,
			rc_obj_sales_id
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($pr_sales_obj_data_content)."',
			'".$lDB->escape($pr_persona_id)."',
			'".$lDB->escape($rc_obj_sales_id)."'
		)
	");
	
	$pr_sales_obj_data_id = $lDB->insert_id;

	return $pr_sales_obj_data_id;	
}

function db_pr_sales_obj_data_update($pr_sales_obj_data_id, $rc_obj_sales_id,$pr_sales_obj_data_content ) {
	global $lDB;
	$obj_ind = db_rc_obj_sales_select_type($rc_obj_sales_id);

	if($obj_ind == DB_RC_OBJ_SALES_TEXTAREA) {
		$data_field = 'pr_sales_obj_data_memo';
	} elseif($obj_ind == DB_RC_OBJ_SALES_RADIO || $obj_ind == DB_RC_OBJ_SALES_CHECKBOX || $obj_ind == DB_RC_OBJ_SALES_SELECTBOX ||$obj_ind == DB_RC_OBJ_SALES_NATION_LOOKUP ) {
		$data_field = 'rc_obj_sales_data_id';
	} else {
		$data_field = 'pr_sales_obj_data_text';
	}
	
	$lDB->put("
		UPDATE pr_sales_obj_data SET
			$data_field = '".$lDB->escape($pr_sales_obj_data_content)."'
		WHERE
			pr_sales_obj_data_ix = '$pr_sales_obj_data_id' 
	");
}

function db_pr_sales_obj_data_delete($pr_sales_obj_data_id) {
	global $lDB;
	if(!db_pr_sales_obj_data_exists($pr_sales_obj_data_id)) {
		return false;
	}
	$res = $lDB->put("
		DELETE FROM 
			pr_sales_obj_data 
		WHERE 
			pr_sales_obj_data_ix = '$pr_sales_obj_data_id'
	");
	
	return $res;
}

function db_pr_sales_obj_data_select($rc_obj_sales_id) {
	global $lDB;
	
	$obj_sales_data = $lDB->get("SELECT * FROM rc_obj_sales_data WHERE rc_obj_sales_id = '$rc_obj_sales_id' ORDER BY rc_obj_sales_data_sort_seq", 2);

	if(count($obj_sales_data) > 0) {
		return $obj_sales_data; 
	} else { 
		return false; 
	}

}
