<?php

/**
 * db.pr_user.php - Database functions for table pr_user
 */

use MaglLegacyApplication\Application\MaglLegacy;

require_once(__DIR__ . '/db.pr_user_password.php');

define("DB_PR_USER_PASSWORD_TYPE_INSECURE",0);
define("DB_PR_USER_PASSWORD_TYPE_NORMAL",1);

function db_pr_user_exists($pr_user_id) {
	global $lDB;

	$check = $lDB->get("SELECT COUNT(pr_user_id) FROM pr_user WHERE pr_user_id = '".$lDB->escape($pr_user_id)."'",4);
	if($check > 0) { return true; } else { return false; }
}

function db_pr_consultant_exists($pr_user_id) {
	$userCheck = $GLOBALS['lDB']->get("
		SELECT
			COUNT(pr_user.pr_user_id)
		FROM
			sc_user
			INNER JOIN pr_user ON pr_user.pr_user_id = sc_user.pr_user_id
			INNER JOIN sc_group ON sc_group.sc_group_id = sc_user.sc_group_id
		WHERE
		   sc_group.sc_grp_consultant_yn = 1
		   AND pr_user.pr_user_inactive_yn = 0
		   AND pr_user.pr_user_id = '$pr_user_id'
	",4);
	if($userCheck > 0) {
		return true;
	} else {
		return false;
	}
}

function db_pr_user_set_password($pr_user_id, $pr_user_password, $pr_user_name=false, $force=false) {
	global $lDB;

	if(!db_pr_user_exists($pr_user_id)) {
		return false;
	}

	$extra = "";
	if(!empty($pr_user_name)) {
		$check = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				pr_user
			WHERE
				pr_user.pr_user_id != '".$lDB->escape($pr_user_id)."'
				AND pr_user.pr_user_name = '".$lDB->escape($pr_user_name)."'
		",4);
		if($check > 0) {
			return false;
		}
		$extra = ", pr_user_name = '".$lDB->escape($pr_user_name)."'";
	}

	$application = MaglLegacy::getInstance()->getApplication();
	$passwordService = $application->getServiceManager()->get('Resrequest\Authentication\Service\Password');
	$passwordService->setupContext($pr_user_password);


	$pr_auth_password_type_ind = DB_PR_USER_PASSWORD_TYPE_NORMAL;
	if($passwordService->invalid() && $force !== true) {
		return false;
	}

	$hash = $passwordService->hash();

	$old = $lDB->get("
		SELECT
			pr_user.pr_user_password,
			pr_user.pr_auth_password_type_ind
		FROM
			pr_user
		WHERE
			pr_user.pr_user_id = '".$lDB->escape($pr_user_id)."'
	");
	$old_user_password = $old['pr_user_password'];
	if($old['pr_auth_password_type_ind'] == DB_PR_USER_PASSWORD_TYPE_INSECURE) {
		if($old['pr_user_password'] != $pr_user_password) {
			$passwordService->setupContext($old['pr_user_password']);
			$old_user_password = $passwordService->hash();
			unset($oldPassword);
		} else {
			$old_user_password = false;
		}
	}
	if($old_user_password !== false) {
		db_pr_user_password_insert($pr_user_id, $old_user_password);
	}

	$lDB->put("
		UPDATE pr_user SET
			pr_user_password = '".$lDB->escape($hash)."',
			pr_auth_password_type_ind = '".$lDB->escape($pr_auth_password_type_ind)."'
			$extra
		WHERE
			pr_user.pr_user_id = '".$lDB->escape($pr_user_id)."'
	");

	return true;
}

function db_pr_user_reset($pr_user_id) {
	global $lDB;

	if(!db_pr_user_exists($pr_user_id)) {
		return false;
	}

	$first = true;
	$check = 0;
	while($first || $check > 0) {
		$random_name = mb_strtoupper(randUserName($pr_user_id));
		$check = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				pr_user
			WHERE
				pr_user.pr_user_id != '".$lDB->escape($pr_user_id)."'
				AND pr_user.pr_user_name = '".$lDB->escape($random_name)."'
		",4);
		$first = false;
	}

	$application = MaglLegacy::getInstance()->getApplication();
	$passwordService = $application->getServiceManager()->get('Resrequest\Authentication\Service\Password');
	$passwordService->setupContext($random_name);
	$hash = $passwordService->hash();

	$lDB->put("
		UPDATE pr_user SET
			pr_user_name = '".$lDB->escape($random_name)."',
			pr_user.pr_user_password = '".$lDB->escape($hash)."',
			pr_auth_password_type_ind = '".$lDB->escape(DB_PR_USER_PASSWORD_TYPE_NORMAL)."'
		WHERE
			pr_user.pr_user_id = '".$lDB->escape($pr_user_id)."'
	");

	return $random_name;
}
