<?php

require_once(__DIR__ . '/db.pr_user.php');

function db_pr_user_password_exists($pr_user_password_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(pr_user_password_ix) FROM pr_user_password WHERE pr_user_password_ix = '".$lDB->escape($pr_user_password_id)."'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_pr_user_password_insert($pr_user_id, $pr_user_password, $ad_create_user_id=false) {
	global $lDB;
	global $dbcode;

	if(!db_pr_user_exists($pr_user_id)) {
		return false;
	}

	// Default to the currently logged in user
	if($ad_create_user_id === false) {
		$ad_create_user_id = $GLOBALS['userid'];
	}

	$lDB->put("
		INSERT INTO pr_user_password (
			pr_user_password_db,
			pr_user_id,
			pr_user_password,
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($pr_user_id)."',
			'".$lDB->escape($pr_user_password)."',
			'".$lDB->escape(date("Y-m-d H:i:s"))."',
			'".$lDB->escape(date("e"))."',
			'".$lDB->escape($ad_create_user_id)."'
		)
	");	
	$pr_user_password_id = $lDB->insert_id;

	db_pr_user_password_trim($pr_user_id);

	return $pr_user_password_id;
}

function db_pr_user_password_rules() {
	global $lDB;

	return $lDB->get("
		SELECT
			rf_auth_previous_password_yn,
			rf_auth_previous_password_limit
		FROM
			rf_default
	",1);
}

function db_pr_user_password_trim($pr_user_id) {
	global $lDB;
	global $dbcode;

	if(!db_pr_user_exists($pr_user_id)) {
		return false;
	}

	$rules = db_pr_user_password_rules();

	if(!empty($rules['rf_auth_previous_password_yn'])) {
		$list = array_slice($lDB->get("
			SELECT
				pr_user_password.pr_user_password_ix
			FROM
				pr_user_password
			WHERE
				pr_user_password.pr_user_id = '".$lDB->escape($pr_user_id)."'
			ORDER BY
				pr_user_password.ad_create_date DESC
		",3),$rules['rf_auth_previous_password_limit']);

		foreach($list as $pr_user_password_id) {
			db_pr_user_password_delete($pr_user_password_id);
		}
	}
}

function db_pr_user_password_delete($pr_user_password_id) {
	global $lDB;

	if(!db_pr_user_password_exists($pr_user_password_id)) {
		return false;
	}

	$lDB->put("DELETE FROM pr_user_password WHERE pr_user_password.pr_user_password_ix = '".$lDB->escape($pr_user_password_id)."'");
}

function db_pr_user_password_list($pr_user_id) {
	global $lDB;

	if(!db_pr_user_exists($pr_user_id)) {
		return false;
	}

	$rules = db_pr_user_password_rules();

	return array_slice($lDB->get("
		SELECT
			pr_user_password.pr_user_password
		FROM
			pr_user_password
		WHERE
			pr_user_password.pr_user_id = '".$lDB->escape($pr_user_id)."'
		ORDER BY
			pr_user_password.ad_create_date DESC
	",3),0,$rules['rf_auth_previous_password_limit']);
}
