<?php
require_once(__DIR__ . "/db.rc_obj_sales_data.php");

define("DB_RC_OBJ_SALES_TEXTBOX",1);
define("DB_RC_OBJ_SALES_TEXTAREA",2);
define("DB_RC_OBJ_SALES_RADIO",3);
define("DB_RC_OBJ_SALES_CHECKBOX",4);
define("DB_RC_OBJ_SALES_SELECTBOX",5);
define("DB_RC_OBJ_SALES_NUMERIC",6);
define("DB_RC_OBJ_SALES_DATE",7);
define("DB_RC_OBJ_SALES_NATION_LOOKUP",8);

function db_rc_obj_sales_exists($rc_obj_sales_id) {
	global $lDB;
	$check = $lDB->get("SELECT COUNT(rc_obj_sales_ix) FROM rc_obj_sales WHERE rc_obj_sales_ix = '$rc_obj_sales_id'",4);
	if($check > 0) { 
		return true; 
	} else { 
		return false; 
	}
}

function db_rc_obj_sales_insert($rc_obj_sales_type_ind, $rc_obj_sales_label, $rc_obj_sales_mandatory_yn=0) {
	global $lDB;
	global $dbcode;
		
	$rc_obj_sales_sort_seq = $lDB->get("
		SELECT 
			MAX(rc_obj_sales_sort_seq) 
		FROM 
			rc_obj_sales 
		WHERE 
			rc_obj_sales_inactive_yn = '0'
	", 4);
	if($rc_obj_sales_sort_seq > 0) {
		$rc_obj_sales_sort_seq++;
	} else {
		$rc_obj_sales_sort_seq = 1;
	}

	$lDB->put("
		INSERT INTO rc_obj_sales (
			rc_obj_sales_db,
			rc_obj_sales_label,
			rc_obj_sales_type_ind,
			rc_obj_sales_sort_seq,
			rc_obj_sales_mandatory_yn
			
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($rc_obj_sales_label)."',
			'".$lDB->escape($rc_obj_sales_type_ind)."',
			'".$lDB->escape($rc_obj_sales_sort_seq)."',
			'".$lDB->escape($rc_obj_sales_mandatory_yn)."'
		)
	");

	$rc_obj_sales_id = $lDB->insert_id;

	return $rc_obj_sales_id;	
}

function db_rc_obj_sales_update($rc_obj_sales_id, $rc_obj_sales_label, $rc_obj_sales_mandatory_yn=0) {
	global $lDB;
	if(!db_rc_obj_sales_exists($rc_obj_sales_id)) {
		return false;
	}
	$lDB->put("
		UPDATE 
			rc_obj_sales 
		SET
			rc_obj_sales_label = '".$lDB->escape($rc_obj_sales_label)."',
			rc_obj_sales_mandatory_yn = '".$lDB->escape($rc_obj_sales_mandatory_yn)."'
		WHERE
			rc_obj_sales_ix = '$rc_obj_sales_id'
	");
}

function db_rc_obj_sales_set_sort_seq($rc_obj_sales_id, $rc_obj_sales_sort_seq) {
	global $lDB;
	if(!db_rc_obj_sales_exists($rc_obj_sales_id)) {
		return false;
	}
	
	$lDB->put("
		UPDATE 
			rc_obj_sales 
		SET
			rc_obj_sales_sort_seq = '".$lDB->escape($rc_obj_sales_sort_seq)."'
		WHERE
			rc_obj_sales_ix = '$rc_obj_sales_id'
	");
}

function db_rc_obj_sales_set_inactive($rc_obj_sales_id, $rc_obj_sales_inactive_yn=0) {
	global $lDB;
	if(!db_rc_obj_sales_exists($rc_obj_sales_id)) {
		return false;
	}
	$lDB->put("
		UPDATE rc_obj_sales SET
			rc_obj_sales_inactive_yn = '".$lDB->escape($rc_obj_sales_inactive_yn)."'
		WHERE
			rc_obj_sales_ix = '$rc_obj_sales_id'
	");
}

function db_rc_obj_sales_delete($rc_obj_sales_id) {
	global $lDB;
	if(!db_rc_obj_sales_exists($rc_obj_sales_id)) {
		return false;
	}

	$check = $lDB->get("
		SELECT 
			COUNT(rc_obj_sales_id)
		FROM 
			pr_sales_obj_data
		WHERE
			rc_obj_sales_id = '$rc_obj_sales_id'
	",4);
		
	if ($check != "0") {
		db_rc_obj_sales_set_inactive($rc_obj_sales_id, 1);
	} else {
		$rc_obj_sales_data_ids = $lDB->get("
			SELECT 
				rc_obj_sales_data_ix 
			FROM 
				rc_obj_sales_data 
			WHERE 
				rc_obj_sales_id = '$rc_obj_sales_id'
		", 3);

		foreach($rc_obj_sales_data_ids as $rc_obj_sales_data_id) {
			$rec = db_rc_obj_sales_data_delete($rc_obj_sales_data_id);
		}

		$res = $lDB->put("DELETE FROM rc_obj_sales WHERE rc_obj_sales_ix = '$rc_obj_sales_id'");
	}
	
	return $res;
}

function db_rc_obj_sales_select($rc_obj_sales_id) {
	global $lDB;
	$obj_sales = $lDB->get("SELECT * FROM rc_obj_sales WHERE rc_obj_sales_ix = '$rc_obj_sales_id'", 2);

	if(count($obj_sales) > 0) {
		$obj_sales_data = db_rc_obj_sales_data_select($obj_sales[0]['rc_obj_sales_ix']);
		if(count($obj_sales_data)>0) {
			$obj_sales[0]['obj_data'] = $obj_sales_data;
		} else {
			$obj_sales[0]['obj_data'] = array();
		}

		return $obj_sales[0]; 
	} else { 
		return false; 
	}
}

function db_rc_obj_sales_select_by_condition($where, $orderbyfield='', $order='') {
	global $lDB;

    $sql = " 
        SELECT 
	  	  *
	    FROM 
		  rc_obj_sales
        {$where} 
        ORDER BY {$orderbyfield} {$order}";

	$recordid = $lDB->get($sql,2);

	return $recordid;
}

function db_rc_obj_sales_reset_sequence() {
    global $lDB;

    $sql = " 
        SELECT 
	  	  rc_obj_sales_ix
	    FROM 
		  rc_obj_sales
        WHERE
          1
        ORDER BY rc_obj_sales_ix ASC";

    $rc_obj_sales = $lDB->get($sql, 2);

    $sequence = 1;
    foreach($rc_obj_sales as $rc_obj_sale){
        db_rc_obj_sales_set_sort_seq($rc_obj_sale['rc_obj_sales_ix'], $sequence);
        $sequence++;
    }
}

function db_rc_obj_sales_select_count($where='') {
	global $lDB;
	$counter = $lDB->get("SELECT count(*) from rc_obj_sales ".$where,4);

	return $counter;
}

function db_rc_obj_sales_select_type($rc_obj_sales_id) {
	global $lDB;
	$rc_obj_sales_type_ind = $lDB->get("
		SELECT 
			rc_obj_sales_type_ind 
		FROM 
			rc_obj_sales 
		WHERE 
			rc_obj_sales_ix = '$rc_obj_sales_id'", 4);
	
	return $rc_obj_sales_type_ind;
}


function db_rc_obj_sales_type_ind_desc($rc_obj_sales_type_ind) {
	switch($rc_obj_sales_type_ind) {
	case DB_RC_OBJ_SALES_TEXTBOX:
		return "Textfield";
	case DB_RC_OBJ_SALES_TEXTAREA:
		return "Textarea";
	case DB_RC_OBJ_SALES_RADIO:
		return "Radio button";
	case DB_RC_OBJ_SALES_CHECKBOX:
		return "Checkbox";
	case DB_RC_OBJ_SALES_SELECTBOX:
		return "Drop down";
	case DB_RC_OBJ_SALES_NUMERIC:
		return "Numeric field";
	case DB_RC_OBJ_SALES_DATE:
		return "Date";
	case DB_RC_OBJ_SALES_NATION_LOOKUP:
		return "Lookup";
	default:
		return "Unknown";
	}
}

function db_rc_obj_sales_find_Field_Name($rc_obj_sales_sys_code) {
	switch($rc_obj_sales_sys_code) {
	case 1;
		$field_name = "rf_country_id";
		break;
	case 2;
		$field_name = "pr_name_last";
		break;
	case 3;
		$field_name = "pr_name_last";
		break;
	case 4;
		$field_name = "pr_birthdate";
		break;
	case 5;
		$field_name = "pr_anniversary";
		break;
	}

	return $field_name;
}

function db_rc_obj_sales_has_duplicated_sequence(){
    global $lDB;

    $sql = "
      SELECT 
        rc_obj_sales_sort_seq, 
        COUNT(*) AS rc_obj_sales_sort_seq_counter
      FROM 
        rc_obj_sales 
      GROUP BY rc_obj_sales_sort_seq HAVING rc_obj_sales_sort_seq_counter > 1";

    $rc_obj_sales = $lDB->get($sql, 4);

    return (isset($rc_obj_sales) && $rc_obj_sales != "") ? true : false;
}

