<?php

require_once(__DIR__ . '/class.audit.php');
require_once(__DIR__ . "/db.pr_persona.php");
require_once(__DIR__ . "/db.rv_reservation.php");

define("RE_REMINDER_LINK_TO_RV_RESERVATION", 1);
define("RE_REMINDER_LINK_TO_PR_PERSONA", 2);
define("RE_REMINDER_REPEAT_NO", 0);
define("RE_REMINDER_REPEAT_YES", 1);
define("RE_REMINDER_STATUS_ACTIVE", 10);
define("RE_REMINDER_STATUS_SUSPENDED", 20);
define("RE_REMINDER_STATUS_FAILED", 30);
define("RE_REMINDER_STATUS_SENT", 40);

/**
 * Check if reminder exists
 *
 * @param string $re_reminder_ix
 *
 * @return boolean
 */
function db_re_reminder_exists($re_reminder_ix) {
    global $lDB;

    $count = $lDB->get("SELECT COUNT(*) FROM re_reminder WHERE re_reminder_ix = '".$lDB->escape($re_reminder_ix)."'",4);

    return ($count > 0) ? true : false;
}

/**
 * Stores reminders
 *
 * @param string $re_reminder_note
 * @param string $re_reminder_send_date
 * @param string $re_reminder_send_date_tz
 * @param int $re_reminder_repeat_yn
 * @param int $re_reminder_link_to_ind_id
 * @param string $re_reminder_link_to_id
 * @param int $re_reminder_status_id
 *
 * @return string
 */
function db_re_reminder_insert($re_reminder_note, $re_reminder_send_date, $re_reminder_send_date_tz, $re_reminder_repeat_yn , $re_reminder_link_to_ind_id, $re_reminder_link_to_id ,$re_reminder_status_id = 0) {
    global $lDB;

    if($re_reminder_link_to_ind_id == RE_REMINDER_LINK_TO_RV_RESERVATION) {
        if(!db_rv_reservation_exists($re_reminder_link_to_id)){
            return false;
        }
    }
    elseif($re_reminder_link_to_ind_id == RE_REMINDER_LINK_TO_PR_PERSONA) {
        if(!db_pr_persona_exists($re_reminder_link_to_id)){
            return false;
        }
    }
    else {  
        return false;
    }
    $pr_user_id = isset($_SESSION['userid']) ? $_SESSION['userid'] : null;
    $ad_create_date = date("Y-m-d H:i:s");
    $ad_create_date_tz = date("e");
    $re_reminder_send_date = date("Y-m-d H:i:s", strtotime($re_reminder_send_date));

    $sql = "INSERT INTO re_reminder (
        re_reminder_db,
        re_reminder_note,
        re_reminder_status_id,
        re_reminder_send_date,
        re_reminder_send_date_tz,
        re_reminder_repeat_yn,
        re_reminder_link_to_ind_id,
        re_reminder_link_to_id,
        ad_create_date,
        ad_create_date_tz,
        ad_create_user_id
    ) VALUES (
        '".$lDB->escape($GLOBALS['dbcode'])."',
			'".$lDB->escape($re_reminder_note)."',
			'".$lDB->escape($re_reminder_status_id)."',
			'".$lDB->escape($re_reminder_send_date)."',
			'".$lDB->escape($re_reminder_send_date_tz)."',
			'".$lDB->escape($re_reminder_repeat_yn)."',
			'".$lDB->escape($re_reminder_link_to_ind_id)."',
			'".$lDB->escape($re_reminder_link_to_id)."',
			'".$lDB->escape($ad_create_date)."',
			'".$lDB->escape($ad_create_date_tz)."',
			'".$lDB->escape($pr_user_id)."'
		)";

    $lDB->put($sql);

    return $lDB->insert_id;
}

/**
 * Update reminders
 *
 * @param string $re_reminder_ix
 * @param string $re_reminder_note
 * @param string $re_reminder_send_date
 * @param string $re_reminder_send_date_tz
 * @param int $re_reminder_repeat_yn
 * @param int $re_reminder_link_to_ind_id
 * @param string $re_reminder_link_to_id
 * @param int $re_reminder_status_id
 *
 * @return string
 */

function db_re_reminder_update($re_reminder_ix, $re_reminder_note, $re_reminder_send_date, $re_reminder_send_date_tz, $re_reminder_repeat_yn , $re_reminder_link_to_ind_id, $re_reminder_link_to_id , $re_reminder_status_id = 0){
    global $lDB;

    if($re_reminder_link_to_ind_id == RE_REMINDER_LINK_TO_RV_RESERVATION) {
        if(!db_rv_reservation_exists($re_reminder_link_to_id)){
            return false;
        }
    }
    elseif($re_reminder_link_to_ind_id == RE_REMINDER_LINK_TO_PR_PERSONA) {
        if(!db_pr_persona_exists($re_reminder_link_to_id)){
            return false;
        }
    }
    else {
        return false;
    }
    $pr_user_id = isset($_SESSION['userid']) ? $_SESSION['userid'] : null;
    $ad_modify_date = date("Y-m-d H:i:s");
    $ad_modify_date_tz = date("e");
    $re_reminder_send_date = date("Y-m-d H:i:s", strtotime($re_reminder_send_date));

    $lDB->put("
		UPDATE re_reminder 
		SET
			re_reminder_note = '".$lDB->escape($re_reminder_note)."',
			re_reminder_status_id = '".$lDB->escape($re_reminder_status_id)."',
			re_reminder_send_date = '".$lDB->escape($re_reminder_send_date)."',
			re_reminder_send_date_tz = '".$lDB->escape($re_reminder_send_date_tz)."',
			re_reminder_link_to_ind_id = '".$lDB->escape($re_reminder_link_to_ind_id)."',
			re_reminder_link_to_id = '".$lDB->escape($re_reminder_link_to_id)."',
			re_reminder_repeat_yn = '".$lDB->escape($re_reminder_repeat_yn)."',
			ad_modify_date = '".$lDB->escape($ad_modify_date)."',
			ad_modify_date_tz = '".$lDB->escape($ad_modify_date_tz)."',
			ad_modify_user_id = '".$lDB->escape($pr_user_id)."'
		WHERE
			re_reminder_ix = '".$lDB->escape($re_reminder_ix)."'
	");

    return true;
}

/**
 * Delete reminders
 *
 * @param string $re_reminder_ix
 *
 * @return mixed
 */
function db_re_reminder_delete($re_reminder_ix) {
    global $lDB;

    if(!db_re_reminder_exists($re_reminder_ix)) {
        return false;
    }

    return $lDB->put("DELETE FROM re_reminder WHERE re_reminder_ix = '".$lDB->escape($re_reminder_ix)."'");
}


/**
 * Get list of reminder ids that relate to a user
 *
 * @param string $rv_reminder_ix
 *
 * @return mixed
 */
function db_re_reminder_info($rv_reminder_ix) {
    global $lDB;

    $sql = "
        SELECT 
            re_reminder.re_reminder_db,
            re_reminder.re_reminder_ix,
            re_reminder.re_reminder_note,
            re_reminder.re_reminder_status_id,
            re_reminder.re_reminder_send_date,
            re_reminder.re_reminder_send_date_tz,
            re_reminder.re_reminder_repeat_yn,
            re_reminder.re_reminder_link_to_ind_id,
            re_reminder.re_reminder_link_to_id,
            re_reminder.aw_workflow_id,
            re_reminder.ad_create_date,
            re_reminder.ad_create_date_tz,
            re_reminder.ad_create_user_id,
            re_reminder.re_reminder_trf_yn
        FROM  
            re_reminder
        WHERE 
            re_reminder.re_reminder_ix = '{$rv_reminder_ix}'
          
    ";

    return $lDB->get($sql, 1);
}

/**
 * Get list of reminder ids that relate to a user
 *
 * @param string $re_reminder_ix
 *
 * @return mixed
 */
function db_re_reminder_recipient_list($re_reminder_ix) {
    global $lDB;

    $sql = "
        SELECT 
          re_reminder_persona.re_reminder_id,
          pr_persona.pr_persona_ix,
          pr_persona.pr_name_first,
          pr_persona.pr_name_last,
          pr_persona.pr_email
        FROM  
          re_reminder_persona
          INNER JOIN pr_persona ON pr_persona.pr_persona_ix = re_reminder_persona.pr_persona_id
        WHERE
          re_reminder_persona.re_reminder_id = '{$re_reminder_ix}'
    ";

    return $lDB->get($sql, 2);
}

/**
 * Check if reservation has reminder
 *
 * @param string $reservation_id
 *
 * @return boolean
 */
function db_re_reminder_count_by_reservation($reservation_id) {
    global $lDB;

    $count = $lDB->get("SELECT COUNT(*) FROM re_reminder WHERE re_reminder_link_to_ind_id = '1' AND re_reminder_link_to_id = '".$lDB->escape($reservation_id)."'",4);

    return ($count > 0) ? true : false;
}


/**
 * Update reminder status
 *
 * @param string $re_reminder_ix
 * @param string $re_reminder_status_id
 *
 * @return boolean
 */
function db_re_reminder_update_status($re_reminder_ix, $re_reminder_status_id) {
    global $lDB;

    $sql = "
        UPDATE 
          re_reminder
        SET
		  re_reminder_status_id = '".$lDB->escape($re_reminder_status_id)."'
        WHERE
          re_reminder_ix = '{$re_reminder_ix}'
    ";

    return $lDB->put($sql);
}
