<?php

/**
 * Check if reminder log exists
 *
 * @param string $re_reminder_log_id
 *
 * @return boolean
 */
function db_re_reminder_log_exists($re_reminder_log_id) {
    global $lDB;

    $count = $lDB->get("SELECT COUNT(*) FROM re_reminder_log WHERE re_reminder_log_id = '".$lDB->escape($re_reminder_log_id)."'",4);

    return ($count > 0) ? true : false;
}

/**
 * Store reminder log exists
 *
 * @param string $re_reminder_id
 * @param string $re_reminder_log_status
 *
 * @return mixed
 */
function db_re_reminder_log_insert($re_reminder_id, $re_reminder_log_status) {
    global $lDB;

    $ad_create_date = date("Y-m-d H:i:s");
    $ad_create_date_tz = date("e");

    $sql = "
		INSERT INTO re_reminder_log (
		    re_reminder_id,
		    re_reminder_log_status,
			re_reminder_log_date,
			re_reminder_log_date_tz
		) VALUES (
			'".$lDB->escape($re_reminder_id)."',
			'".$lDB->escape($re_reminder_log_status)."',
			'".$lDB->escape($ad_create_date)."',
			'".$lDB->escape($ad_create_date_tz)."'
		)
	";

    $lDB->put($sql);

    return $lDB->insert_id;
}

/**
 * Count the number of times for log status
 *
 * @param string $re_reminder_id
 * @param int $re_reminder_status
 *
 * @return integer
 */
function db_re_reminder_log_count($re_reminder_id, $re_reminder_status = 40) {
    global $lDB;

    $sql = "
		SELECT 
		    COUNT(*)
		FROM
		 re_reminder_log 
		WHERE
		  re_reminder_log.re_reminder_id = '{$re_reminder_id}' AND
		  re_reminder_log.re_reminder_log_status = '{$re_reminder_status}'
	";

    return $lDB->get($sql, 4);
}