<?php

require_once(__DIR__ . "/db.re_reminder.php");
require_once(__DIR__ . "/db.pr_persona.php");

/**
 * Check if re_reminder_persona exists
 *
 * @param string $re_reminder_persona_ix
 *
 * @return bool
 */
function db_re_reminder_persona_exists($re_reminder_persona_ix) {
    global $lDB;

    $count = $lDB->get("SELECT COUNT(*) FROM re_reminder_persona WHERE re_reminder_persona_ix = '".$lDB->escape($re_reminder_persona_ix)."'",4);

    return ($count > 0) ? true : false;
}

/**
 * Store re_reminder_persona
 *
 * @param string $re_reminder_id
 * @param string $persona_id
 * @param string $re_reminder_send_to_email
 *
 * @return bool
 */
function db_re_reminder_persona_insert($re_reminder_id, $persona_id, $re_reminder_send_to_email = null ) {
    global $lDB;

    if(!db_re_reminder_exists($re_reminder_id)){
        return false;
    }

    if($persona_id == null){
        if(!db_pr_persona_exists($persona_id)){
            return false;
        }
    }

    $lDB->put("
		INSERT INTO re_reminder_persona (
			re_reminder_persona_db,
			re_reminder_sent_to_email,
			re_reminder_id,
		    pr_persona_id
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'".$lDB->escape($re_reminder_send_to_email)."',
			'".$lDB->escape($re_reminder_id)."',
			'".$lDB->escape($persona_id)."'
		)
	");

    return $lDB->insert_id;
}

/**
 * Delete re_reminder_persona by re_reminder_persona_id
 *
 * @param string $re_reminder_id
 *
 * @return array
 */

function db_get_re_reminder_persona_ids_by_re_reminder_id($re_reminder_id) {
    global $lDB;

    $ids = $lDB->get("
                SELECT 
                       re_reminder_persona.re_reminder_persona_ix
                FROM 
                      re_reminder_persona 
                WHERE 
                      re_reminder_persona.re_reminder_id = '".$lDB->escape($re_reminder_id)."'",3);

    return $ids;
}

/**
 * Delete re_reminder_persona by re_reminder_persona_id
 *
 * @param string $re_reminder_persona_id
 *
 * @return boolean
 */
function db_re_reminder_persona_delete_by_id($re_reminder_persona_id) {
    global $lDB;

    if(!db_re_reminder_persona_exists($re_reminder_persona_id)) {
        return false;
    }

    return $lDB->put("DELETE FROM re_reminder_persona WHERE re_reminder_persona_ix = '".$lDB->escape($re_reminder_persona_id)."'");
}
