<?php

/**
 * Check if reminder status exists
 *
 * @param string $re_reminder_status_id
 *
 * @return boolean
 */
function db_re_reminder_status_exists($re_reminder_status_id) {
    global $lDB;

    $count = $lDB->get("SELECT COUNT(*) FROM re_reminder_status WHERE re_reminder_status_ix = '".$lDB->escape($re_reminder_status_id)."'",4);

    return ($count > 0)  ? true : false;
}

/**
 * Store reminder status
 *
 * @param string $re_reminder_status_description
 *
 * @return boolean
 */
function db_re_reminder_status_insert($re_reminder_status_desc) {
    global $lDB;

    $ad_create_date = date("Y-m-d H:i:s");
    $ad_create_date_tz = date("e");
    $pr_user_id = isset($GLOBALS['userid']) ? $GLOBALS['userid'] : null;

    $lDB->put("
		INSERT INTO re_reminder_status (
		    re_reminder_status_db,
		    re_reminder_status_desc,
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'".$lDB->escape($re_reminder_status_desc)."',
			'".$lDB->escape($ad_create_date)."',
			'".$lDB->escape($ad_create_date_tz)."'
			'".$lDB->escape($pr_user_id)."'
		)
	");

    return $lDB->insert_id;
}

/**
 * Update reminder status
 *
 * @param string $re_reminder_status_id
 * @param string $re_reminder_status_desc
 *
 * @return boolean
 */
function db_re_reminder_status_update($re_reminder_status_id, $re_reminder_status_desc) {
    global $lDB;

    if(!db_re_reminder_status_exists($re_reminder_status_id)) {
        return false;
    }

    $ad_modify_date = date("Y-m-d H:i:s");
    $ad_modify_date_tz = date("e");
    $pr_user_id = isset($GLOBALS['userid']) ? $GLOBALS['userid'] : null;

    $lDB->put("
		UPDATE re_reminder_status 
		SET
			re_reminder_status_desc = '".$lDB->escape($re_reminder_status_desc)."',
			ad_modify_date = '".$lDB->escape($ad_modify_date)."',
			ad_modify_date_tz = '".$lDB->escape($ad_modify_date_tz)."',
			ad_modify_user_id = '".$lDB->escape($pr_user_id)."'
		WHERE
			re_reminder_status_ix = '".$lDB->escape($re_reminder_status_id)."'
	");


    return true;
}

/**
 * Delete reminder status
 *
 * @param string $re_reminder_status_id
 *
 * @return boolean
 */
function db_re_reminder_status_delete($re_reminder_status_id) {
    global $lDB;

    if(!db_re_reminder_status_exists($re_reminder_status_id)) {
        return false;
    }

    return $lDB->put("DELETE FROM re_reminder_status WHERE re_reminder_status_ix = '".$lDB->escape($re_reminder_status_id)."'");
}
