<?php

require_once(__DIR__ . "/db.pr_bus_bank.php");

function db_rf_bank_exists($rf_bank_id) {
	global $lDB;

	$bankCheck = $lDB->get("SELECT COUNT(rf_bank_ix) FROM rf_bank WHERE rf_bank_ix = '$rf_bank_id'",4);
	if($bankCheck > 0) { return true; } else { return false; }

}

function db_rf_bank_extras_by_debt($rf_currency_id,$pr_business_id) {
	global $lDB;

	$bankCheck = $lDB->get("
		SELECT
			COUNT(*)
		FROM
			rf_bank
		WHERE
			rf_bank_db = '$GLOBALS[dbcode]'
			AND rf_currency_id = '$rf_currency_id'
			AND pr_business_id = '$pr_business_id'
			AND rf_bank_sys_code = '7'
	",4);
	if($bankCheck > 0) { return true; } else { return false; }
}

function db_rf_bank_insert($rf_bank_ind,$rf_currency_id,$rf_bank_acc_name,$rf_bank_abbrev,$rf_bank_acc_no,$rf_bank_detail_1,$rf_bank_detail_2,$rf_bank_detail_3,$rf_bank_name,$pr_business_id=false,$rf_bank_sys_code=false) {
	global $lDB;

	$extra = array();

	if($pr_business_id !== false) {
		$extra['pr_business_id'] = $lDB->escape($pr_business_id);
	}

	if($rf_bank_sys_code !== false) {
		$extra['rf_bank_sys_code'] = $lDB->escape($rf_bank_sys_code);
	}

	$extraField = "";
	$extraValue = "";
	foreach($extra as $key=>$item) {
		$extraField .= "$key,\n";
		$extraValue .= "'$item',\n";
	}

	$lDB->put("
		INSERT INTO rf_bank (
			rf_bank_db,
			rf_bank_ind,
			rf_currency_id,
			rf_bank_acc_name,
			rf_bank_abbrev,
			rf_bank_acc_no,
			rf_bank_detail_1,
			rf_bank_detail_2,
			rf_bank_detail_3,
			$extraField
			rf_bank_name
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'".$lDB->escape($rf_bank_ind)."',
			'".$lDB->escape($rf_currency_id)."',
			'".$lDB->escape($rf_bank_acc_name)."',
			'".$lDB->escape($rf_bank_abbrev)."',
			'".$lDB->escape($rf_bank_acc_no)."',
			'".$lDB->escape($rf_bank_detail_1)."',
			'".$lDB->escape($rf_bank_detail_2)."',
			'".$lDB->escape($rf_bank_detail_3)."',
			$extraValue
			'".$lDB->escape($rf_bank_name)."'
		)
	");	

	$rf_bank_id = $lDB->insert_id;
	
	return $rf_bank_id;	
}

function db_rf_bank_debt($rf_currency_id, $pr_business_id) {
	global $lDB;

	if(db_rf_bank_extras_by_debt($rf_currency_id,$pr_business_id)) {
		$rf_bank_id = $lDB->get("
			SELECT
				rf_bank_ix
			FROM
				rf_bank
			WHERE
				rf_bank_db = '$GLOBALS[dbcode]'
				AND rf_currency_id = '$rf_currency_id'
				AND pr_business_id = '$pr_business_id'			
				AND rf_bank_sys_code = '7'
		",4);
	} else {
		$pr_bus_inv_prefix = $lDB->get("SELECT pr_bus_inv_prefix FROM pr_business WHERE pr_business_id = '$pr_business_id'",4);
		$rf_currency_symbol = $lDB->get("SELECT rf_currency_symbol FROM rf_currency WHERE rf_currency_ix = '$rf_currency_id'",4);
		$rf_bank_acc_name = "Ledger ($GLOBALS[dbcode] - $pr_bus_inv_prefix - $rf_currency_symbol)";
		$rf_bank_abbrev = ""; // FIXME: "L$GLOBALS[dbcode]$pr_bus_inv_prefix$rf_currency_symbol";
		$rf_bank_id = db_rf_bank_insert(0,$rf_currency_id,$rf_bank_acc_name,$rf_bank_abbrev,"","","","","",$pr_business_id,7);
	}

	db_pr_bus_bank_insert($rf_bank_id, $pr_business_id);

	return $rf_bank_id;
}
