<?php
require_once(__DIR__ . "/db.pr_business.php");

function db_rf_bank_inv_exists($rf_bank_inv_ix) {
	$bankCount = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM rf_bank_inv WHERE rf_bank_id = '$rf_bank_inv_ix'",4);
	if($bankCount > 0) {
		return true;
	} else {
		return false;
	}
}

function db_rf_bank_inv_exists_by_all($pr_business_id,$rf_bank_id) {
	$bankCount = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM rf_bank_inv WHERE pr_business_id = '$pr_business_id' AND rf_bank_id = '$rf_bank_id'",4);
	if($bankCount > 0) {
		return true;
	} else {
		return false;
	}
}

function db_rf_bank_inv_get_ix($pr_business_id,$rf_bank_id) {
	return $GLOBALS['lDB']->get("SELECT rf_bank_inv_ix FROM rf_bank_inv WHERE pr_business_id = '$pr_business_id' AND rf_bank_id = '$rf_bank_id'",4);
}

function db_rf_bank_inv_insert($pr_business_id,$rf_bank_id,$fn_ledger_id_account,$fn_ledger_id_deposit) {
	global $dbcode;
	global $lDB;

	if(db_pr_business_ledger_allow($pr_business_id)) {
		$lDB->put("
			INSERT INTO rf_bank_inv (
				rf_bank_inv_db,
				rf_bank_id,
				pr_business_id,
				fn_ledger_id_account,
				fn_ledger_id_deposit
			) VALUES (
				'".$lDB->escape($dbcode)."',
				'".$lDB->escape($rf_bank_id)."',
				'".$lDB->escape($pr_business_id)."',
				'".$lDB->escape($fn_ledger_id_account)."',
				'".$lDB->escape($fn_ledger_id_deposit)."'
			)
		");
	
		$rfBankLedgerID = $GLOBALS['lDB']->insert_id;
		return $rfBankLedgerID;
	} else {
		return false;
	}
}

function db_rf_bank_inv_update($rf_bank_inv_ix,$fn_ledger_id_account,$fn_ledger_id_deposit) {
	global $lDB;

	$pr_business_id = $lDB->get("SELECT pr_business_id FROM rf_bank_inv WHERE rf_bank_inv_ix = '$rf_bank_inv_ix'",4);
	if(db_pr_business_ledger_allow($pr_business_id)) {
		$master = $lDB->isMaster;
		$lDB->isMaster = "1";
		$lDB->put("
			UPDATE rf_bank_inv SET
				fn_ledger_id_account = '".$lDB->escape($fn_ledger_id_account)."',
				fn_ledger_id_deposit = '".$lDB->escape($fn_ledger_id_deposit)."'
			WHERE
				rf_bank_inv_ix = '$rf_bank_inv_ix'
		");
		$lDB->isMaster = $master;
		return true;
	} else {
		return false;
	}
}

function db_rf_bank_inv_set($pr_business_id,$rf_bank_id,$fn_ledger_id_account,$fn_ledger_id_deposit) {
	if(db_rf_bank_inv_exists_by_all($pr_business_id,$rf_bank_id)) {
		db_rf_bank_inv_update(db_rf_bank_inv_get_ix($pr_business_id,$rf_bank_id),$fn_ledger_id_account,$fn_ledger_id_deposit);
	} else {
		db_rf_bank_inv_insert($pr_business_id,$rf_bank_id,$fn_ledger_id_account,$fn_ledger_id_deposit);
	}
}
