<?php

require_once(__DIR__ . '/db.pr_business.php');
require_once(__DIR__ . '/db.rf_database.php');

function db_rf_db_business_exists($rf_db_business_id) {
	global $lDB;
	
	$check = $lDB->get("
		SELECT COUNT(rf_db_business_ix) FROM rf_db_business WHERE rf_db_business_ix = '" . $lDB->escape($rf_db_business_id) . "'
	",4);
	if($check > 0) { return true; } else { return false; }
}

function db_rf_db_business_exists_by_business($pr_business_id) {
	global $lDB;
	
	$check = $lDB->get("
		SELECT COUNT(pr_business_id) FROM rf_db_business WHERE pr_business_id = '" . $lDB->escape($pr_business_id) . "'
	",4);
	if($check > 0) { return true; } else { return false; }
}

function db_rf_db_business_insert($rf_db_code, $pr_business_id) {
	global $lDB;
	global $dbcode;

	if(
		!db_rf_database_exists_by_code($rf_db_code)
		|| !db_pr_business_exists($pr_business_id)
		|| db_rf_db_business_exists_by_business($pr_business_id)
	) {
		return false;
	}

	$lDB->put("
		INSERT INTO rf_db_business (
			rf_db_business_db,
			rf_db_businesS_id,
			rf_db_code,
			pr_business_id
		) VALUES (
			'" . $lDB->escape($dbcode) . "',
			'',
			'" . $lDB->escape($rf_db_code) . "',
			'" . $lDB->escape($pr_business_id) . "'
		)
	");

	return $lDB->insert_id;
}

function db_rf_db_business_delete($rf_db_business_id) {
	global $lDB;

	if(!db_rf_db_business_exists($rf_db_business_id)) {
		return false;
	}

	$lDB->put("DELETE FROM rf_db_business WHERE rf_db_business_ix = '" . $lDB->escape($rf_db_business_id) . "'");

	return true;
}

function db_rf_db_business_get_by_all($rf_db_code, $pr_business_id) {
	global $lDB;

	return $lDB->get("
		SELECT
			rf_db_business.rf_db_business_ix
		FROM
			rf_db_business
		WHERE
			rf_db_code = '" . $lDB->escape($rf_db_code) . "'
			AND pr_business_id = '" . $lDB->escape($pr_business_id) . "'
	",4);
}

function db_rf_db_business_delete_by_all($rf_db_code, $pr_business_id) {
	$rf_db_business_id = db_rf_db_business_get_by_all($rf_db_code, $pr_business_id);
	if(empty($rf_db_business_id)) {
		return false;
	}

	return db_rf_db_business_delete($rf_db_business_id);
}

function db_rf_db_business_get_by_business($pr_business_id) {
	global $lDB;

	if(!db_rf_db_business_exists_by_business($pr_business_id)) {
		return false;
	}

	return $lDB->get("
		SELECT
			rf_db_business.rf_db_code
		FROM
			rf_db_business
		WHERE
			rf_db_business.pr_business_id = '" . $lDB->escape($pr_business_id) . "'
	",4);
}
