<?php

function db_rf_exchange_rate_exists($rf_exchange_rate_id) {
	$count = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			rf_exchange_rate
		WHERE
			rf_exchange_rate_ix = '$rf_exchange_rate_id'
	",4);
	if($count > 0) {
		return true;
	} else {
		return false;
	}
}

function db_rf_exchange_rate_exists_by_all($rf_exch_curr_from_id,$rf_exch_curr_to_id,$rf_exch_date=false) {
	if($rf_exch_date === false) {
		$rf_exch_date = date("Y-m-d");
	}

	$count = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			rf_exchange_rate
		WHERE
			rf_exch_curr_from_id = '$rf_exch_curr_from_id'
			AND rf_exch_curr_to_id = '$rf_exch_curr_to_id'
			AND rf_exch_date = '$rf_exch_date'
			".db_rf_exchange_rate_get_db_where()."
	",4);
	if($count > 0) {
		return true;
	} else {
		return false;
	}
}

function db_rf_exchange_rate_insert($rf_exch_curr_from_id,$rf_exch_curr_to_id,$rf_exch_rate,$rf_exch_date=false) {
	global $lDB;
	global $dbcode;

	if($rf_exch_curr_from_id == $rf_exch_curr_to_id) {
		return false;
	}

	if($rf_exch_date === false) {
		$rf_exch_date = date("Y-m-d");
	}

	if(db_rf_exchange_rate_exists_by_all($rf_exch_curr_from_id,$rf_exch_curr_to_id,$rf_exch_date)) {
		return false;
	}

	$rf_exch_rate = trimExchangeRate($rf_exch_rate);

	$lDB->put("
		INSERT INTO rf_exchange_rate (
			rf_exchange_rate_db,
			rf_exch_curr_from_id,
			rf_exch_curr_to_id,
			rf_exch_rate,
			rf_exch_date
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($rf_exch_curr_from_id)."',
			'".$lDB->escape($rf_exch_curr_to_id)."',
			'".$lDB->escape($rf_exch_rate)."',
			'".$lDB->escape($rf_exch_date)."'
		)
	");

	$rf_exchange_rate_id = $GLOBALS['lDB']->insert_id;
	$rf_exchange_rate_ix = $dbcode . $rf_exchange_rate_id;

	$lDB->put("
		UPDATE rf_exchange_rate SET
			rf_exchange_rate_ix = '".$lDB->escape($rf_exchange_rate_ix)."'
		WHERE
			rf_exchange_rate_db = '$dbcode'
			AND rf_exchange_rate_id = '$rf_exchange_rate_id'
	");

	return $rf_exchange_rate_ix;
}

function db_rf_exchange_rate_update($rf_exchange_rate_id,$rf_exch_rate) {

	global $lDB;

	if(!db_rf_exchange_rate_exists($rf_exchange_rate_id)) {
		return false;
	}

	$rf_exch_rate = trimExchangeRate($rf_exch_rate);

	$lDB->put("
		UPDATE rf_exchange_rate SET
			rf_exch_rate = '".$lDB->escape($rf_exch_rate)."'
		WHERE
			rf_exchange_rate_ix = '$rf_exchange_rate_id'
	");
}

function db_rf_exchange_rate_get_db() {
	global $lDB;
	global $dbcode;

	$settings = $lDB->get("
		SELECT
			rf_default.rf_exch_master_db_ind,
			rf_default.rf_exch_master_db_id,
			rf_database.rf_db_code
		FROM
			rf_default
			LEFT JOIN rf_database ON rf_database.rf_database_id = rf_exch_master_db_id
	",1);	

	$allow = false;

	if($settings['rf_exch_master_db_ind'] == "1") {
		$allow = true;
		$databases = array($dbcode);
	} elseif($settings['rf_exch_master_db_ind'] == "2") {
		if($settings['rf_exch_master_db_id'] == "0") {
			$databases = $lDB->get("SELECT rf_db_code FROM rf_database WHERE rf_db_env_type_ind = '2'",3);
			if(in_array($dbcode,$databases) && isMasterDB()) {
				$allow = true;
			}
		} else {
			$databases = array($settings['rf_db_code']);
			if($settings['rf_db_code'] == $dbcode) {
				$allow = true;
			}			
		}
	}

	return array(
		'allow'=>$allow,
		'databases'=>$databases
	);
	
}

function db_rf_exchange_rate_get_db_where() {

	$db = db_rf_exchange_rate_get_db();

	return "
		AND rf_exchange_rate.rf_exchange_rate_db IN ('".join("','",$db['databases'])."')
	";
}
function db_rf_exchange_rate_set($rf_exch_curr_from_id,$rf_exch_curr_to_id,$rf_exch_rate,$rf_exch_date=false) {
	global $lDB;

	if($rf_exch_curr_from_id == $rf_exch_curr_to_id) {
		return false;
	}

	$settings = $lDB->get("
		SELECT
			rf_default.rf_exch_save_yn,
			rf_default.rf_exch_allow_update_yn
		FROM
			rf_default
	",1);	
	
	if($settings['rf_exch_save_yn'] != "1") {
		return false;
	}

	$db = db_rf_exchange_rate_get_db();

	if(!$db['allow']) {
		return false;
	}
	
	if($rf_exch_date === false) {
		$rf_exch_date = date("Y-m-d");
	}

	if(db_rf_exchange_rate_exists_by_all($rf_exch_curr_from_id,$rf_exch_curr_to_id,$rf_exch_date)) {
		if($settings['rf_exch_allow_update_yn'] != "1") {
			return false;
		}
		db_rf_exchange_rate_update(db_rf_exchange_rate_get_id_by_all($rf_exch_curr_from_id,$rf_exch_curr_to_id,$rf_exch_date),$rf_exch_rate);
	} else {
		db_rf_exchange_rate_insert($rf_exch_curr_from_id,$rf_exch_curr_to_id,$rf_exch_rate,$rf_exch_date);
	}
}

function db_rf_exchange_rate_get_id_by_all($rf_exch_curr_from_id,$rf_exch_curr_to_id,$rf_exch_date=false) {
	if($rf_exch_date === false) {
		$rf_exch_date = date("Y-m-d");
	}

	return $GLOBALS['lDB']->get("
		SELECT
			rf_exchange_rate_ix
		FROM
			rf_exchange_rate
		WHERE
			rf_exch_curr_from_id = '$rf_exch_curr_from_id'
			AND rf_exch_curr_to_id = '$rf_exch_curr_to_id'
			AND rf_exch_date = '$rf_exch_date'
			".db_rf_exchange_rate_get_db_where()."
		ORDER BY
			rf_exch_date DESC
	",4);
}
	
function db_rf_exchange_rate_get_rate_by_all($rf_exch_curr_from_id,$rf_exch_curr_to_id,$rf_exch_date=false) {
	global $lDB;

	if($rf_exch_date === false) {
		$rf_exch_date = date("Y-m-d");
	}

	$rf_exch_show_past_yn = $lDB->get("SELECT rf_exch_show_past_yn FROM rf_default",4);

	if($rf_exch_show_past_yn == "1") {
		$dateWhere = "AND rf_exch_date <= '$rf_exch_date'";
	} else {
		$dateWhere = "AND rf_exch_date = '$rf_exch_date'";
	}

	$rf_exch_rate = $GLOBALS['lDB']->get("
		SELECT
			rf_exch_rate
		FROM
			rf_exchange_rate
		WHERE
			rf_exch_curr_from_id = '$rf_exch_curr_from_id'
			AND rf_exch_curr_to_id = '$rf_exch_curr_to_id'
			$dateWhere
			".db_rf_exchange_rate_get_db_where()."
		ORDER BY
			rf_exch_date DESC
	",4);

	if(empty($rf_exch_rate)) {
		return "";
	} else {
		return trimExchangeRate($rf_exch_rate);
	}
}

function db_rf_exchange_rate_get_all_rates($rf_exch_date=false) {
	global $lDB;

	if($rf_exch_date === false) {
		$rf_exch_date = date("Y-m-d");
	}

	$combinations = $lDB->get("
		SELECT DISTINCT
			rf_exchange_rate.rf_exch_curr_from_id,
			rf_exchange_rate.rf_exch_curr_to_id
		FROM
			rf_exchange_rate
			INNER JOIN rf_currency AS from_currency ON from_currency.rf_currency_ix = rf_exchange_rate.rf_exch_curr_from_id
			INNER JOIN rf_currency AS to_currency ON to_currency.rf_currency_ix = rf_exchange_rate.rf_exch_curr_to_id
		WHERE
			1
			".db_rf_exchange_rate_get_db_where()."
	",2);

	$rates = array();
	foreach($combinations as $item) {
		$rate = db_rf_exchange_rate_get_rate_by_all($item['rf_exch_curr_from_id'],$item['rf_exch_curr_to_id'],$rf_exch_date);
		if(!empty($rate)) {
			$item['rf_exch_rate'] = $rate;
			$rates[] = array(
				'rf_exch_curr_from_id'=>$item['rf_exch_curr_from_id'],
				'rf_exch_curr_to_id'=>$item['rf_exch_curr_to_id'],
				'rf_exch_rate'=>$rate
			);
		}
	}

	return $rates;
}
