<?php

require_once(__DIR__ . "/db.rf_obj_guest_data.php");

define("DB_RF_OBJ_GUEST_TEXTBOX",1);
define("DB_RF_OBJ_GUEST_TEXTAREA",2);
define("DB_RF_OBJ_GUEST_RADIO",3);
define("DB_RF_OBJ_GUEST_CHECKBOX",4);
define("DB_RF_OBJ_GUEST_SELECTBOX",5);
define("DB_RF_OBJ_GUEST_NUMERIC",6);
define("DB_RF_OBJ_GUEST_DATE",7);
define("DB_RF_OBJ_GUEST_NATION_LOOKUP",8);

function db_rf_obj_guest_exists($rf_obj_guest_id) {
	global $lDB;
	$check = $lDB->get("SELECT COUNT(rf_obj_guest_ix) FROM rf_obj_guest WHERE rf_obj_guest_ix = '".$lDB->escape($rf_obj_guest_id)."'",4);
	if($check > 0) { 
		return true; 
	} else { 
		return false; 
	}
}

function db_rf_obj_guest_insert($rf_obj_guest_type_ind, $rf_obj_guest_label, $rf_obj_guest_mandatory_yn=0) {
	global $lDB;
	global $dbcode;
		
	$rf_obj_guest_sort_seq = $lDB->get("
		SELECT 
			MAX(rf_obj_guest_sort_seq) 
		FROM 
			rf_obj_guest 
		WHERE 
			rf_obj_guest_inactive_yn = '0'
	", 4);
	if($rf_obj_guest_sort_seq > 0) {
		$rf_obj_guest_sort_seq++;
	} else {
		$rf_obj_guest_sort_seq = 1;
	}

	$lDB->put("
		INSERT INTO rf_obj_guest (
			rf_obj_guest_db,
			rf_obj_guest_label,
			rf_obj_guest_type_ind,
			rf_obj_guest_sort_seq,
			rf_obj_guest_mandatory_yn
			
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($rf_obj_guest_label)."',
			'".$lDB->escape($rf_obj_guest_type_ind)."',
			'".$lDB->escape($rf_obj_guest_sort_seq)."',
			'".$lDB->escape($rf_obj_guest_mandatory_yn)."'
		)
	");

	$rf_obj_guest_id = $lDB->insert_id;

	return $rf_obj_guest_id;	
}

function db_rf_obj_guest_update($rf_obj_guest_id, $rf_obj_guest_label, $rf_obj_guest_mandatory_yn=0) {
	global $lDB;
	if(!db_rf_obj_guest_exists($rf_obj_guest_id)) {
		return false;
	}
	$lDB->put("
		UPDATE 
			rf_obj_guest 
		SET
			rf_obj_guest_label = '".$lDB->escape($rf_obj_guest_label)."',
			rf_obj_guest_mandatory_yn = '".$lDB->escape($rf_obj_guest_mandatory_yn)."'
		WHERE
			rf_obj_guest_ix = '$rf_obj_guest_id'
	");
}

function db_rf_obj_guest_set_sort_seq($rf_obj_guest_id, $rf_obj_guest_sort_seq) {
	global $lDB;
	if(!db_rf_obj_guest_exists($rf_obj_guest_id)) {
		return false;
	}
	
	$lDB->put("
		UPDATE 
			rf_obj_guest 
		SET
			rf_obj_guest_sort_seq = '".$lDB->escape($rf_obj_guest_sort_seq)."'
		WHERE
			rf_obj_guest_ix = '$rf_obj_guest_id'
	");
}

function db_rf_obj_guest_set_inactive($rf_obj_guest_id, $rf_obj_guest_inactive_yn=0) {
	global $lDB;
	if(!db_rf_obj_guest_exists($rf_obj_guest_id)) {
		return false;
	}
	$lDB->put("
		UPDATE rf_obj_guest SET
			rf_obj_guest_inactive_yn = '".$lDB->escape($rf_obj_guest_inactive_yn)."'
		WHERE
			rf_obj_guest_ix = '$rf_obj_guest_id'
	");
}

function db_rf_obj_guest_delete($rf_obj_guest_id) {
	global $lDB;
	if(!db_rf_obj_guest_exists($rf_obj_guest_id)) {
		return false;
	}
	
	$rf_obj_guest_data_ids = $lDB->get("
		SELECT 
			rf_obj_guest_data_ix 
		FROM 
			rf_obj_guest_data 
		WHERE 
			rf_obj_guest_id = '$rf_obj_guest_id'
	", 3);
	foreach($rf_obj_guest_data_ids as $rf_obj_guest_data_id) {
		db_rf_obj_guest_data_delete($rf_obj_guest_data_id);
	}
	
	$res = $lDB->put("DELETE FROM rf_obj_guest WHERE rf_obj_guest_ix = '$rf_obj_guest_id'");
	
	return $res;
}

function db_rf_obj_guest_select($rf_obj_guest_id) {
	global $lDB;
	$obj_guest = $lDB->get("SELECT * FROM rf_obj_guest WHERE rf_obj_guest_ix = '$rf_obj_guest_id'", 2);

	if(count($obj_guest) > 0) {
		$obj_guest_data = db_rf_obj_guest_data_select($obj_guest[0]['rf_obj_guest_ix']);
		if(count($obj_guest_data)>0) {
			$obj_guest[0]['obj_data'] = $obj_guest_data;
		} else {
			$obj_guest[0]['obj_data'] = array();
		}

		return $obj_guest[0]; 
	} else { 
		return false; 
	}
}

function db_rf_obj_guest_select_by_condition($where, $orderbyfield='', $order='') {
	global $lDB;
	
	$recordid = $lDB->get("
		SELECT 
			rf_obj_guest_label,
			rf_obj_guest_sort_seq,
			rf_obj_guest_inactive_yn,
			rf_obj_guest_ix,
			rf_obj_guest_db,
			rf_obj_guest_type_ind
		FROM 
			rf_obj_guest " . $where . "
		ORDER BY " . $orderbyfield ." ". $order
	, 2);
	
	return $recordid;
}

function db_rf_obj_guest_select_count($where='') {
	global $lDB;
	$counter = $lDB->get("SELECT count(*) from rf_obj_guest ".$where,4);

	return $counter;
}

function db_rf_obj_guest_select_type($rf_obj_guest_id) {
	global $lDB;
	$rf_obj_guest_type_ind = $lDB->get("
		SELECT 
			rf_obj_guest_type_ind 
		FROM 
			rf_obj_guest 
		WHERE 
			rf_obj_guest_ix = '$rf_obj_guest_id'", 4);
	
	return $rf_obj_guest_type_ind;
}


function db_rf_obj_guest_type_ind_desc($rf_obj_guest_type_ind) {
	switch($rf_obj_guest_type_ind) {
	case DB_RF_OBJ_GUEST_TEXTBOX:
		return "Textfield";
	case DB_RF_OBJ_GUEST_TEXTAREA:
		return "Textarea";
	case DB_RF_OBJ_GUEST_RADIO:
		return "Radio button";
	case DB_RF_OBJ_GUEST_CHECKBOX:
		return "Checkbox";
	case DB_RF_OBJ_GUEST_SELECTBOX:
		return "Drop down";
	case DB_RF_OBJ_GUEST_NUMERIC:
		return "Numeric field";
	case DB_RF_OBJ_GUEST_DATE:
		return "Date";
	case DB_RF_OBJ_GUEST_NATION_LOOKUP:
		return "Country lookup";
	default:
		return "Unknown";
	}
}

function db_rf_obj_guest_find_field_name($rf_obj_guest_sys_code) {
	switch($rf_obj_guest_sys_code) {
	case 1;
		$field_name = "rf_country_id";
		break;
	case 2;
		$field_name = "pr_birthdate";
		break;
	case 3;
		$field_name = "pr_anniversary";
		break;
	case 4;
		$field_name = "pr_guest_memo";
		break;
	case 5;
		$field_name = "pr_guest_note";
		break;
	case 6;
		$field_name = "pr_guest_gender";
		break;
	case 7;
		$field_name = "rf_guest_type_ix";
		break;
	case 8;
		$field_name = "pr_identity_no";
		break;
	}

	return $field_name;
}

function db_rf_obj_guest_get_all($rf_obj_guest_id, $value) {
	global $lDB;

	if(!db_rf_obj_guest_exists($rf_obj_guest_id)) {
		return false;
	}

	$rf_obj_guest = $lDB->get("
		SELECT
			rf_obj_guest.rf_obj_guest_type_ind,
			rf_obj_guest.rf_obj_guest_sys_code,
			rf_obj_guest_data.rf_obj_guest_data_content
		FROM
			rf_obj_guest
			LEFT JOIN rf_obj_guest_data ON rf_obj_guest_data.rf_obj_guest_data_ix = '".$lDB->escape($value)."'
		WHERE
			rf_obj_guest.rf_obj_guest_ix = '".$lDB->escape($rf_obj_guest_id)."'
	",1);

	$id = "";
	$code = "";
	
	switch($rf_obj_guest['rf_obj_guest_type_ind']) {
	case DB_RF_OBJ_GUEST_CHECKBOX:
	case DB_RF_OBJ_GUEST_RADIO:
	case DB_RF_OBJ_GUEST_SELECTBOX:
		$id = $value;
		if($rf_obj_guest['rf_obj_guest_sys_code'] != 7) {
			$value = $rf_obj_guest['rf_obj_guest_data_content'];
		} else {
			$value = $lDB->get("SELECT rf_guest_type_name FROM rf_guest_type WHERE rf_guest_type_ix = '".$lDB->escape($id)."'",4);
			$code = $lDB->get("SELECT rf_guest_type_abbrv FROM rf_guest_type WHERE rf_guest_type_ix = '".$lDB->escape($id)."'",4);
		}
		break;
	case DB_RF_OBJ_GUEST_NATION_LOOKUP:
		$id = $value;
		$value = $lDB->get("SELECT rf_country_name FROM rf_country WHERE rf_country_ix = '".$lDB->escape($id)."'",4);
		$code = $lDB->get("SELECT rf_country_code FROM rf_country WHERE rf_country_ix = '".$lDB->escape($id)."'",4);
		break;
	case DB_RF_OBJ_GUEST_TEXTBOX:
	case DB_RF_OBJ_GUEST_NUMERIC:
	case DB_RF_OBJ_GUEST_DATE:
	case DB_RF_OBJ_GUEST_TEXTAREA:
	default:
		break;
	}

	return [
		'id' => $id,
		'code' => $code,
		'value' => $value
	];
}

function db_rf_obj_guest_has_duplicated_sequence(){
    global $lDB;

    $sql = "
      SELECT 
	  rf_obj_guest_sort_seq, 
      COUNT(*) AS db_rf_obj_guest_sort_seq_counter
      FROM 
	  rf_obj_guest 
      GROUP BY rf_obj_guest_sort_seq HAVING db_rf_obj_guest_sort_seq_counter > 1";

    $rf_obj_guest = $lDB->get($sql, 4);

    return (isset($rf_obj_guest) && $rf_obj_guest != "") ? true : false;
}

function db_rf_obj_guest_reset_sequence() {
    global $lDB;

    $sql = " 
        SELECT 
	  	  rf_obj_guest_ix, rf_obj_guest_type_ind, rf_obj_guest_label
	    FROM 
		  rf_obj_guest
        WHERE
          1
        ORDER BY rf_obj_guest_sort_seq ASC";

    $rf_obj_guest = $lDB->get($sql, 2);
    $sequence = 1;
    foreach($rf_obj_guest as $rf_obj_guest){
		if ($rf_obj_guest['rf_obj_guest_type_ind'] == '0' && empty($rf_obj_guest['rf_obj_guest_label'])) {
			db_rf_obj_guest_delete($rf_obj_guest['rf_obj_guest_ix']);
		} else {
			db_rf_obj_guest_set_sort_seq($rf_obj_guest['rf_obj_guest_ix'], $sequence);
			$sequence++;
		}
    }
}
