<?php
require_once(__DIR__ . "/db.rf_obj_guest.php");

function db_rf_obj_guest_data_exists($rf_obj_guest_data_id,$rf_obj_guest_id=false) {
	global $lDB;

	$extraWhere = "";
	if($rf_obj_guest_id !== false) {
		$extraWhere = " AND rf_obj_guest_id = '".$lDB->escape($rf_obj_guest_id)."' ";
	}

	$check = $lDB->get("
		SELECT
			COUNT(rf_obj_guest_data_ix)
		FROM
			rf_obj_guest_data
		WHERE
			rf_obj_guest_data_ix = '".$lDB->escape($rf_obj_guest_data_id)."'
			$extraWhere
	",4);
	if($check > 0) { 
		return true; 
	} else { 
		return false; 
	}
}

function db_rf_obj_guest_data_insert( $rf_obj_guest_id, $rf_obj_guest_data_content, $rf_obj_guest_data_sort_seq, $rf_obj_guest_data_default_yn = 0) {
	
	global $lDB;
	global $dbcode;
	if(!db_rf_obj_guest_exists($rf_obj_guest_id)) {
		return false;
	}

	$lDB->put("
		INSERT INTO rf_obj_guest_data (
			rf_obj_guest_data_db,
			rf_obj_guest_data_content,
			rf_obj_guest_data_sort_seq,
			rf_obj_guest_id,
			rf_obj_guest_data_default_yn
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($rf_obj_guest_data_content)."',
			'".$lDB->escape($rf_obj_guest_data_sort_seq)."',
			'".$lDB->escape($rf_obj_guest_id)."',
			'".$lDB->escape($rf_obj_guest_data_default_yn)."'
		)
	");
	
	$rf_obj_guest_data_id = $lDB->insert_id;

	return $rf_obj_guest_data_id;	
}

function db_rf_obj_guest_data_update($rf_obj_guest_data_id, $rf_obj_guest_data_content, $rf_obj_guest_data_sort_seq, $rf_obj_guest_data_inactive_yn=0) {
	global $lDB;
	if(!db_rf_obj_guest_data_exists($rf_obj_guest_data_id)) {
		return false;
	}
	$lDB->put("
		UPDATE rf_obj_guest_data SET
			rf_obj_guest_data_content = '".$lDB->escape($rf_obj_guest_data_content)."',
			rf_obj_guest_data_sort_seq = '".$lDB->escape($rf_obj_guest_data_sort_seq)."',
			rf_obj_guest_data_inactive_yn = '".$lDB->escape($rf_obj_guest_data_inactive_yn)."'
		WHERE
			rf_obj_guest_data_ix = '$rf_obj_guest_data_id'
	");
}

function db_rf_obj_guest_data_delete($rf_obj_guest_data_id) {
	global $lDB;
	if(!db_rf_obj_guest_data_exists($rf_obj_guest_data_id)) {
		return false;
	}

	$check = $lDB->get("
		SELECT 
			COUNT(pr_guest_obj_data.rf_obj_guest_data_id)
		FROM 
			pr_guest_obj_data
		WHERE
			pr_guest_obj_data.rf_obj_guest_data_id = '$rf_obj_guest_data_id'
	",4);
	
	if ($check != "0") {
		$res = $lDB->put("UPDATE rf_obj_guest_data set rf_obj_guest_data_inactive_yn = '1' WHERE rf_obj_guest_data_ix = '$rf_obj_guest_data_id'");
          
	} else {
			$res = $lDB->put("DELETE FROM rf_obj_guest_data WHERE rf_obj_guest_data_ix = '$rf_obj_guest_data_id'");
	}
	
	return $res;
}

function db_rf_obj_guest_data_select($rf_obj_guest_id) {
	global $lDB;
	
	$obj_guest_data = $lDB->get("SELECT * FROM rf_obj_guest_data WHERE rf_obj_guest_id = '$rf_obj_guest_id' ORDER BY rf_obj_guest_data_sort_seq", 2);

	if(count($obj_guest_data) > 0) {
		return $obj_guest_data; 
	} else { 
		return false; 
	}

}
