<?php
require_once(__DIR__ . "/db.rf_obj_registration_card_data.php");
define("DB_RF_OBJ_registration_card_TEXTBOX",1);
define("DB_RF_OBJ_registration_card_TEXTAREA",2);
define("DB_RF_OBJ_registration_card_RADIO",3);
define("DB_RF_OBJ_registration_card_CHECKBOX",4);
define("DB_RF_OBJ_registration_card_SELECTBOX",5);
define("DB_RF_OBJ_registration_card_NUMERIC",6);

function db_rf_obj_registration_card_exists($rf_obj_registration_card_id) {
	global $lDB;

	$check = $lDB->get("SELECT COUNT(rf_obj_registration_card_ix) FROM rf_obj_registration_card WHERE rf_obj_registration_card_ix = '".$lDB->escape($rf_obj_registration_card_id)."'",4);
	if($check > 0) { 
		return true; 
	} else { 
		return false; 
	}
}

function db_rf_obj_registration_card_exists_by_name($rf_registration_card_name) {
	global $lDB;

	$objectCheck = $lDB->get("SELECT COUNT(rf_obj_registration_card_ix) FROM rf_obj_registration_card WHERE rf_obj_registration_card_name = '$rf_registration_card_name'",4);
	if($objectCheck > 0) { return true; } else { return false; }
}

function db_rf_obj_registration_card_by_name($rf_registration_card_name) {
	global $lDB;

	if(!db_rf_obj_registration_card_exists_by_name($rf_registration_card_name)) {
		return false;
	}

	return $lDB->get("SELECT rf_obj_registration_card_ix FROM rf_obj_registration_card WHERE rf_obj_registration_card_name = '$rf_registration_card_name'",4);
}



function db_rf_obj_registration_card_insert($rf_obj_registration_card_label, $rf_obj_registration_card_type_ind, $rf_obj_registration_card_sort_seq, $rf_obj_registration_card_mandatory_yn=0) {
	global $lDB;
	global $dbcode;

	$lDB->put("
		INSERT INTO rf_obj_registration_card (
			rf_obj_registration_card_db,
			rf_obj_registration_card_label,
			rf_obj_registration_card_type_ind,
			rf_obj_registration_card_sort_seq,
			rf_obj_registration_card_mandatory_yn
			
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($rf_obj_registration_card_label)."',
			'".$lDB->escape($rf_obj_registration_card_type_ind)."',
			'".$lDB->escape($rf_obj_registration_card_sort_seq)."',
			'".$lDB->escape($rf_obj_registration_card_mandatory_yn)."'
		)
	");

	$rf_obj_registration_card_id = $lDB->insert_id;

	return $rf_obj_registration_card_id;	
}

function db_rf_obj_registration_card_update($rf_obj_registration_card_id, $rf_obj_registration_card_label, $rf_obj_registration_card_mandatory_yn=0) {
	global $lDB;
	if(!db_rf_obj_registration_card_exists($rf_obj_registration_card_id)) {
		return false;
	}
	$lDB->put("
		UPDATE 
			rf_obj_registration_card 
		SET
			rf_obj_registration_card_label = '".$lDB->escape($rf_obj_registration_card_label)."',
			rf_obj_registration_card_mandatory_yn = '".$lDB->escape($rf_obj_registration_card_mandatory_yn)."'
		WHERE
			rf_obj_registration_card_ix = '$rf_obj_registration_card_id'
	");
}

function db_rf_obj_registration_card_set_sort_seq($rf_obj_registration_card_id, $rf_obj_registration_card_sort_seq) {
	global $lDB;
	if(!db_rf_obj_registration_card_exists($rf_obj_registration_card_id)) {
		return false;
	}

	$lDB->put("
		UPDATE 
			rf_obj_registration_card 
		SET
			rf_obj_registration_card_sort_seq = '".$lDB->escape($rf_obj_registration_card_sort_seq)."'
		WHERE
			rf_obj_registration_card_ix = '$rf_obj_registration_card_id'
	");
}

function db_rf_obj_registration_card_set_inactive($rf_obj_registration_card_id, $rf_obj_registration_card_inactive_yn=0) {
	global $lDB;
	if(!db_rf_obj_registration_card_exists($rf_obj_registration_card_id)) {
		return false;
	}
	
	$lDB->put("
		UPDATE 
			rf_obj_registration_card 
		SET
			rf_obj_registration_card_inactive_yn = '".$lDB->escape($rf_obj_registration_card_inactive_yn)."'
		WHERE
			rf_obj_registration_card_ix = '$rf_obj_registration_card_id'
	");
}

function db_rf_obj_registration_card_delete($rf_obj_registration_card_id) {
	global $lDB;
	if(!db_rf_obj_registration_card_exists($rf_obj_registration_card_id)) {
		return false;
	}

	$obj_registration_card_data_ixs = db_rf_obj_registration_card_data_id_select_by_parent($rf_obj_registration_card_id);
	if(is_array($obj_registration_card_data_ixs) && !empty($obj_registration_card_data_ixs)) {
		foreach($obj_registration_card_data_ixs as $obj_registration_card_data_ix) {
			$res = db_rf_obj_registration_card_data_delete($obj_registration_card_data_ix);
		}
	}

	$res = $lDB->put("DELETE FROM rf_obj_registration_card WHERE rf_obj_registration_card_ix = '$rf_obj_registration_card_id'");
	return $res;
}

function db_rf_obj_registration_card_select($rf_obj_registration_card_id) {
	global $lDB;
	$obj_registration_card = $lDB->get("SELECT * FROM rf_obj_registration_card WHERE rf_obj_registration_card_ix = '$rf_obj_registration_card_id'", 2);

	if(count($obj_registration_card) > 0) {
		return $obj_registration_card[0]; 
	} else { 
		return false; 
	}
}

function db_rf_obj_registration_card_select_by_condition($where, $orderbyfield='', $order='') {
	$recordid = $GLOBALS['lDB']->get("
		SELECT 
			rf_obj_registration_card_label,
			rf_obj_registration_card_type_ind,
			rf_obj_registration_card_sort_seq,
			rf_obj_registration_card_inactive_yn,
			rf_obj_registration_card_ix,
			rf_obj_registration_card_db
		FROM 
			rf_obj_registration_card " . $where . "
		ORDER BY " . $orderbyfield ." ". $order
	, 2);

	return $recordid;
}

function db_rf_obj_registration_card_select_count($where='') {
	$tempcount = $GLOBALS['lDB']->get("SELECT count(*) from rf_obj_registration_card ".$where,4);
	return $tempcount;
}

function db_rf_obj_registration_card_type_ind_desc($rf_obj_registration_card_type_ind) {
	switch($rf_obj_registration_card_type_ind) {
	case DB_RF_OBJ_registration_card_TEXTBOX:
		return "Textfield";
	case DB_RF_OBJ_registration_card_TEXTAREA:
		return "Textarea";
	case DB_RF_OBJ_registration_card_RADIO:
		return "Radio button";
	case DB_RF_OBJ_registration_card_CHECKBOX:
		return "Checkbox";
	case DB_RF_OBJ_registration_card_SELECTBOX:
		return "Drop down";
	case DB_RF_OBJ_registration_card_NUMERIC:
		return "Numeric field";
	default:
		return "Unknown";
	}
}

function db_rf_obj_registration_card_get_all($rf_obj_registration_card_id, $value) {
	global $lDB;

	if(!db_rf_obj_registration_card_exists($rf_obj_registration_card_id)) {
		return false;
	}

	$rf_obj_registration_card = $lDB->get("
		SELECT
			rf_obj_registration_card.rf_obj_registration_card_type_ind,
			rf_obj_registration_card_data.rf_obj_registration_card_data_content
		FROM
			rf_obj_registration_card
			LEFT JOIN rf_obj_registration_card_data ON rf_obj_registration_card_data.rf_obj_registration_card_data_ix = '".$lDB->escape($value)."'
		WHERE
			rf_obj_registration_card.rf_obj_registration_card_ix = '".$lDB->escape($rf_obj_registration_card_id)."'
	",1);

	$id = "";
	
	switch($rf_obj_registration_card['rf_obj_registration_card_type_ind']) {
	case DB_RF_OBJ_registration_card_RADIO:
	case DB_RF_OBJ_registration_card_SELECTBOX:
	case DB_RF_OBJ_registration_card_CHECKBOX:
		$id = $value;
		$value = $rf_obj_registration_card['rf_obj_registration_card_data_content'];
		break;
	case DB_RF_OBJ_registration_card_TEXTBOX:
	case DB_RF_OBJ_registration_card_TEXTAREA:
	case DB_RF_OBJ_registration_card_NUMERIC:
	default:
		break;
	}

	return [
		'id' => $id,
		'value' => $value
	];
}
