<?php
require_once(__DIR__ . "/db.rf_obj_trip_data.php");
require_once(__DIR__ . "/db.rf_obj_trip_prop.php");
define("DB_RF_OBJ_TRIP_TEXTBOX",1);
define("DB_RF_OBJ_TRIP_TEXTAREA",2);
define("DB_RF_OBJ_TRIP_RADIO",3);
define("DB_RF_OBJ_TRIP_CHECKBOX",4);
define("DB_RF_OBJ_TRIP_SELECTBOX",5);
define("DB_RF_OBJ_TRIP_NUMERIC",6);

function db_rf_obj_trip_exists($rf_obj_trip_id) {
	global $lDB;

	$check = $lDB->get("SELECT COUNT(rf_obj_trip_ix) FROM rf_obj_trip WHERE rf_obj_trip_ix = '".$lDB->escape($rf_obj_trip_id)."'",4);
	if($check > 0) { 
		return true; 
	} else { 
		return false; 
	}
}

function db_rf_obj_trip_insert($rf_obj_trip_label, $rf_obj_trip_type_ind, $rf_obj_trip_sort_seq, $rf_obj_trip_mandatory_yn=0) {
	global $lDB;
	global $dbcode;

	$lDB->put("
		INSERT INTO rf_obj_trip (
			rf_obj_trip_db,
			rf_obj_trip_label,
			rf_obj_trip_type_ind,
			rf_obj_trip_sort_seq,
			rf_obj_trip_mandatory_yn
			
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($rf_obj_trip_label)."',
			'".$lDB->escape($rf_obj_trip_type_ind)."',
			'".$lDB->escape($rf_obj_trip_sort_seq)."',
			'".$lDB->escape($rf_obj_trip_mandatory_yn)."'
		)
	");

	$rf_obj_trip_id = $lDB->insert_id;

	return $rf_obj_trip_id;	
}

function db_rf_obj_trip_update($rf_obj_trip_id, $rf_obj_trip_label, $rf_obj_trip_mandatory_yn=0) {
	global $lDB;
	if(!db_rf_obj_trip_exists($rf_obj_trip_id)) {
		return false;
	}
	$lDB->put("
		UPDATE 
			rf_obj_trip 
		SET
			rf_obj_trip_label = '".$lDB->escape($rf_obj_trip_label)."',
			rf_obj_trip_mandatory_yn = '".$lDB->escape($rf_obj_trip_mandatory_yn)."'
		WHERE
			rf_obj_trip_ix = '$rf_obj_trip_id'
	");
}

function db_rf_obj_trip_set_sort_seq($rf_obj_trip_id, $rf_obj_trip_sort_seq) {
	global $lDB;
	if(!db_rf_obj_trip_exists($rf_obj_trip_id)) {
		return false;
	}

	$lDB->put("
		UPDATE 
			rf_obj_trip 
		SET
			rf_obj_trip_sort_seq = '".$lDB->escape($rf_obj_trip_sort_seq)."'
		WHERE
			rf_obj_trip_ix = '$rf_obj_trip_id'
	");
}

function db_rf_obj_trip_set_inactive($rf_obj_trip_id, $rf_obj_trip_inactive_yn=0) {
	global $lDB;
	if(!db_rf_obj_trip_exists($rf_obj_trip_id)) {
		return false;
	}
	
	$lDB->put("
		UPDATE 
			rf_obj_trip 
		SET
			rf_obj_trip_inactive_yn = '".$lDB->escape($rf_obj_trip_inactive_yn)."'
		WHERE
			rf_obj_trip_ix = '$rf_obj_trip_id'
	");
}

function db_rf_obj_trip_delete($rf_obj_trip_id) {
	global $lDB;
	if(!db_rf_obj_trip_exists($rf_obj_trip_id)) {
		return false;
	}

	$obj_trip_data_ixs = db_rf_obj_trip_data_id_select_by_parent($rf_obj_trip_id);
	if(is_array($obj_trip_data_ixs) && !empty($obj_trip_data_ixs)) {
		foreach($obj_trip_data_ixs as $obj_trip_data_ix) {
			$res = db_rf_obj_trip_data_delete($obj_trip_data_ix);
		}
	}
	$rf_obj_trip_prop_ix = db_rf_obj_trip_prop_id_select($rf_obj_trip_id);
	$res = db_rf_obj_trip_prop_delete($rf_obj_trip_prop_ix);
		
	$res = $lDB->put("DELETE FROM rf_obj_trip WHERE rf_obj_trip_ix = '$rf_obj_trip_id'");
	return $res;
}

function db_rf_obj_trip_select($rf_obj_trip_id) {
	global $lDB;
	$obj_trip = $lDB->get("SELECT * FROM rf_obj_trip WHERE rf_obj_trip_ix = '$rf_obj_trip_id'", 2);

	if(count($obj_trip) > 0) {
		return $obj_trip[0]; 
	} else { 
		return false; 
	}
}

function db_rf_obj_trip_select_by_condition($where, $orderbyfield='', $order='') {
	$recordid = $GLOBALS[lDB]->get("
		SELECT 
			rf_obj_trip_label,
			rf_obj_trip_type_ind,
			rf_obj_trip_sort_seq,
			rf_obj_trip_inactive_yn,
			rf_obj_trip_ix,
			rf_obj_trip_db
		FROM 
			rf_obj_trip " . $where . "
		ORDER BY " . $orderbyfield ." ". $order
	, 2);

	return $recordid;
}

function db_rf_obj_trip_select_count($where='') {
	$tempcount = $GLOBALS[lDB]->get("SELECT count(*) from rf_obj_trip ".$where,4);
	return $tempcount;
}

function db_rf_obj_trip_type_ind_desc($rf_obj_trip_type_ind) {
	switch($rf_obj_trip_type_ind) {
	case DB_RF_OBJ_TRIP_TEXTBOX:
		return "Textfield";
	case DB_RF_OBJ_TRIP_TEXTAREA:
		return "Textarea";
	case DB_RF_OBJ_TRIP_RADIO:
		return "Radio button";
	case DB_RF_OBJ_TRIP_CHECKBOX:
		return "Checkbox";
	case DB_RF_OBJ_TRIP_SELECTBOX:
		return "Drop down";
	case DB_RF_OBJ_TRIP_NUMERIC:
		return "Numeric field";
	default:
		return "Unknown";
	}
}

function db_rf_obj_trip_get_all($rf_obj_trip_id, $value) {
	global $lDB;

	if(!db_rf_obj_trip_exists($rf_obj_trip_id)) {
		return false;
	}

	$rf_obj_trip = $lDB->get("
		SELECT
			rf_obj_trip.rf_obj_trip_type_ind,
			rf_obj_trip_data.rf_obj_trip_data_content
		FROM
			rf_obj_trip
			LEFT JOIN rf_obj_trip_data ON rf_obj_trip_data.rf_obj_trip_data_ix = '".$lDB->escape($value)."'
		WHERE
			rf_obj_trip.rf_obj_trip_ix = '".$lDB->escape($rf_obj_trip_id)."'
	",1);

	$id = "";
	
	switch($rf_obj_trip['rf_obj_trip_type_ind']) {
	case DB_RF_OBJ_TRIP_RADIO:
	case DB_RF_OBJ_TRIP_SELECTBOX:
	case DB_RF_OBJ_TRIP_CHECKBOX:
		$id = $value;
		$value = $rf_obj_trip['rf_obj_trip_data_content'];
		break;
	case DB_RF_OBJ_TRIP_TEXTBOX:
	case DB_RF_OBJ_TRIP_TEXTAREA:
	case DB_RF_OBJ_TRIP_NUMERIC:
	default:
		break;
	}

	return [
		'id' => $id,
		'value' => $value
	];
}
