<?php
require_once(__DIR__ . "/db.rf_obj_trip.php");
require_once(__DIR__ . "/db.rv_trip_obj_data.php");

function db_rf_obj_trip_data_exists($rf_obj_trip_data_id) {
	global $lDB;
	$check = $lDB->get("SELECT COUNT(rf_obj_trip_data_ix) FROM rf_obj_trip_data WHERE rf_obj_trip_data_ix = '$rf_obj_trip_data_id'",4);
	if($check > 0) { 
		return true; 
	} else { 
		return false; 
	}
}

function db_rf_obj_trip_data_insert($rf_obj_trip_id, $rf_obj_trip_data_content, $rf_obj_trip_data_sort_seq, $rf_obj_trip_data_default_yn = 0, $rf_obj_trip_data_inactive_yn = 0) {
	global $lDB;
	global $dbcode;
	
	if(!db_rf_obj_trip_exists($rf_obj_trip_id)) {
		return false;
	}
	$lDB->put("
		INSERT INTO rf_obj_trip_data (
			rf_obj_trip_data_db,
			rf_obj_trip_data_content,
			rf_obj_trip_data_sort_seq,
			rf_obj_trip_id,
			rf_obj_trip_data_default_yn,
			rf_obj_trip_data_inactive_yn
					
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($rf_obj_trip_data_content)."',
			'".$lDB->escape($rf_obj_trip_data_sort_seq)."',
			'".$lDB->escape($rf_obj_trip_id)."',
			'".$lDB->escape($rf_obj_trip_data_default_yn)."', 
			'".$lDB->escape($rf_obj_trip_data_inactive_yn)."'
		)
	");
	
	$rf_obj_trip_data_id = $lDB->insert_id;

	return $rf_obj_trip_data_id;	
}

function db_rf_obj_trip_data_update($rf_obj_trip_data_id, $rf_obj_trip_data_content, $rf_obj_trip_data_sort_seq, $rf_obj_trip_data_inactive_yn=0) {
	global $lDB;
	if(!db_rf_obj_trip_data_exists($rf_obj_trip_data_id)) {
		return false;
	}
	$lDB->put("
		UPDATE rf_obj_trip_data SET
			rf_obj_trip_data_content = '".$lDB->escape($rf_obj_trip_data_content)."',
			rf_obj_trip_data_sort_seq = '".$lDB->escape($rf_obj_trip_data_sort_seq)."',
			rf_obj_trip_data_inactive_yn = '".$lDB->escape($rf_obj_trip_data_inactive_yn)."'
		WHERE
			rf_obj_trip_data_ix = '$rf_obj_trip_data_id'
	");
}

function db_rf_obj_trip_data_delete($obj_trip_data_id) {
	global $lDB;
	if(!db_rf_obj_trip_data_exists($obj_trip_data_id)) {
		return false;
	}
	
	$check = db_rv_trip_obj_data_exists($obj_trip_data_id, "rf_obj_trip_data_id");
	
	if ($check) {
		$res = $lDB->put("UPDATE rf_obj_trip_data set rf_obj_trip_data_inactive_yn = '1' WHERE rf_obj_trip_data_ix = '$obj_trip_data_id'");
          
	} else {
		$res = $lDB->put("DELETE FROM rf_obj_trip_data WHERE rf_obj_trip_data_ix = '$obj_trip_data_id'");
	}
	
	return $res;
}


function db_rf_obj_trip_data_select($rf_obj_trip_id, $order="") {
	global $lDB;
	$orderSQL = "";
	if($order != "") {
		$orderSQL = " ORDER BY $order";
	}
	$obj_trip_data = $lDB->get("SELECT * FROM rf_obj_trip_data WHERE rf_obj_trip_id = '$rf_obj_trip_id'" . $orderSQL, 2);

	if(count($obj_trip_data) > 0) {
		return $obj_trip_data; 
	} else { 
		return false; 
	}

}

function db_rf_obj_trip_data_id_select_by_parent($rf_obj_trip_id) {
	global $lDB;
	$obj_trip_data_ix = $lDB->get("SELECT rf_obj_trip_data_ix FROM rf_obj_trip_data WHERE rf_obj_trip_id = '$rf_obj_trip_id'", 3);

	if(count($obj_trip_data_ix) > 0) {
		return $obj_trip_data_ix; 
	} else { 
		return false; 
	}

}
