<?php
require_once(__DIR__ . "/db.rf_obj_trip.php");
require_once(__DIR__ . "/db.pr_business.php");

function db_rf_obj_trip_prop_exists($rf_obj_trip_prop_id) {
	global $lDB;

	$check = $lDB->get("SELECT COUNT(rf_obj_trip_prop_ix) FROM rf_obj_trip_prop WHERE rf_obj_trip_prop_ix = '$rf_obj_trip_prop_id'",4);
	if($check > 0) { 
		return true; 
	} else { 
		return false; 
	}
}

function db_rf_obj_trip_prop_exists_by_rf_obj_trip_id($rf_obj_trip_id) {
    global $lDB;

    $check = $lDB->get("SELECT COUNT(rf_obj_trip_prop_ix) FROM rf_obj_trip_prop WHERE rf_obj_trip_id = '$rf_obj_trip_id'",4);
    if($check > 0) {
        return true;
    } else {
        return false;
    }
}

function db_rf_obj_trip_prop_insert($rf_obj_trip_id, $pr_business_id) {
	global $lDB;
	global $dbcode;
	
	if(!db_rf_obj_trip_exists($rf_obj_trip_id)) {
		return false;
	}

	if($pr_business_id != 0 && !db_pr_business_exists($pr_business_id)) {
		return false;
	}

	$lDB->put("
		INSERT INTO rf_obj_trip_prop (
			rf_obj_trip_prop_db,
			rf_obj_trip_id,
			pr_business_id
					
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($rf_obj_trip_id)."',
			'".$lDB->escape($pr_business_id)."'
		)
	");
	
	$rf_obj_trip_prop_id = $lDB->insert_id;

	return $rf_obj_trip_prop_id;	
}

function db_rf_obj_trip_prop_update($rf_obj_trip_id, $pr_business_id) {
	global $lDB;
	if(
	    !db_rf_obj_trip_exists($rf_obj_trip_id) ||
        !db_rf_obj_trip_prop_exists_by_rf_obj_trip_id($rf_obj_trip_id) ||
        (
            $pr_business_id != 0
            && !db_pr_business_exists($pr_business_id)
        )
    ) {
		return false;
	}

	$lDB->put("
		UPDATE 
			rf_obj_trip_prop 
		SET
			pr_business_id = '".$lDB->escape($pr_business_id)."'
		WHERE
			rf_obj_trip_id = '$rf_obj_trip_id'
	");

}

function db_rf_obj_trip_prop_delete($rf_obj_trip_prop_id) {
	global $lDB;
	if(!db_rf_obj_trip_prop_exists($rf_obj_trip_prop_id)) {
		return false;
	}
	$res = $lDB->put("DELETE FROM rf_obj_trip_prop WHERE rf_obj_trip_prop_ix = '$rf_obj_trip_prop_id'");
	return $res;
}

function db_rf_obj_trip_prop_select($rf_obj_trip_id) {
	global $lDB;
	$obj_trip_prop = $lDB->get("SELECT * FROM rf_obj_trip_prop WHERE rf_obj_trip_id = '$rf_obj_trip_id'", 2);
	
	if(count($obj_trip_prop) > 0) {
		return $obj_trip_prop[0]; 
	} else { 
		return false; 
	}
}

function db_rf_obj_trip_prop_id_select($rf_obj_trip_id) {
	global $lDB;
	$rf_obj_trip_prop_ix = $lDB->get("SELECT rf_obj_trip_prop_ix FROM rf_obj_trip_prop WHERE rf_obj_trip_id = '$rf_obj_trip_id'", 4);
	
	return $rf_obj_trip_prop_ix; 
	

}
