<?php

function db_rf_sys_admin_id() {
	global $lDB;

	return $lDB->get("SELECT pr_persona_id FROM rf_sys_admin", 3);
}

function db_rf_sys_admin_primary_id() {
	global $lDB;

	return $lDB->get("SELECT pr_persona_id FROM rf_sys_admin WHERE rf_sys_admin_primary = 1 LIMIT 1", 4);
}

function db_rf_sys_admin_save($admins, $primary) {
	global $lDB, $dbcode;

	$admins = explode(',', $admins);
	$existingAdmins = $lDB->get("SELECT pr_persona_id FROM rf_sys_admin", 3);

	foreach ($admins as $admin) {
		if (!in_array($admin, $existingAdmins)) {
			$primaryFlag = $admin == $primary ? 1 : 0;
			$lDB->put("
				INSERT INTO rf_sys_admin (
					rf_sys_admin_ix,
					rf_sys_admin_db,
					rf_sys_admin_id,
					pr_persona_id
				) VALUES (
					(SELECT GET_UUID()),
					'" . $lDB->escape($dbcode) . "',
					'',
					'" . $lDB->escape($admin) . "'
				)
			");
		}
	}

	foreach ($existingAdmins as $existingAdmin) {
		if (!in_array($existingAdmin, $admins)) {
			$lDB->put("DELETE FROM rf_sys_admin WHERE pr_persona_id = '" . $existingAdmin . "'");
		}
	}

	$currentPrimary = db_rf_sys_admin_primary_id();
	$lDB->put("UPDATE rf_sys_admin SET rf_sys_admin_primary = 0 WHERE pr_persona_id = '" . $currentPrimary . "'");
	if ($primary) {
		// Set specified record as primary
		$lDB->put("UPDATE rf_sys_admin SET rf_sys_admin_primary = 1 WHERE pr_persona_id = '" . $primary . "'");
	} else {
		// Always need one primary, set first record as primary
		$lDB->put("UPDATE rf_sys_admin SET rf_sys_admin_primary = 1 LIMIT 1");
	}
}