<?php

define("DB_RT_COMPONENT_TYPE_GENERAL",0);
define("DB_RT_COMPONENT_TYPE_MEAL_PLAN",1);
define("DB_RT_COMPONENT_TYPE_PRICE_PLAN",2);
define("DB_RT_COMPONENT_TYPE_DRINK_PLAN",3);

function db_rt_component_exists($rt_component_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(rt_component_ix) FROM rt_component WHERE rt_component_ix = '" . $lDB->escape($rt_component_id) . "'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_rt_component_type_desc($rt_component_type_ind) {
	switch($rt_component_type_ind) {
	default:
	case DB_RT_COMPONENT_TYPE_GENERAL:
		return "General";
	case DB_RT_COMPONENT_TYPE_MEAL_PLAN:
		return "Meal plan";
	case DB_RT_COMPONENT_TYPE_PRICE_PLAN:
		return "Price plan";
	case DB_RT_COMPONENT_TYPE_DRINK_PLAN:
		return "Drinks plan";
	}
}

function db_rt_component_get_desc_by_res_item_comp_id($rv_res_item_comp_id) {
	global $lDB;

	return $lDB->get("SELECT
			rt_component_desc
		FROM
			rv_res_item_comp
			LEFt JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
		WHERE
			rv_res_item_comp.rv_res_item_comp_ix = '" . $lDB->escape($rv_res_item_comp_id) . "'",4);
}

function db_rt_component_get_desc_by_res_item_comp_rate_grp_id($rv_res_item_comp_rate_grp_id) {
	global $lDB;

	return $lDB->get("SELECT
			rt_component_desc
		FROM
			rv_res_item_comp_rate_grp
			LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_res_item_comp_ix = rv_res_item_comp_rate_grp.rv_res_item_comp_id
			LEFt JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
		WHERE
		rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix = '" . $lDB->escape($rv_res_item_comp_rate_grp_id) . "'",4);
}
