<?php
require_once(__DIR__ . "/db.pr_business.php");
require_once(__DIR__ . "/db.rt_component.php");

function db_rt_component_inv_exists($rt_component_id,$pr_business_id) {
	$componentCheck = $GLOBALS['lDB']->get("
		SELECT
			rt_component_inv_ix
		FROM
			rt_component_inv
		WHERE
			rt_component_inv.rt_component_id = '$rt_component_id' 
			AND rt_component_inv.pr_business_id = '$pr_business_id'
	",4);

	if ( $componentCheck != "" ) {
		return $componentCheck;
	} else {
		return false;
	}
}

function db_rt_component_inv_insert($rt_component_id, $fn_cost_centre_2_id, $fn_ledger_id, $pr_business_id, $rt_component_inv_meal_code="") {
	global $dbcode;
	global $lDB;

	if(db_pr_business_ledger_allow($pr_business_id)) {
		$lDB->put("
			INSERT INTO rt_component_inv (
				rt_component_inv_db,
				rt_component_id,
				fn_cost_centre_2_id,
				fn_ledger_id,
				pr_business_id,
				rt_component_inv_meal_code
			) VALUES (
				'".$lDB->escape($dbcode)."',
				'".$lDB->escape($rt_component_id)."',
				'".$lDB->escape($fn_cost_centre_2_id)."',
				'".$lDB->escape($fn_ledger_id)."',
				'".$lDB->escape($pr_business_id)."',
				'".$lDB->escape($rt_component_inv_meal_code)."'
			)
		");

		$componentId = $GLOBALS['lDB']->insert_id;
		return $componentId;
	} else {
		return false;
	}
}

function db_rt_component_inv_update($rt_component_inv_ix, $fn_cost_centre_2_id, $fn_ledger_id, $pr_business_id) {
	global $lDB;

	if(db_pr_business_ledger_allow($pr_business_id)) {
		$master = $lDB->isMaster;
		$lDB->isMaster = "1";		
		$lDB->put("
			UPDATE
				rt_component_inv
			SET 
				fn_cost_centre_2_id = '".$lDB->escape($fn_cost_centre_2_id)."',
				fn_ledger_id = '".$lDB->escape($fn_ledger_id)."'
			WHERE
				rt_component_inv.rt_component_inv_ix = '$rt_component_inv_ix'
				AND rt_component_inv.pr_business_id = '$pr_business_id'
		");
		$lDB->isMaster = $master;		
		return true;
	} else {
		return false;
	}
}

function db_rt_component_set_meal_code($pr_business_id, $rt_component_id, $rt_component_inv_meal_code) {
	global $lDB;

	if(!db_pr_business_exists($pr_business_id)) {
		return false;
	}

	if(!db_rt_component_exists($rt_component_id)) {
		return false;
	}

	$rt_component_type_ind = $lDB->get("SELECT rt_component_type_ind FROM rt_component WHERE rt_component_ix = '" . $lDB->escape($rt_component_id) . "'",4);
	if($rt_component_type_ind != DB_RT_COMPONENT_TYPE_MEAL_PLAN) {
		return false;
	}

	$rt_component_inv_id = db_rt_component_inv_exists($rt_component_id,$pr_business_id);
	if($rt_component_inv_id === false) {
		db_rt_component_inv_insert($rt_component_id, "", "", $pr_business_id, $rt_component_inv_meal_code);
	} else {
		$lDB->put("
			UPDATE rt_component_inv SET
				rt_component_inv.rt_component_inv_meal_code = '" . $lDB->escape($rt_component_inv_meal_code) . "'
			WHERE
				rt_component_inv.rt_component_inv_ix = '" . $lDB->escape($rt_component_inv_id) . "'
		");
	}
}
