<?php

function rt_rate_exists_by_id($rateID) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(rt_rate_ix) FROM rt_rate WHERE rt_rate_ix = '$rateID'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function rt_rate_exists($ac_accomm_type_id, $rt_period_id, $rt_rate_type_id) {
	global $lDB;

	$rates = $lDB->get("
		SELECT 
			rt_rate_ix 
		FROM 
			rt_rate 
		WHERE 
			ac_accomm_type_id = '$ac_accomm_type_id' AND
			rt_period_id = '$rt_period_id' AND
			rt_rate_type_id = '$rt_rate_type_id'
	",2);
	if(count($rates) > 0){
		return $rates[0]['rt_rate_ix'];
	} else {
		return false;
	}
}


function rt_rate_insert($ac_accomm_type_id, $rt_period_id, $rt_rate_type_id, $rt_rate_dist_yn="0", $rt_rate_comm_yn="1", $rt_rate_overide_level_ind="2", $rt_rate_oride_comm_yn="0", $rt_rate_ssupp_comm_yn="1", $rt_rate_round_ind="0", $rt_rate_round_dir="0", $rt_rate_round_scale="0", $rt_rate_waive_checks_yn="0", $rt_rate_status_ind="0", $rt_rate_tba_yn="0",$rt_pax_rate_group_yn="0") {
	global $lDB;
	global $dbcode;
	
	if(rt_rate_exists($ac_accomm_type_id, $rt_period_id, $rt_rate_type_id)) {
		return false;
	}

	$lDB->put("
		INSERT INTO rt_rate (
			rt_rate_db,
			ac_accomm_type_id,
			rt_period_id,
			rt_rate_type_id,
			rt_rate_dist_yn,
			rt_rate_comm_yn,
			rt_rate_overide_level_ind,
			rt_rate_oride_comm_yn,
			rt_rate_ssupp_comm_yn,
			rt_rate_round_ind,
			rt_rate_round_dir,
			rt_rate_round_scale,
			rt_rate_waive_checks_yn,
			rt_pax_rate_group_yn,
			rt_rate_status_ind,
			rt_rate_tba_yn
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($ac_accomm_type_id)."',
			'".$lDB->escape($rt_period_id)."',
			'".$lDB->escape($rt_rate_type_id)."',
			'".$lDB->escape($rt_rate_dist_yn)."',
			'".$lDB->escape($rt_rate_comm_yn)."',
			'".$lDB->escape($rt_rate_overide_level_ind)."',
			'".$lDB->escape($rt_rate_oride_comm_yn)."',
			'".$lDB->escape($rt_rate_ssupp_comm_yn)."',
			'".$lDB->escape($rt_rate_round_ind)."',
			'".$lDB->escape($rt_rate_round_dir)."',
			'".$lDB->escape($rt_rate_round_scale)."',
			'".$lDB->escape($rt_rate_waive_checks_yn)."',
			'".$lDB->escape($rt_pax_rate_group_yn)."',
			'".$lDB->escape($rt_rate_status_ind)."',
			'".$lDB->escape($rt_rate_tba_yn)."'
		)
	");

	$rt_rate_id = $lDB->insert_id;

	return $rt_rate_id;	
}


function rt_rate_update($rt_rate_id, $rt_rate_comm_yn, $rt_rate_overide_level_ind, $rt_rate_oride_comm_yn, $rt_rate_ssupp_comm_yn, $rt_rate_round_ind, $rt_rate_round_dir, $rt_rate_round_scale, $rt_rate_waive_checks_yn, $rt_rate_status_ind, $rt_pax_rate_group_yn) {
	global $lDB;

	$lDB->put("
		UPDATE 
			rt_rate
		SET 
			rt_rate_comm_yn = '".$lDB->escape($rt_rate_comm_yn)."', 
			rt_rate_overide_level_ind = '".$lDB->escape($rt_rate_overide_level_ind)."',
			rt_rate_oride_comm_yn = '".$lDB->escape($rt_rate_oride_comm_yn)."', 
			rt_rate_ssupp_comm_yn = '".$lDB->escape($rt_rate_ssupp_comm_yn)."',
			rt_rate_round_ind = '".$lDB->escape($rt_rate_round_ind)."',
			rt_rate_round_dir = '".$lDB->escape($rt_rate_round_dir)."',
			rt_rate_round_scale = '".$lDB->escape($rt_rate_round_scale)."',				
			rt_rate_waive_checks_yn = '".$lDB->escape($rt_rate_waive_checks_yn)."',
			rt_pax_rate_group_yn = '".$lDB->escape($rt_pax_rate_group_yn)."',
			rt_rate_status_ind = '".$lDB->escape($rt_rate_status_ind)."'
		WHERE
			rt_rate.rt_rate_ix = '$rt_rate_id' 
	");
	return true;
}

function rt_rate_delete($rt_rate_id) {

	global $lDB;

	rt_rate_component_delete_by_rate($rt_rate_id);
	
	$lDB->put("
		DELETE FROM 
			rt_rate 
		WHERE 
			rt_rate_ix = '$rt_rate_id'
	");
}

function db_rt_rate_delete_by_accomm_type($ac_accomm_type_id) {
	global $lDB;

	$list = $lDB->get("SELECT rt_rate_ix FROM rt_rate where ac_accomm_type_id = '$ac_accomm_type_id'",3);

	foreach($list as $rt_rate_id) {
		rt_rate_delete($rt_rate_id);
	}
}

function rt_rate_set_tba($rt_rate_id, $rt_rate_tba_yn) {
	global $lDB;
	
	$lDB->put("
		UPDATE 
			rt_rate
		SET 
			rt_rate_tba_yn = '".$lDB->escape($rt_rate_tba_yn)."'
		WHERE
			rt_rate.rt_rate_ix = '$rt_rate_id' 
	");
	
	return true;
}

function db_rt_rate_round_type_desc($rt_rate_round_ind) {
	switch($rt_rate_round_ind) {
	case 0:
		return "None";
	case 1:
		return "Per itinerary";
	case 2:
		return "Per person";
	default:
		return "Unknown";
	}
}

function db_rt_rate_round_dir_desc($rt_rate_round_dir) {
	switch ($rt_rate_round_dir) {
	case 0:
		return "Default";
	case 1:
		return "Up";
	case 2:
		return "Down";
	default:
		return "Unknown";
	}
}

function db_rt_rate_round_scale_desc($rt_rate_round_scale) {
	switch ($rt_rate_round_scale){
	case 0:
		return "None";
	case 1:
		return "Unit";
	case 2:
		return "Ten";
	case 3:
		return "Hundred";
	case 4:
		return "Thousand";
	default:
		return "Unknown";
	}
}

