<?php

require_once(__DIR__ . "/db.rt_rate.php");

define("DB_RT_RATE_COMPONENT_TAX_RATE",10);
define("DB_RT_RATE_COMPONENT_TAX_GROUP",20);

function db_rt_rate_component_exists($rt_rate_component_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(rt_rate_component_ix) FROM rt_rate_component WHERE rt_rate_component_ix = '$rt_rate_component_id'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function rt_rate_component_insert($rt_rate_id, $rt_component_id, $rt_comp_opt_yn, $rt_comp_opt_def_yn, $rt_comp_comm_yn, $rt_comp_freq_ind, $rt_comp_freq_factor, $rt_comp_separate_yn, $rt_tax_ind, $rt_tax_id, $rt_comp_itin_yn=false, $rt_comp_los_yn=false, $rt_comp_round_ind=false) {
	global $lDB;
	global $dbcode;

	if(!rt_rate_exists_by_id($rt_rate_id)) {
		return false;
	}

	$lDB->put("
		INSERT INTO rt_rate_component (
			rt_rate_component_db,
			rt_comp_comm_yn,
			rt_comp_freq_ind,
			rt_comp_freq_factor,
			rt_comp_itin_yn,
			rt_comp_los_yn,
			rt_comp_opt_yn,
			rt_comp_opt_def_yn,
			rt_comp_round_ind,
			rt_comp_separate_yn,
			rt_tax_ind,
			rt_tax_id,
			rt_component_id,
			rt_rate_id
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($rt_comp_comm_yn)."',
			'".$lDB->escape($rt_comp_freq_ind)."',
			'".$lDB->escape($rt_comp_freq_factor)."',
			'".$lDB->escape($rt_comp_itin_yn)."',
			'".$lDB->escape($rt_comp_los_yn)."',
			'".$lDB->escape($rt_comp_opt_yn)."',
			'".$lDB->escape($rt_comp_opt_def_yn)."',
			'".$lDB->escape($rt_comp_round_ind)."',
			'".$lDB->escape($rt_comp_separate_yn)."',
			'".$lDB->escape($rt_tax_ind)."',
			'".$lDB->escape($rt_tax_id)."',
			'".$lDB->escape($rt_component_id)."',
			'".$lDB->escape($rt_rate_id)."'
		)
	");
	
	$rt_rate_component_id = $lDB->insert_id;

	return $rt_rate_component_id;
}

function rt_rate_component_update($rt_rate_component_ix, $rt_component_id, $rt_comp_opt_yn, $rt_comp_opt_def_yn, $rt_comp_comm_yn, $rt_comp_freq_ind, $rt_comp_freq_factor, $rt_comp_separate_yn, $rt_tax_ind, $rt_tax_id){
	global $lDB;
	
	$lDB->put("
		UPDATE 
			rt_rate_component
		SET 
			rt_component_id = '".$lDB->escape($rt_component_id)."', 		
			rt_comp_opt_yn = '".$lDB->escape($rt_comp_opt_yn)."',
			rt_comp_opt_def_yn = '".$lDB->escape($rt_comp_opt_def_yn)."',
			rt_comp_comm_yn = '".$lDB->escape($rt_comp_comm_yn)."', 
			rt_comp_freq_ind = '".$lDB->escape($rt_comp_freq_ind)."', 
			rt_comp_freq_factor ='".$lDB->escape($rt_comp_freq_factor)."',
			rt_comp_separate_yn = '".$lDB->escape($rt_comp_separate_yn)."',
			rt_tax_ind = '".$lDB->escape($rt_tax_ind)."',
			rt_tax_id = '".$lDB->escape($rt_tax_id)."'
		WHERE
			rt_rate_component.rt_rate_component_ix = '$rt_rate_component_ix' 
	");
	
	// If we're making this component optional, we need to zero any percentage splits on the rate groups, as these are not allowed
	if ($rt_comp_opt_yn != 0){
		$rateCompGroups = $GLOBALS['lDB']->get("
			SELECT 
				rt_rate_comp_grp_ix,
				rt_rate_comp_amt,
				rt_rate_comp_perc
			FROM 
				rt_rate_comp_grp 
				INNER JOIN rt_rate_component ON rt_rate_component.rt_rate_component_ix = rt_rate_comp_grp.rt_rate_component_id
			WHERE
				rt_rate_component.rt_rate_component_ix = '$rt_rate_component_ix' 
		",2);
		
		foreach ($rateCompGroups as $rateCompGroup){
			rt_rate_comp_grp_update($rateCompGroup['rt_rate_comp_grp_ix'],$rateCompGroup['rt_rate_comp_amt'],0);
		}
	}
	
	return true;
}

function rt_rate_component_delete($rt_rate_component_id) {
	global $lDB;

	$lDB->put("
		DELETE FROM 
			rt_rate_component 
		WHERE 
			rt_rate_component_ix = '$rt_rate_component_id'
	");
	return true;
}

function rt_rate_component_delete_by_rate($rt_rate_id){
	global $lDB;
	
	rt_rate_comp_grp_delete_by_rate($rt_rate_id);
	rt_rate_grp_amt_delete_by_rate($rt_rate_id);

	$list = $lDB->get("
		SELECT
			rt_rate_component_ix
		FROM 
			rt_rate_component
		WHERE 
			rt_rate_component.rt_rate_id = '$rt_rate_id'
	",3);

	foreach($list as $rt_rate_component_id) {
		rt_rate_component_delete($rt_rate_component_id);
	}

	return true;	
}

