<?php

/**
 * Database functions for table rv_extra
 */

require_once(__DIR__ . '/functions.reservation.php');
require_once(__DIR__ . '/functions.financial.php');
require_once(__DIR__ . "/db.ac_extra.php");
require_once(__DIR__ . '/db.fn_folio.php');
require_once(__DIR__ . "/db.tc_res_update.php");

define("DB_RV_EXTRA_GENERAL", 0);
define("DB_RV_EXTRA_ACTIVITY", 1);
define("DB_RV_EXTRA_TRAVEL", 2);
define("DB_RV_EXTRA_ACCOMMODATION", 3);
$GLOBALS['db_rv_extra_error'] = "";

function db_rv_extra_exists($rv_extra_id) {
	$count = $GLOBALS['lDB']->get("SELECT COUNT(rv_extra_id) FROM rv_extra WHERE rv_extra_ix = '$rv_extra_id'",4);
	if($count > 0) {
		return true;
	} else {
		return false;
	}
}

function db_rv_extra_exists_by_rv_reservation_id($rv_reservation_id) {
	$count = $GLOBALS['lDB']->get("
		SELECT
			COUNT(rv_extra_id)
		FROM
			rv_extra
		WHERE
			rv_reservation_id = '$rv_reservation_id'
	",4);
	if($count > 0) {
		return true;
	} else {
		return false;
	}
}


function db_rv_extra_get_totals($rv_reservation_id,$rv_extra_charge, $rv_extra_units, $rv_extra_discount, $rv_extra_exch_rate, $rv_extra_comm_pay, $rv_extra_tax_perc, $rv_extra_nights = 1) {
	global $lDB;
	$rv_commission_deduct_yn = $lDB->get("SELECT rv_commission_deduct_yn FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'",4);
	$discount = $rv_extra_charge * $rv_extra_discount / 100;
	$gross = ($rv_extra_charge - $discount) * $rv_extra_units * $rv_extra_nights * $rv_extra_exch_rate;
	$commission = $gross * $rv_extra_comm_pay / 100;
	$nett = $gross - $commission;
	if($rv_commission_deduct_yn == 1) {
		/*$commission = -($gross * $rv_extra_comm_pay / 100);
		$nett = $gross + $commission;*/
		$total = $nett;
	} else {
		/*$commission = $gross * $rv_extra_comm_pay / 100;
		$nett = $gross - $commission;*/
		$total = $gross;
	}
	$tax = $total / ($rv_extra_tax_perc + 100) * $rv_extra_tax_perc;

	$total = round($total,2);
	$gross = round($gross,2);
	$nett = round($nett,2);
	$commission = round($commission,2);
	$tax = round($tax,6);

	return array('total'=>$total, 'gross'=>$gross, 'nett'=>$nett, 'commission'=>$commission, 'tax'=>$tax);
}

function db_rv_extra_update_totals($rv_extra_id,$dbUpgrade=false,$rf_currency_id="") {
	global $lDB;

	$oldFlagChngs = $GLOBALS['flagChngs'];
	$GLOBALS['flagChngs'] = "0";
	
	$extraInfo = $lDB->get("
		SELECT
			rv_reservation_id,
			rv_extra_ind,
			rv_extra_nights,
			rv_extra_charge,
			rv_extra_units,
			rv_extra_discount,
			rv_extra_exch_rate,
			rv_extra_comm_pay,
			rv_extra_tax_perc
		FROM
			rv_extra
		WHERE
			rv_extra_ix = '$rv_extra_id'
	",1);

	if($extraInfo['rv_extra_ind'] != 3) {
		$extraInfo['rv_extra_nights'] = 1;
	} 

	$totals =  db_rv_extra_get_totals($extraInfo['rv_reservation_id'],$extraInfo['rv_extra_charge'], $extraInfo['rv_extra_units'], $extraInfo['rv_extra_discount'], $extraInfo['rv_extra_exch_rate'], $extraInfo['rv_extra_comm_pay'], $extraInfo['rv_extra_tax_perc'], $extraInfo['rv_extra_nights']);

	$dbUpgradeSql = "";
	if ($dbUpgrade) {
		$dbUpgradeSql = " rv_extra.rv_extra_db = rv_extra.rv_extra_db, rv_extra_inv_curr_id = '".$rf_currency_id."', ";
	}

	$wasMaster = false;
	if ($GLOBALS['lDB']->isMaster == "0"){
		$GLOBALS['lDB']->isMaster = "1";
		$wasMaster = true;
	}
	$lDB->put("
		UPDATE
			rv_extra
		SET ".$dbUpgradeSql."
			rv_extra_amt_payable = '".$lDB->escape(db_round($totals['total'],2))."',
			rv_extra_amt_gross = '".$lDB->escape(db_round($totals['gross'],2))."',
			rv_extra_amt_nett = '".$lDB->escape(db_round($totals['nett'],2))."',
			rv_extra_amt_comm = '".$lDB->escape(db_round($totals['commission'],2))."',
			rv_extra_amt_tax = '".$lDB->escape(db_round($totals['tax'],6))."'
		WHERE
			rv_extra_ix = '$rv_extra_id'
	");
	if($wasMaster) {
		$GLOBALS['lDB']->isMaster = "0";
	}
	db_tc_res_update_insert($extraInfo['rv_reservation_id']);
	$GLOBALS['flagChngs'] = $oldFlagChngs;   
}

function db_rv_extra_insert($rv_reservation_id, $ac_extra_id, $pr_business_id, $rv_extra_units, $rv_extra_date_serv,
	$rv_extra_charge, $rv_extra_discount, $rv_extra_tax_perc, $rv_extra_comm_rec, $rv_extra_comm_pay,
	$rv_extra_note, $rv_extra_note_internal, $rv_res_item_group_id, $rf_currency_id, $rv_extra_inv_curr_id, 
	$rv_extra_exch_rate, $rv_extra_exch_expiry, $pr_business_inv_id, $rv_extra_travel_eta='', $rv_extra_travel_etd='', $rv_extra_adult_count=0, $rv_extra_child_count=0, $rv_extra_date_depart='', $rv_extra_ref='', $rv_extra_supplier_conf_yn='0', $pr_supplier_id='0', $ac_pos_id=false, $rv_phone_id=false, $isUpdate=false) {

	// unused...
	/*
		$rv_extra_exch_expiry
		$rv_extra_exch_rate
		$rv_extra_ind
		$fn_folio_id // SET AFTER INSERT
		$rf_currency_id
		$rv_extra_user_id // last user who updated the record
		// going $rv_invoice_id
		$fn_invoice_item_id
		$rv_extra_timestamp // audit
	*/

	global $dbcode;
	global $lDB;
	
	if (!db_ac_extra_exists($ac_extra_id)) {
		return false;
	}

	if($rf_currency_id == $rv_extra_inv_curr_id) {
		$rv_extra_exch_rate = 1;
		$rv_extra_exch_expiry = "0000-00-00";
	}

	$rf_tax_id = $lDB->get("SELECT rf_tax_id FROM ac_extra WHERE ac_extra_ix = '$ac_extra_id'",4);
	
	$rv_extra_ind = $lDB->get("
		SELECT
			ac_extra_category.ac_extra_cat_ind
		FROM
			ac_extra
			INNER JOIN ac_extra_category ON ac_extra_category.ac_extra_category_ix = ac_extra.ac_extra_category_id
		WHERE
			ac_extra.ac_extra_ix = '$ac_extra_id'
	",4);

	if($rv_extra_ind == 3) {
		$rv_extra_nights = (strtotime($rv_extra_date_depart) - strtotime($rv_extra_date_serv))/86400;
		$totals =  db_rv_extra_get_totals($rv_reservation_id,$rv_extra_charge, $rv_extra_units, $rv_extra_discount, $rv_extra_exch_rate, $rv_extra_comm_pay, $rv_extra_tax_perc, $rv_extra_nights);
				
	} else {
		$rv_extra_nights = 0;
		$totals =  db_rv_extra_get_totals($rv_reservation_id,$rv_extra_charge, $rv_extra_units, $rv_extra_discount, $rv_extra_exch_rate, $rv_extra_comm_pay, $rv_extra_tax_perc);
	}

	if($ac_pos_id === false) {
		$ac_pos_field = "";
		$ac_pos_value = "";
	} else {
		$ac_pos_field = "ac_pos_id,";
		$ac_pos_value = "'$ac_pos_id',";
	}
	if($rv_phone_id === false) {
		$rv_phone_field = "";
		$rv_phone_value = "";
	} else {
		$rv_phone_field = "rv_phone_id,";
		$rv_phone_value = "'$rv_phone_id',";
	}
	$tmpMasterStatus = $lDB->isMaster;
	$lDB->isMaster = "1";

	$ad_create_date = date("Y-m-d H:i:s"); 
	$ad_create_date_tz = $ad_modify_date_tz = date("e");

	$lDB->put("
		INSERT INTO rv_extra (
			rv_extra_db,
			rv_extra_id,
			rv_reservation_id,
			ac_extra_id,
			pr_business_id,
			rv_extra_units,
			rv_extra_travel_eta,
			rv_extra_travel_etd,
			rv_extra_adult_count,
			rv_extra_child_count,
			rv_extra_nights,
			rv_extra_date_depart,
			rv_extra_supplier_conf_yn,
			rv_extra_ref,
			pr_supplier_id,
			rv_extra_date_serv,
			rv_extra_charge,
			rv_extra_discount,
			rv_extra_tax_perc,
			rf_tax_id,
			rv_extra_comm_rec,
			rv_extra_comm_pay,
			rv_extra_note,
			rv_extra_note_internal,
			rv_res_item_group_id,
			rf_currency_id,
			rv_extra_inv_curr_id,
			rv_extra_exch_rate,
			rv_extra_exch_expiry,
			rv_extra_amt_payable,
			rv_extra_amt_gross,
			rv_extra_amt_nett,
			rv_extra_amt_comm,
			rv_extra_amt_tax,
			rv_extra_ind,
			$ac_pos_field
			$rv_phone_field
			pr_business_inv_id,
			ad_create_user_id,
			ad_create_date,
			ad_create_date_tz,
			ad_modify_user_id,
			ad_modify_date,
			ad_modify_date_tz
		) VALUES (
			'".$lDB->escape($dbcode)."',	
			'',
			'".$lDB->escape($rv_reservation_id)."',
			'".$lDB->escape($ac_extra_id)."',
			'".$lDB->escape($pr_business_id)."',
			'".$lDB->escape($rv_extra_units)."',
			'".$lDB->escape($rv_extra_travel_eta)."',
			'".$lDB->escape($rv_extra_travel_etd)."',
			'".$lDB->escape($rv_extra_adult_count)."',
			'".$lDB->escape($rv_extra_child_count)."',
			'".$lDB->escape($rv_extra_nights)."',
			'".$lDB->escape($rv_extra_date_depart)."',
			'".$lDB->escape($rv_extra_supplier_conf_yn)."',
			'".$lDB->escape($rv_extra_ref)."',
			'".$lDB->escape($pr_supplier_id)."',
			'".$lDB->escape($rv_extra_date_serv)."',
			'".$lDB->escape($rv_extra_charge)."',
			'".$lDB->escape($rv_extra_discount)."',
			'".$lDB->escape($rv_extra_tax_perc)."',
			'".$lDB->escape($rf_tax_id)."',
			'".$lDB->escape($rv_extra_comm_rec)."',
			'".$lDB->escape($rv_extra_comm_pay)."',
			'".$lDB->escape($rv_extra_note)."',
			'".$lDB->escape($rv_extra_note_internal)."',
			'".$lDB->escape($rv_res_item_group_id)."',
			'".$lDB->escape($rf_currency_id)."',
			'".$lDB->escape($rv_extra_inv_curr_id)."',
			'".$lDB->escape($rv_extra_exch_rate)."',
			'".$lDB->escape($rv_extra_exch_expiry)."',
			'".$lDB->escape($totals['total'])."',
			'".$lDB->escape($totals['gross'])."',
			'".$lDB->escape($totals['nett'])."',
			'".$lDB->escape($totals['commission'])."',
			'".$lDB->escape($totals['tax'])."',
			'".$lDB->escape($rv_extra_ind)."',
			$ac_pos_value
			$rv_phone_value
			'".$lDB->escape($pr_business_inv_id)."',
			'".$lDB->escape($GLOBALS['userid'])."',
			'".$lDB->escape($ad_create_date)."',
			'".$lDB->escape($ad_create_date_tz)."',
			'',
			'0000-00-00 00:00:00',
			'".$lDB->escape($ad_modify_date_tz)."'
		)
	");

	$extraId = $GLOBALS['lDB']->insert_id;
	$lDB->isMaster = $tmpMasterStatus;
	
	if(!$isUpdate) {
		$resStatus = $GLOBALS['lDB']->get("
			SELECT rf_reservation_status_id FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'
		",4);
		if($resStatus != "25") {
			ammendReservation($rv_reservation_id,"Extras (Add)");
		}
		recalcTotals($rv_reservation_id,3);
	}

	db_rv_extra_debug($extraId,"db_rv_extra_insert()");
	return $extraId;
}

function db_rv_extra_delete($rv_extra_id,$rv_extra_void_reason=false) {
	global $lDB;
	global $db_rv_extra_error;

	if(db_rv_extra_exists($rv_extra_id)) {
		$folioId = $lDB->get("SELECT fn_folio_id FROM rv_extra WHERE rv_extra_ix = '$rv_extra_id'",4);
		$resId = $lDB->get("SELECT rv_reservation_id FROM rv_extra WHERE rv_extra_ix = '$rv_extra_id'",4);
		$statusId = $lDB->get("SELECT rf_reservation_status_id FROM rv_reservation WHERE rv_reservation_ix = '$resId'",4);
		$wasMaster = false;
		if ($GLOBALS['lDB']->isMaster == "0") {
			$GLOBALS['lDB']->isMaster = "1";
			$wasMaster = true;
		}
		$folioPaid = $lDB->get("
			SELECT
				SUM(rv_payment_item.rv_payment_item_amt) as fn_folio_amt_paid
			FROM
				fn_folio
				INNER JOIN rv_payment_item ON rv_payment_item.fn_folio_id = fn_folio.fn_folio_ix
			WHERE
				fn_folio.fn_folio_ix = '$folioId'
			GROUP BY
				rv_payment_item.fn_folio_id
		",4);
		$folioExtraCount = $lDB->get("SELECT COUNT(*) FROM rv_extra WHERE fn_folio_id = '$folioId'",4);
		$folioAccommCount = $lDB->get("SELECT COUNT(*) FROM rv_reservation_item WHERE fn_folio_id = '$folioId'",4);
		$folioCount = $folioExtraCount + $folioAccommCount;
		if($folioCount <= 1 && $folioPaid != 0) {
			if($wasMaster) {
				$GLOBALS['lDB']->isMaster = "0";
			}
			$db_rv_extra_error = "These extras are linked to folios with payments, remove the linked payments before deleting the extra.";
			return false;
		}

		// Replace with void code.
		if($statusId == "25") {
			$lDB->put("DELETE FROM rv_extra WHERE rv_extra_ix = '$rv_extra_id'");
		} else {
			if($rv_extra_void_reason !== false) {
				$reasonSQL = "rv_extra_void_reason = '$rv_extra_void_reason',";
			} else {
				$reasonSQL = "";
			}
			$lDB->put("
				UPDATE rv_extra SET
					rv_extra_void_ind = 3,
					rv_extra_void_user_id = '".$lDB->escape($GLOBALS['userid'])."',
					rv_extra_void_time = '".date("Y-m-d H:i:s")."',
					rv_extra_void_time_tz = '".date("e")."',
					ad_modify_user_id = '".$lDB->escape($GLOBALS['userid'])."',
					ad_modify_date = '".date("Y-m-d H:i:s")."',
					ad_modify_date_tz = '".date("e")."',
					$reasonSQL
					fn_folio_id = NULL
				WHERE
					rv_extra_ix = '$rv_extra_id'			
			");
		}
		
		db_fn_folio_delete_by_id($folioId);
		if($statusId != "25") {
			ammendReservation($resId,"Extras (Delete)");
		}
		recalcTotals($resId,3);
		if($wasMaster) {
			$GLOBALS['lDB']->isMaster = "0";
		}
		return true;
	} else {
		return false;
	}
}

function db_rv_extra_delete_by_rv_reservation_id($rv_reservation_id) {
	global $lDB;
	if(db_rv_extra_exists_by_rv_reservation_id($rv_reservation_id)) {
		$list = $lDB->get("
			SELECT
				rv_extra_ix
			FROM
				rv_extra
			WHERE
				rv_reservation_id = '$rv_reservation_id'
		",3);
		foreach($list as $item) {
			db_rv_extra_delete($item);
		}
		return true;
	} else {
		return false;
	}
}

function db_rv_extra_update($rv_extra_id, $rv_extra_units, $rv_extra_date_serv, $rv_extra_charge,
	$rv_extra_discount, $rv_extra_tax_perc, $rv_extra_comm_rec, $rv_extra_comm_pay,
	$rv_extra_note, $rv_extra_note_internal, $rv_res_item_group_id, $rf_currency_id, $rv_extra_inv_curr_id,
	$rv_extra_exch_rate, $rv_extra_exch_expiry, $pr_business_inv_id, $rv_extra_void_reason=false, $rv_extra_travel_eta='', $rv_extra_travel_etd='', $rv_extra_adult_count=0, $rv_extra_child_count=0, $rv_extra_date_depart='', $rv_extra_ref='', $rv_extra_supplier_conf_yn='0', $pr_supplier_id='0') {

	$rv_extra_supplier_conf_yn = intval($rv_extra_supplier_conf_yn);

	// unused...
	/*
		$rv_extra_exch_expiry
		$rv_extra_exch_rate
		$rv_extra_owner_db dbcode
		$rv_extra_ind
		$fn_folio_id
		$rf_currency_id
		$rv_extra_user_id // last user who updated the record
		// going $rv_invoice_id
		$fn_invoice_item_id
		$rv_extra_timestamp // audit
	*/

	global $dbcode;
	global $lDB;
	
	// Get reservation status
	$resStatus = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation.rv_reservation_ix,
			rf_reservation_status_id
		FROM
			rv_extra
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_extra.rv_reservation_id
		WHERE
			rv_extra.rv_extra_ix = '$rv_extra_id'
	",1);
	

	// Get original extra data
	$originalExtra = $lDB->get("
		SELECT
			rv_extra_db,
			rv_extra_id,
			rv_reservation_id,
			ac_extra_id,
			pr_business_id,
			rv_extra_units,
			rv_extra_date_serv,
			rv_extra_charge,
			rv_extra_discount,
			rv_extra_tax_perc,
			rv_extra_tax_ind,
			rf_tax_id,
			rv_extra_comm_rec,
			rv_extra_comm_pay,
			rv_extra_note,
			rv_extra_note_internal,
			rv_res_item_group_id,
			rf_currency_id,
			rv_extra_inv_curr_id,
			rv_extra_exch_rate,
			rv_extra_exch_expiry,
			rv_extra_amt_payable,
			rv_extra_amt_gross,
			rv_extra_amt_nett,
			rv_extra_amt_comm,
			rv_extra_amt_tax,
			rv_extra_ind,
			ac_pos_id,
			rv_phone_id,
			pr_business_inv_id
		FROM
			rv_extra
		WHERE
			rv_extra_ix = '$rv_extra_id'
	",1);

	if($rf_currency_id == $rv_extra_inv_curr_id) {
		$rv_extra_exch_rate = 1;
		$rv_extra_exch_expiry = "0000-00-00";
	}

	if($originalExtra['rv_extra_ind'] == 3) {
		$rv_extra_nights = (strtotime($rv_extra_date_depart) - strtotime($rv_extra_date_serv))/86400;
	} else {
		$rv_extra_nights = 0;
	}

	$ad_modify_date = date("Y-m-d H:i:s"); 
	$ad_modify_date_tz = date("e");
	$lDB->put("
		UPDATE rv_extra SET
			rv_extra_units = '".$lDB->escape($rv_extra_units)."',
			rv_extra_travel_eta = '".$lDB->escape($rv_extra_travel_eta)."',
			rv_extra_travel_etd = '".$lDB->escape($rv_extra_travel_etd)."',
			rv_extra_supplier_conf_yn = '".$lDB->escape($rv_extra_supplier_conf_yn)."',
			rv_extra_ref='".$lDB->escape($rv_extra_ref)."',
			pr_supplier_id='".$lDB->escape($pr_supplier_id)."',
			rv_extra_date_serv = '".$lDB->escape($rv_extra_date_serv)."',
			rv_extra_adult_count = '".$lDB->escape($rv_extra_adult_count)."',
			rv_extra_child_count = '".$lDB->escape($rv_extra_child_count)."',
			rv_extra_nights = '".$lDB->escape($rv_extra_nights)."',
			rv_extra_date_depart = '".$lDB->escape($rv_extra_date_depart)."',
			rv_extra_charge = '".$lDB->escape($rv_extra_charge)."',
			rv_extra_discount = '".$lDB->escape($rv_extra_discount)."',
			rv_extra_tax_perc = '".$lDB->escape($rv_extra_tax_perc)."',
			rv_extra_comm_rec = '".$lDB->escape($rv_extra_comm_rec)."',
			rv_extra_comm_pay = '".$lDB->escape($rv_extra_comm_pay)."',
			rv_extra_note = '".$lDB->escape($rv_extra_note)."',
			rv_extra_note_internal = '".$lDB->escape($rv_extra_note_internal)."',
			rv_res_item_group_id = '".$lDB->escape($rv_res_item_group_id)."',
			rf_currency_id = '".$lDB->escape($rf_currency_id)."',
			rv_extra_inv_curr_id = '".$lDB->escape($rv_extra_inv_curr_id)."',
			rv_extra_exch_rate = '".$lDB->escape($rv_extra_exch_rate)."',
			rv_extra_exch_expiry = '".$lDB->escape($rv_extra_exch_expiry)."',
			pr_business_inv_id = '".$lDB->escape($pr_business_inv_id)."',
			ad_modify_user_id = '".$lDB->escape($GLOBALS['userid'])."',
			ad_modify_date = '".$lDB->escape($ad_modify_date)."',
			ad_modify_date_tz = '".$lDB->escape($ad_modify_date_tz)."'
		WHERE
			rv_extra_ix = '$rv_extra_id'
	");
	db_rv_extra_update_totals($rv_extra_id);


	if($resStatus['rf_reservation_status_id'] != "25" && (
		$rv_extra_charge != $originalExtra['rv_extra_charge'] ||
		$rv_extra_comm_pay != $originalExtra['rv_extra_comm_pay'] ||
		$rv_extra_comm_rec != $originalExtra['rv_extra_comm_rec'] ||
		$rv_extra_units != $originalExtra['rv_extra_units'] ||
		$rv_extra_exch_rate != $originalExtra['rv_extra_exch_rate'] ||
   		$rv_extra_discount != $originalExtra['rv_extra_discount'])) {
			// Ignore passed percentage, look up percentage from Tax Code Table
			$taxPerc = taxPercentage($originalExtra['rf_tax_id'], $originalExtra['rv_extra_tax_ind']);

			$auditExtraId = db_rv_extra_insert($originalExtra['rv_reservation_id'], $originalExtra['ac_extra_id'], $originalExtra['pr_business_id'], 
				$originalExtra['rv_extra_units'], $originalExtra['rv_extra_date_serv'],	$originalExtra['rv_extra_charge'], $originalExtra['rv_extra_discount'],
				$taxPerc, $originalExtra['rv_extra_comm_rec'], $originalExtra['rv_extra_comm_pay'], addslashes($originalExtra['rv_extra_note']), 
				addslashes($originalExtra['rv_extra_note_internal']),$originalExtra['rv_res_item_group_id'], $originalExtra['rf_currency_id'],
				$originalExtra['rv_extra_inv_curr_id'], $originalExtra['rv_extra_exch_rate'], $originalExtra['rv_extra_exch_expiry'],
				$originalExtra['pr_business_inv_id'], $originalExtra['ac_pos_id'], $originalExtra['rv_phone_id'], true);
			db_rv_extra_tax_insert($auditExtraId, $originalExtra['rv_extra_tax_ind'], $originalExtra['rf_tax_id']);
			db_rv_extra_update_totals($auditExtraId);
			verify_extra($auditExtraId);
			
			$auditPayable = $lDB->get("SELECT rv_extra_amt_payable FROM rv_extra WHERE rv_extra_ix = '$auditExtraId'",4);
			$extraPayable = $lDB->get("SELECT rv_extra_amt_payable FROM rv_extra WHERE rv_extra_ix = '$rv_extra_id'",4);
			if($extraPayable > $auditPayable) {
				$auditIndex = 1;
			} else {
				$auditIndex = 2;
			}
			$maxSequence = $lDB->get("SELECT MAX(rv_extra_void_seq) FROM rv_extra WHERE rv_extra_void_link_id = '$rv_extra_id'",4) + 1;
			if($rv_extra_void_reason !== false) {
				$reasonSQL = "rv_extra_void_reason = '".$lDB->escape($rv_extra_void_reason)."',";
			} else {
				$reasonSQL = "";
			}

			$lDB->put("
				UPDATE rv_extra SET
					rv_extra_void_ind = '".$lDB->escape($auditIndex)."',
					rv_extra_void_user_id = '".$lDB->escape($GLOBALS['userid'])."',
					rv_extra_void_time = '".date("Y-m-d H:i:s")."',
					rv_extra_void_time_tz = '".date("e")."',
					rv_extra_void_link_id = '".$lDB->escape($rv_extra_id)."',
					rv_extra_void_seq = '".$lDB->escape($maxSequence)."',
					$reasonSQL
					fn_folio_id = NULL
				WHERE
					rv_extra_ix = '$auditExtraId'			
			");
			$maxSequence++;			
			$lDB->put("UPDATE rv_extra SET rv_extra_void_seq = '".$lDB->escape($maxSequence)."' WHERE rv_extra_ix = '$rv_extra_id'");
	}

	if($resStatus['rf_reservation_status_id'] != "25") {
		ammendReservation($resStatus['rv_reservation_ix'],"Extras (Update)");
	}
	recalcTotals($resStatus['rv_reservation_ix'],3);
	db_rv_extra_debug($rv_extra_id,"db_rv_extra_update()");

	//return $GLOBALS['lDB']->insert_id;
	return true;
}

function db_rv_extra_set_folio($rv_extra_id, $fn_folio_id, $deleteFolio=true, $overrideCrossInvoice=false) {
	global $lDB;

	// Check if cross invoicing is happening and that user can cross invoice
	$sc_grp_cross_invoice_yn = $GLOBALS['lDB']->get("
		SELECT
			sc_group.sc_grp_cross_invoice_yn
		FROM
			sc_user
			INNER JOIN sc_group ON sc_group.sc_group_id = sc_user.sc_group_id
		WHERE
			sc_user.pr_user_id = '$GLOBALS[userid]'
	",4);
	if($overrideCrossInvoice) {
		$sc_grp_cross_invoice_yn = "1";
	}
	$propertyId = $lDB->get("SELECT pr_business_id FROM rv_extra WHERE rv_extra_ix = '$rv_extra_id'",4);
	$businessId = "";
	$currId = $propertyId;
	while($businessId == "" && $currId != "0" && trim($currId) != "") {
		if(!$GLOBALS['isPropServer']) {
			$billingYN = $GLOBALS['lDB']->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
		} else {
			$billingYN = $GLOBALS['lDB']->get("SELECT pr_bus_billing_prop_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
		}
		if($billingYN == "1") {
			$businessId = $currId;
		} else {
			$currId = $GLOBALS['lDB']->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
		}
	}
	$extraBillingEntityId = $businessId;
	$folioBillingEntityId = $GLOBALS['lDB']->get("SELECT fn_folio.pr_business_id FROM fn_folio WHERE fn_folio.fn_folio_ix = '$fn_folio_id'",4);
	$oldFolio = trim($lDB->get("
		SELECT
			fn_folio_id
		FROM
			rv_extra
		WHERE
			rv_extra_ix = '$rv_extra_id'
	",4));

	if (
		($sc_grp_cross_invoice_yn != "1" && ($extraBillingEntityId == $folioBillingEntityId)) // No cross-inv, prop spec extra
		|| ($sc_grp_cross_invoice_yn != "1" && ($extraBillingEntityId == "")) // No cross-inv, non-prop spec extra
		|| $sc_grp_cross_invoice_yn == "1" // Cross-invoicing is allowed
		) {
		$wasMaster = false;
		if ($GLOBALS['lDB']->isMaster == "0"){
			$GLOBALS['lDB']->isMaster = "1";
			$wasMaster = true;
		}
		$lDB->put("
			UPDATE
				rv_extra
			SET
				fn_folio_id = '".$lDB->escape($fn_folio_id)."'
			WHERE
				rv_extra_ix = '$rv_extra_id'
		");
		if($wasMaster) {
			$GLOBALS['lDB']->isMaster = "0";
		}

		if($deleteFolio && $oldFolio != "" && $oldFolio != "0") {
			db_fn_folio_update_totals($oldFolio);
			db_fn_folio_delete_by_id($oldFolio);
		}
		db_fn_folio_update_totals($fn_folio_id);
		db_rv_extra_debug($rv_extra_id,"db_rv_extra_set_folio('$rv_extra_id','$fn_folio_id',".($deleteFolio?"true":"false").")");
	} else {
		db_rv_extra_debug($rv_extra_id,"Extra not linked to folio because user does not have cross invoicing privilages.");
	}
}

function db_rv_extra_set_invoice($rv_extra_id, $fn_invoice_item_id) {
	global $lDB;

	$lDB->put("UPDATE rv_extra SET fn_invoice_item_id = '".$lDB->escape($fn_invoice_item_id)."' WHERE rv_extra_ix = '$rv_extra_id'");
}

function db_rv_extra_debug($rv_extra_id, $rv_extra_debug) {
	global $lDB;

	$job = isset($_SERVER['argv'][0])?$_SERVER['argv'][0]:"api";
	$rv_extra_debug = addslashes(date("Y-m-d H:i:s") . " " . $GLOBALS['dbcode'] . " " . $GLOBALS['userid'] . " " . $job . ": " . $rv_extra_debug . "\n");
	$lDB->put("UPDATE rv_extra SET rv_extra_debug = CONCAT('".$lDB->escape($rv_extra_debug)."',rv_extra_debug) WHERE rv_extra_ix = '$rv_extra_id'");
}

function db_rv_extra_tax_insert($rv_extra_id, $rf_tax_ind, $rf_tax_rate) {
	global $lDB;

	// Clear existing extra tax records
	$rv_extra_tax_ids = $lDB->get("
		SELECT
			rv_extra_tax.rv_extra_tax_ix
		FROM
			rv_extra_tax
		WHERE
			rv_extra_tax.rv_extra_id = '".$rv_extra_id."'
	",2);

	foreach ($rv_extra_tax_ids as $rv_extra_tax) {
		$lDB->put("DELETE FROM rv_extra_tax WHERE rv_extra_tax_ix = '".$rv_extra_tax['rv_extra_tax_ix']."'");
	}

	// Build and insert new extra tax records
	$rv_extra_amt_tax = $GLOBALS['lDB']->get("
		SELECT
			rv_extra.rv_extra_amt_tax
		FROM
			rv_extra
		WHERE
			rv_extra.rv_extra_ix = '".$rv_extra_id."'
	",4);

	switch($rf_tax_ind) {
		case 10:
			// Tax rate
			$tax_rate = $GLOBALS['lDB']->get("
				SELECT
					rf_tax_rate.rf_tax_rate_ix,
					rf_tax_rate.rf_tax_rate_perc
				FROM
					rf_tax_rate
				WHERE
					rf_tax_rate.rf_tax_rate_inactive_yn = 0
					AND rf_tax_rate.rf_tax_rate_ix = '".$rf_tax_rate."'
			",1);

			db_rv_extra_tax_insert_record($rv_extra_id, $rf_tax_rate, $tax_rate['rf_tax_rate_perc'], $rv_extra_amt_tax);
			
			$lDB->put("
				UPDATE
					rv_extra
				SET
					rv_extra_tax_ind = '10',
					rf_tax_id = '".$rf_tax_rate."'
				WHERE
					rv_extra_ix = '$rv_extra_id'
			");

			break;
		case 20:
			// Tax group
			$taxes = $GLOBALS['lDB']->get("
				SELECT
					rt_tax_group.rt_tax_group_ix,
					rt_tax_group_item.rt_tax_group_item_ix,
					rf_tax_rate.rf_tax_rate_ix,
					rf_tax_rate.rf_tax_rate_perc
				FROM
					rt_tax_group
					LEFT JOIN rt_tax_group_item ON rt_tax_group_item.rt_tax_group_id = rt_tax_group.rt_tax_group_ix
					LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rt_tax_group_item.rf_tax_rate_id
				WHERE
					rf_tax_rate.rf_tax_rate_inactive_yn = 0
					AND rt_tax_group.rt_tax_group_ix = '".$rf_tax_rate."'
			",2);

			$total_tax_rate_perc = 0;
			foreach ($taxes as $tax_group) {
				$total_tax_rate_perc =  $total_tax_rate_perc + $tax_group['rf_tax_rate_perc'];
			}

			foreach ($taxes as $tax_group) {
				$rv_extra_tax_amt = ($rv_extra_amt_tax/$total_tax_rate_perc) * $tax_group['rf_tax_rate_perc'];
				db_rv_extra_tax_insert_record($rv_extra_id, $tax_group['rf_tax_rate_ix'], $tax_group['rf_tax_rate_perc'], $rv_extra_tax_amt);
			}
			$lDB->put("
				UPDATE
					rv_extra
				SET
					rv_extra_tax_ind = '20',
					rf_tax_id = '".$rf_tax_rate."'
				WHERE
					rv_extra_ix = '$rv_extra_id'
			");

			break;
	}
}

function db_rv_extra_tax_insert_record($rv_extra_id, $rf_tax_rate_id, $rv_extra_tax_perc, $rv_extra_tax_amt) {
	global $dbcode;
	global $lDB;

	$ad_create_date = date("Y-m-d H:i:s"); 
	$ad_create_date_tz = $ad_modify_date_tz = date("e");

	$lDB->put("
		INSERT INTO rv_extra_tax (
			rv_extra_tax_db,
			rv_extra_tax_id,
			rv_extra_id,
			rf_tax_rate_id,
			rv_extra_tax_perc,
			rv_extra_tax_amt,
			ad_create_user_id,
			ad_create_date,
			ad_create_date_tz,
			ad_modify_user_id,
			ad_modify_date,
			ad_modify_date_tz
		) VALUES (
			'".$lDB->escape($dbcode)."',	
			'',
			'".$lDB->escape($rv_extra_id)."',
			'".$lDB->escape($rf_tax_rate_id)."',
			'".$lDB->escape($rv_extra_tax_perc)."',
			'".$lDB->escape($rv_extra_tax_amt)."',
			'".$lDB->escape($GLOBALS['userid'])."',
			'".$lDB->escape($ad_create_date)."',
			'".$lDB->escape($ad_create_date_tz)."',
			'',
			'0000-00-00 00:00:00',
			'".$lDB->escape($ad_modify_date_tz)."'
		)
	");
}

function verify_extra($rv_extra_id) {
	global $lDB;

	if (empty($rv_extra_id)) {
		errorHandler(1, "special:There has been an error saving this extra. Please verify that the extra has been created successfully");
		error_log("extra_issue: extra ID is empty");
		return false;
	}

	$extra = $lDB->get("
		SELECT
			rf_tax_id,
			rv_extra_tax_ind,
			rv_extra_tax_perc,
			rf_currency_id
		FROM
			rv_extra
		WHERE
			rv_extra_ix = '" . $rv_extra_id . "'
	", 1);

	if ($extra['rf_currency_id'] == '') {
		// No-Charge extra, no need to verify tax
		return true;
	}

	if (empty($extra) || $extra['rf_tax_id'] == '' || $extra['rv_extra_tax_ind'] == '') {
		errorHandler(1, "special:There has been an error saving this extra. Please verify that the extra has been created successfully");
		error_log("extra_issue: tax ID or tax ind is empty. rv_extra_ix: '" . $rv_extra_id . "', tax id: '" . $extra['rf_tax_id'] . "', tax ind: '" . $extra['rv_extra_tax_ind'] . "'");
		return false;
	}

	$taxPerc = taxPercentage($extra['rf_tax_id'], $extra['rv_extra_tax_ind']);

	if (empty($taxPerc) || $taxPerc != $extra['rv_extra_tax_perc']) {
		errorHandler(1, "special:There has been an error saving this extra. Please verify that the extra has been created successfully");
		error_log("extra_issue: tax percentage on extra doesn't match tax percentage on tax rate or group. rv_extra_ix: '" . $rv_extra_id . "', extra tax perc: '" . $taxPerc . "', rate/group tax perc: '" . $extra['rv_extra_tax_perc'] . "', tax id: '" . $extra['rf_tax_id'] . "', tax ind: '" . $extra['rv_extra_tax_ind'] . "'");
		return false;
	}

	return true;
}

function taxPercentage($taxId, $taxInd) {
	global $lDB;

	if ($taxInd == '10') {
		$taxPerc = $lDB->get("
			SELECT
				rf_tax_rate_perc
			FROM
				rf_tax_rate
			WHERE
				rf_tax_rate_ix = '" . $taxId . "'
		", 4);
	} else if ($taxInd == '20') {
		$taxPerc = $lDB->get("
			SELECT
				SUM(rf_tax_rate_perc)
			FROM
				rt_tax_group_item
				LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rt_tax_group_item.rf_tax_rate_id
			WHERE
				rt_tax_group_item.rt_tax_group_id = '" . $taxId . "'
		", 4);
	}

	return $taxPerc;
}
