<?php

require_once(__DIR__ . "/db.rv_reservation.php");

function db_rv_note_exists($rv_note_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(rv_note_ix) FROM rv_note WHERE rv_note_ix = '$rv_note_id'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_rv_note_exists_by_reservation($rv_reservation_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(rv_note_ix) FROM rv_note WHERE rv_reservation_id = '$rv_reservation_id'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_rv_note_insert($rv_reservation_id,$rf_country_id=false,$rv_note_conf=false,$rv_note_general=false,$rv_note_guests=false,$rv_note_internal=false) {
	global $lDB;
	global $dbcode;

	if(!db_rv_reservation_exists($rv_reservation_id)) {
		return false;
	}

	$reservation = $lDB->get("
		SELECT
			rf_country_id,
			rv_note_conf,
			rv_note_general,
			rv_note_guests,
			rv_note_internal
		FROM
			rv_reservation
		WHERE
			rv_reservation.rv_reservation_ix = '$rv_reservation_id'
	",1);

	if($rf_country_id === false) {
		$rf_country_id = $reservation['rf_country_id'];
	}

	if(!db_rf_country_exists($rf_country_id)) {
		$rf_country_id = "";
	}
			
	if($rv_note_conf === false) {
		$rv_note_conf = $reservation['rv_note_conf'];
	}

	if($rv_note_general === false) {
		$rv_note_general = $reservation['rv_note_general'];
	}

	if($rv_note_guests === false) {
		$rv_note_guests = $reservation['rv_note_guests'];
	}

	if($rv_note_internal === false) {
		$rv_note_internal = $reservation['rv_note_internal'];
	}

	$ad_create_date = date("Y-m-d H:i:s");
	$ad_create_date_tz = date("e");

	$lDB->put("
		INSERT INTO rv_note (
			rv_note_db,
			rv_reservation_id,
			rf_country_id,
			rv_note_conf,
			rv_note_general,
			rv_note_guests,
			rv_note_internal,
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($rv_reservation_id)."',
			'".$lDB->escape($rf_country_id)."',
			'".$lDB->escape($rv_note_conf)."',
			'".$lDB->escape($rv_note_general)."',
			'".$lDB->escape($rv_note_guests)."',
			'".$lDB->escape($rv_note_internal)."',
			'".$lDB->escape($ad_create_date)."',
			'".$lDB->escape($ad_create_date_tz)."',
			'".$lDB->escape($GLOBALS['userid'])."'
		)
	");

	$rv_note_id = $lDB->insert_id;

	db_rv_reservation_update_notes($rv_reservation_id);

	return $rv_note_id;
}

function db_rv_note_get_by_reservation($rv_reservation_id) {
	global $lDB;

	if(!db_rv_note_exists_by_reservation($rv_reservation_id)) {
		return false;
	}

	return $lDB->get("
		SELECT
			rv_note_ix,
			rf_country_id,
			rv_note_conf,
			rv_note_general,
			rv_note_guests,
			rv_note_internal
		FROM
			rv_note
		WHERE
			rv_reservation_id = '$rv_reservation_id'
		ORDER BY
			ad_create_date DESC
	",1);		
}
