<?php

require_once(__DIR__ . "/db.rv_payment_item.php");
require_once(__DIR__ . "/db.fn_tran.php");

function db_rv_payment_exists($rv_payment_id) {
	$count = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM rv_payment WHERE rv_payment_ix = '$rv_payment_id'",4);
	if($count > 0) {
		return true;
	} else {
		return false;
	}
}

function db_rv_payment_insert($pr_persona_id,$rv_pmnt_date,$rf_bank_id,$rf_mthd_pmnt_id,$rv_pmnt_ref="",$rv_pmnt_note="") {
	global $lDB;
	global $dbcode;
	global $userid;

	$rf_currency_id = $lDB->get("SELECT rf_currency_id FROM rf_bank WHERE rf_bank_ix = '$rf_bank_id'",4);

	$lDB->put("
		INSERT INTO rv_payment (
			rv_payment_db,
			rv_payment_id,
			pr_persona_id,
			rv_pmnt_date,
			rv_pmnt_date_created,
			rv_pmnt_date_created_tz,
			rf_bank_id,
			rf_currency_id,
			rf_mthd_pmnt_id,
			rv_pmnt_ref,
			rv_pmnt_note,
			rv_pmnt_user_id
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'',
			'".$lDB->escape($pr_persona_id)."',
			'".$lDB->escape($rv_pmnt_date)."',
			'".date("Y-m-d h:i:s")."',
			'".date("e")."',
			'".$lDB->escape($rf_bank_id)."',
			'".$lDB->escape($rf_currency_id)."',
			'".$lDB->escape($rf_mthd_pmnt_id)."',
			'".$lDB->escape($rv_pmnt_ref)."',
			'".$lDB->escape($rv_pmnt_note)."',
			'".$lDB->escape($userid)."'
		)
	");
	$rv_payment_id = $lDB->insert_id;

	return $rv_payment_id;	
}

function db_rv_payment_update_amount($rv_payment_id) {
	global $lDB;

	$master = $lDB->isMaster;
	$lDB->isMaster = "1";
	$rv_pmnt_amount = $lDB->get("SELECT SUM(rv_pay_item_amt_rec) FROM rv_payment_item WHERE rv_payment_id = '$rv_payment_id'",4);
	$lDB->put("UPDATE rv_payment SET rv_pmnt_amount = '".$lDB->escape($rv_pmnt_amount)."' WHERE rv_payment_ix = '$rv_payment_id'");
	$lDB->isMaster = $master;
}

function db_rv_payment_void_payment($rv_payment_items,$rv_pmnt_note="",$rf_mthd_pmnt_id=false) {
	global $lDB;

	if(!is_array($rv_payment_items) || sizeof($rv_payment_items) < 1) {
		return false;
	}
	$first = true;
	foreach($rv_payment_items as $rv_payment_item_id) {
		if($first) {
			$payment = $lDB->get("
				SELECT
					rv_payment.pr_persona_id,
					rv_payment.rv_pmnt_date,
					rv_payment.rf_bank_id,
					rv_payment.rf_mthd_pmnt_id,
					rv_payment.rv_pmnt_ref
				FROM
					rv_payment_item
					INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
				WHERE
					rv_payment_item.rv_payment_item_ix = '$rv_payment_item_id'
			",1);
			if($rf_mthd_pmnt_id === false) {
				$rf_mthd_pmnt_id = $lDB->get("SELECT rf_mthd_pmnt_ix FROM rf_mthd_pmnt WHERE rf_mthd_pmnt_sys_code = '1'",4);
			}
			$rv_payment_id = db_rv_payment_insert($payment['pr_persona_id'],$payment['rv_pmnt_date'],$payment['rf_bank_id'],$rf_mthd_pmnt_id,$payment['rv_pmnt_ref'],$rv_pmnt_note);
			$first = false;
		}
		$item = $lDB->get("
			SELECT
				rv_payment_item.fn_folio_id,
				rv_payment_item.rv_pay_item_amt_rec,
				rv_payment_item.rv_pay_item_exch_rate
			FROM
				rv_payment_item
			WHERE
				rv_payment_item_ix = '$rv_payment_item_id'
		",1);
		
		$gl_exch_rate=false;
		if(db_fn_tran_exists_by_link(DB_FN_TRAN_LINK_PAYMENT,$rv_payment_item_id)) {
			$tranInfo = $lDB->get("
				SELECT
					fn_tran_exch_rate
				FROM
					fn_tran
				WHERE
					fn_tran_link_ind = '".DB_FN_TRAN_LINK_PAYMENT."'
					AND fn_tran_link_id = '$rv_payment_item_id'
			",1);
			$gl_exch_rate = $tranInfo['fn_tran_exch_rate'];
		}

		db_rv_payment_item_insert($rv_payment_id,$item['fn_folio_id'],$item['rv_pay_item_amt_rec'] * -1,$item['rv_pay_item_exch_rate'],$gl_exch_rate,$rv_payment_item_id);
	}
	return $rv_payment_id;
}
