<?php

require_once(__DIR__ . "/db.rv_reservation.php");
require_once(__DIR__ . "/db.pg_account.php");
require_once(__DIR__ . "/db.rf_currency.php");
require_once(__DIR__ . "/db.rv_payment_gateway_folio.php");

define("DB_RV_PAYMENT_GATEWAY_PENDING",0);
define("DB_RV_PAYMENT_GATEWAY_SUCCESS",1);
define("DB_RV_PAYMENT_GATEWAY_DECLINED",2);
define("DB_RV_PAYMENT_GATEWAY_ERROR",3);

function db_rv_payment_gateway_ind_desc($rv_payment_gateway_ind,$ad_modify_date) {
	global $lDB;

	switch($rv_payment_gateway_ind) {
	case DB_RV_PAYMENT_GATEWAY_PENDING:
		$timeout = $lDB->get("SELECT rf_payment_gateway_expiry_mins FROM rf_default",4);
		list($date,$time) = explode(" ",$ad_modify_date);
		list($year,$month,$day) = explode("-",$date);
		list($hour,$minute,$second) = explode(":",$time);

		$expired = (time() - mktime($hour,$minute+$timeout,$second,$month,$day,$year)) > 0;
		if($expired) {
			return "timeout";
		} else {
			return "pending";
		}
	case DB_RV_PAYMENT_GATEWAY_SUCCESS:
		return "success";
	case DB_RV_PAYMENT_GATEWAY_DECLINED:
		return "declined";
	case DB_RV_PAYMENT_GATEWAY_ERROR:
		return "error";
	}	
}

function db_rv_payment_gateway_ind_image($rv_payment_gateway_ind, $ad_modify_date) {
	global $lDB;
	
	switch($rv_payment_gateway_ind) {
	case DB_RV_PAYMENT_GATEWAY_PENDING:
		$timeout = $lDB->get("SELECT rf_payment_gateway_expiry_mins FROM rf_default",4);
		list($date,$time) = explode(" ",$ad_modify_date);
		list($year,$month,$day) = explode("-",$date);
		list($hour,$minute,$second) = explode(":",$time);

		$expired = (time() - mktime($hour,$minute+$timeout,$second,$month,$day,$year)) > 0;
		if($expired) {
			return "/resource/Resrequest/Application/public/img/payment_gateway/payment_error.gif";
		} else {
			return "/resource/Resrequest/Application/public/img/payment_gateway/payment_pending.gif";
		}
		break;
	case DB_RV_PAYMENT_GATEWAY_SUCCESS:
		return "/resource/Resrequest/Application/public/img/payment_gateway/payment_success.gif";
	case DB_RV_PAYMENT_GATEWAY_DECLINED:
		return "/resource/Resrequest/Application/public/img/payment_gateway/payment_declined.gif";
	case DB_RV_PAYMENT_GATEWAY_ERROR:
		return "/resource/Resrequest/Application/public/img/payment_gateway/payment_error.gif";
	}
}

function db_rv_payment_gateway_get_by_reservation($rv_reservation_id) {
	global $lDB;

	$payments = $GLOBALS['lDB']->get("
		SELECT DISTINCT
			rv_payment_gateway.rv_payment_gateway_ix,
			rv_payment_gateway.rv_payment_gateway_ind,
			rv_payment_gateway.rv_payment_gateway_amt_req,
			rv_payment_gateway.rv_payment_gateway_amt_paid,
			rf_currency.rf_currency_symbol,
			rv_payment_gateway.rv_payment_gateway_ref,
			rv_payment_gateway.ad_modify_date,
			pg_account.pg_acc_name,
			pg_type.pg_type_site_url
		FROM
			rv_payment_gateway_folio
			INNER JOIN rv_payment_gateway ON rv_payment_gateway.rv_payment_gateway_ix = rv_payment_gateway_folio.rv_payment_gateway_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rv_payment_gateway.rf_currency_id
			INNER JOIN pg_account ON pg_account.pg_account_ix = rv_payment_gateway.pg_account_id
			INNER JOIN pg_type ON pg_type.pg_type_ix = pg_account.pg_type_id
		WHERE
			rv_payment_gateway_folio.rv_reservation_id = '$rv_reservation_id'
		ORDER BY
			rv_payment_gateway.ad_modify_date DESC
	",2);

	if (empty($payments)) { $payments = array(); }
	
	foreach($payments as $key=>$item) {
		$payments[$key]['image'] = db_rv_payment_gateway_ind_image($item['rv_payment_gateway_ind'],$item['ad_modify_date']);
		$payments[$key]['status'] = db_rv_payment_gateway_ind_desc($item['rv_payment_gateway_ind'],$item['ad_modify_date']);
	}

	return $payments;
}

function db_rv_payment_gateway_exists($rv_payment_gateway_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(rv_payment_gateway_ix) FROM rv_payment_gateway WHERE rv_payment_gateway_ix = '$rv_payment_gateway_id'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_rv_payment_gateway_exists_by_account($pg_account_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(rv_payment_gateway_ix) FROM rv_payment_gateway WHERE pg_account_id = '$pg_account_id'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_rv_payment_gateway_create($pg_account_id,$rf_currency_id,$rv_payment_gateway_amt_req,$folios) {
	if(!is_array($folios)) {
		if(empty($folios)) {
			return false;
		}
		$folios = array($folios);
	}

	$rv_payment_gateway_id = db_rv_payment_gateway_insert($pg_account_id,$rf_currency_id,$rv_payment_gateway_amt_req);

	foreach($folios as $fn_folio_id) {
		db_rv_payment_gateway_folio_insert($rv_payment_gateway_id,$fn_folio_id);
	}

	return $rv_payment_gateway_id;
}

function db_rv_payment_gateway_insert($pg_account_id, $rf_currency_id, $rv_payment_gateway_amt_req, $rv_payment_gateway_ind=DB_RV_PAYMENT_GATEWAY_PENDING, $rv_payment_gateway_log=false, $rv_payment_gateway_ref=false, $rv_payment_gateway_amt_paid=false, $pr_user_id=false) {
	global $lDB;
	global $dbcode;

	if(!db_pg_account_exists($pg_account_id)) {
		return false;
	}	

	if(!db_rf_currency_exists($rf_currency_id)) {
		return false;
	}

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}

	$createDate = date("Y-m-d H:i:s");
	$createDateTz = $modifyDateTz = date("e");

	$extra = array();
	if($rv_payment_gateway_log !== false) {
		$extra['rv_payment_gateway_log'] = $lDB->escape($rv_payment_gateway_log);
	}
	if($rv_payment_gateway_ref !== false) {
		$extra['rv_payment_gateway_ref'] = $lDB->escape($rv_payment_gateway_ref);
	}
	if($rv_payment_gateway_amt_paid !== false) {
		$extra['rv_payment_gateway_amt_paid'] = $lDB->escape($rv_payment_gateway_amt_paid);
	}
	$extraFields = "";
	$extraValues = "";
	if(sizeof($extra) > 0) {
		$extraFields = "," .join(",",array_keys($extra));
		$extraValues = ",'" . join("','",array_values($extra)) . "'";
	}

	$lDB->put("
		INSERT INTO rv_payment_gateway (
			rv_payment_gateway_db,
			pg_account_id,
			rf_currency_id,
			rv_payment_gateway_amt_req,
			rv_payment_gateway_ind,
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id,
			ad_modify_date,
			ad_modify_date_tz,
			ad_modify_user_id
			$extraFields
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($pg_account_id)."',
			'".$lDB->escape($rf_currency_id)."',
			'".$lDB->escape($rv_payment_gateway_amt_req)."',
			'".$lDB->escape($rv_payment_gateway_ind)."',
			'".$lDB->escape($createDate)."',
			'".$lDB->escape($createDateTz)."',
			'".$lDB->escape($pr_user_id)."',
			'".$lDB->escape($createDate)."',
			'".$lDB->escape($modifyDateTz)."',
			'".$lDB->escape($pr_user_id)."'
			$extraValues
		)
	");

	$paymentGatewayId = $lDB->insert_id;

	return $paymentGatewayId;	
}

function db_rv_payment_gateway_update($rv_payment_gateway_id,$rv_payment_gateway_ind,$rv_payment_gateway_log=false,$rv_payment_gateway_ref=false,$rv_payment_gateway_amt_paid=false,$pr_user_id=false) {
	global $lDB;

	if(!db_rv_payment_gateway_exists($rv_payment_gateway_id)) {
		return false;
	}

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}

	$modifyDate = date("Y-m-d H:i:s");	
	$modifyDateTz = date("e");

	$extra = array();
	if($rv_payment_gateway_log !== false) {
		$extra['rv_payment_gateway_log'] = $lDB->escape($rv_payment_gateway_log);
	}
	if($rv_payment_gateway_ref !== false) {
		$extra['rv_payment_gateway_ref'] = $lDB->escape($rv_payment_gateway_ref);
	}
	if($rv_payment_gateway_amt_paid != false) {
		$extra['rv_payment_gateway_amt_paid'] = $lDB->escape($rv_payment_gateway_amt_paid);
	}
	$extraFields = array();
	foreach($extra as $key=>$item) {
		$extraFields[] = "$key = '$item'";
	}
	if(sizeof($extraFields) > 0) {
		$extraSQL = "," . join(",",$extraFields);
	}

	$lDB->put("
		UPDATE rv_payment_gateway SET
			rv_payment_gateway_ind = '".$lDB->escape($rv_payment_gateway_ind)."',
			ad_modify_date = '".$lDB->escape($modifyDate)."',
			ad_modify_date_tz = '".$lDB->escape($modifyDateTz)."',
			ad_modify_user_id = '".$lDB->escape($pr_user_id)."'
			$extraSQL
		WHERE
			rv_payment_gateway_ix = '$rv_payment_gateway_id'
	");

	return true;
}
