<?php

require_once(__DIR__ . "/db.rv_payment.php");
require_once(__DIR__ . "/db.fn_tran.php");
require_once(__DIR__ . "/db.fn_folio.php");

require_once(__DIR__ . "/functions.financial.php");

function db_rv_payment_item_exists($rv_payment_item_id) {
	$count = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM rv_payment_item WHERE rv_payment_item_ix = '$rv_payment_item_id'",4);
	if($count > 0) {
		return true;
	} else {
		return false;
	}
}

function db_rv_payment_item_exists_by_gateway_and_reservation($rv_payment_gateway_id, $rv_reservation_id) {
	$count = $GLOBALS['lDB']->get("
				SELECT 
					COUNT(*) 
				FROM 
					rv_payment_item 
				WHERE 
					rv_payment_gateway_id = '$rv_payment_gateway_id' 
					AND 
					rv_reservation_id = '$rv_reservation_id'",4);
	return $count > 0 ? true : false;
}

function db_rv_payment_item_insert($rv_payment_id,$fn_folio_id,$rv_payment_amt_rec,$rv_pay_item_exch_rate=1,$gl_exch_rate=false,$rv_payment_contra_id=false,$rv_payment_gateway_id=false) {
	global $lDB;
	global $dbcode;

	$rv_reservation_id = $lDB->get("SELECT rv_reservation_id FROM fn_folio WHERE fn_folio_ix = '$fn_folio_id'",4);
	$payment_currency_id = $lDB->get("SELECT rf_currency_id FROM rv_payment WHERE rv_payment_ix = '$rv_payment_id'",4);
	$folio_currency_id = $lDB->get("SELECT rf_currency_id FROM fn_folio WHERE fn_folio_ix = '$fn_folio_id'",4);

	if($payment_currency_id == $folio_currency_id || trim($rv_pay_item_exch_rate) == "") {
		$rv_pay_item_exch_rate = 1;
	}

	$rv_pay_item_exch_rate = round($rv_pay_item_exch_rate, exchDecimalPlaces());

	// Not sure whether sprintf was the correct fix here.
	// Example where it was not working:
	// 70.60 was converted to 70.599999999999
	$rv_payment_item_amt = sprintf("%.10f", round($rv_payment_amt_rec * $rv_pay_item_exch_rate,2));

	$extra = array();

	if($rv_payment_contra_id !== false) {
		$extra['rv_payment_contra_id'] = $lDB->escape($rv_payment_contra_id);
		$extra['rv_pay_item_void_user_id'] = $lDB->escape($GLOBALS['userid']);
		$extra['rv_pay_item_void_time'] = date("Y-m-d H:i:s");
		$extra['rv_pay_item_void_time_tz'] = date("e");
	}

	if($rv_payment_gateway_id !== false) {
		$extra['rv_payment_gateway_id'] = $lDB->escape($rv_payment_gateway_id);
	}

	$extraFields = "";
	$extraValues = "";
	if(sizeof($extra) > 0) {
		$extraFields = "," .join(",",array_keys($extra));
		$extraValues = ",'" . join("','",array_values($extra)) . "'";
	}

	$lDB->put("
		INSERT INTO rv_payment_item (
			rv_payment_item_db,
			rv_payment_item_id,
			rv_payment_id,
			fn_folio_id,
			rv_reservation_id,
			rf_currency_id,
			rv_pay_item_amt_rec,
			rv_pay_item_exch_rate,
			rv_payment_item_amt
			$extraFields
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'',
			'".$lDB->escape($rv_payment_id)."',
			'".$lDB->escape($fn_folio_id)."',
			'".$lDB->escape($rv_reservation_id)."',
			'".$lDB->escape($folio_currency_id)."',
			'".$lDB->escape($rv_payment_amt_rec)."',
			'".$lDB->escape($rv_pay_item_exch_rate)."',
			'".$lDB->escape($rv_payment_item_amt)."'
			$extraValues
		)
	");
	$rv_payment_item_id = $lDB->insert_id;

	if($rv_payment_contra_id !== false) {
		$master = $lDB->isMaster;
		$lDB->isMaster = "1";
		$lDB->put("UPDATE rv_payment_item SET rv_payment_contra_id = '".$lDB->escape($rv_payment_item_id)."' WHERE rv_payment_item_ix = '$rv_payment_contra_id'");
		$lDB->isMaster = $master;
	}

	db_rv_payment_update_amount($rv_payment_id);
	db_fn_folio_update_totals($fn_folio_id);

	if($gl_exch_rate !== false && trim($gl_exch_rate) != "") {	
		if($gl_exch_rate != "none") {
			$fn_tran_exch_rate = $gl_exch_rate;
		} else {
			if ($rv_pay_item_exch_rate != 1) {
				$fn_tran_exch_rate = 1 / $rv_pay_item_exch_rate;	
			} else {
				$fn_tran_exch_rate = "none";
			}
		}
		db_fn_tran_payment($rv_payment_item_id,$fn_tran_exch_rate);
	}

	recalcTotals($rv_reservation_id);

	return $rv_payment_item_id;	
}
