<?php

/**
 * db.rv_registration_card.php - Database functions for table rv_registration_card
 */


require_once(__DIR__ . "/functions.reservation.php");
require_once(__DIR__ . "/db.pr_guest.php");
require_once(__DIR__ . "/db.rv_res_item_group.php");
require_once(__DIR__ . "/db.rv_res_item_guest.php");
require_once(__DIR__ . "/db.rv_registration_card_obj_data.php");

function db_rv_registration_card_exists($rv_registration_card_id)
{
	global $lDB;

	$folioCheck = $lDB->get("SELECT COUNT(rv_registration_card_ix) FROM rv_registration_card WHERE rv_registration_card_ix = '$rv_registration_card_id'", 4);
	if ($folioCheck > 0) {
		return true;
	} else {
		return false;
	}
}

function db_rv_registration_card_exists_by_registration_card($rv_res_item_group_id, $pr_guest_id)
{
	global $lDB;

	$sqlFrom = "
		FROM
			rv_registration_card
		WHERE
			rv_res_item_group_id = '$rv_res_item_group_id'
			AND pr_guest_id = '$pr_guest_id'
	";

	$registrationFormCheck = $lDB->get("SELECT count(rv_registration_card_ix) $sqlFrom", 4);
	if ($registrationFormCheck == "0") {
		return false;
	} else {
		return $lDB->get("SELECT rv_registration_card_ix $sqlFrom", 4);
	}
}

function db_rv_registration_card_get_by_id($rv_registration_card_id) {
	global $lDB;

	if (!db_rv_registration_card_exists($rv_registration_card_id)) {
		return false;
	}

	$registrationCard = $lDB->get("
		SELECT
			rv_registration_card_db,
			rv_registration_card_id,
			rv_registration_card_ix,
			rv_res_item_group_id,
			pr_guest_id,
			rv_reservation_id,
			rv_reservation_item_id,
			pr_business_id,
			ac_accomm_type_id,
			rv_item_date_arrive,
			rv_item_date_depart,
			rv_registration_card_indemnity_message,
			rv_registration_card_indemnity_accept_date,
			rv_registration_card_indemnity_accept_date_tz,
			rv_registration_card_indemnity_message_yn,
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id,
			ad_modify_date,
			ad_modify_date_tz,
			ad_modify_user_id
		FROM
			rv_registration_card
		WHERE
			rv_registration_card_ix = '" . $lDB->escape($rv_registration_card_id) . "'
	", 1);

	return $registrationCard;
}

function db_rv_registration_card_update($rv_registration_card_id)
{
	global $lDB;

	if (!db_rv_registration_card_exists($rv_registration_card_id)) {
		return false;
	}

	$rv_registration_card = db_rv_registration_card_get_by_id($rv_registration_card_id);

	$resDetails = $lDB->get("
		SELECT
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_consultant_id,
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.ac_accomm_type_id,
			rv_reservation_item.pr_business_id,
			business.pr_name_last,
			ac_accomm_type.ac_accomm_desc,
			pr_persona.pr_email,
			pr_persona.pr_name_first as consultant_name_first,
			pr_persona.pr_name_last as consultant_name_last
		FROM
			rv_res_item_group
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			INNER JOIN pr_persona AS business ON business.pr_persona_ix = rv_reservation_item.pr_business_id
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_consultant_id
		WHERE
			rv_res_item_group.rv_res_item_group_ix = '{$rv_registration_card['rv_res_item_group_id']}'
	",6)[0];

	$rf_res_office_id = $lDB->get("select rf_res_office_id from rf_default where rf_default_id = '1'",1)['rf_res_office_id'];
	$resOfficeContact = $lDB->get("
		SELECT
			pr_email,
			pr_phone_number
		FROM
			pr_persona
			INNER JOIN pr_phone ON pr_phone.pr_persona_id = pr_persona.pr_persona_ix
		WHERE pr_persona_ix = '$rf_res_office_id'
	", 1);

	$today = date("Y-m-d H:i:s");
	$ad_modify_date_tz = $rv_registration_card_indemnity_accept_date_tz = date("e");

	$rv_registration_card_indemnity_message = $lDB->get("SELECT rf_guest_indemnity_message FROM rf_default", 4);
	$pr_bus_guest_indemnity_message = $lDB->get("
		SELECT
			pr_bus_guest_indemnity_message
		FROM
			pr_business
		WHERE
			pr_business_id = '{$resDetails['pr_business_id']}'
	",4);

	
	$rv_registration_card_indemnity_message_yn = 0;
	$rv_registration_card_indemnity_accept_date = '0000-00-00 00:00:00';
	if (!empty($pr_bus_guest_indemnity_message) || !empty($rv_registration_card_indemnity_message)) {
		$rv_registration_card_indemnity_message_yn = 1;
		$rv_registration_card_indemnity_accept_date = $today;
	}

	if (!empty($pr_bus_guest_indemnity_message)) {
		$rv_registration_card_indemnity_message = $pr_bus_guest_indemnity_message;
	}

	$rv_item_date_arrive = $resDetails['rv_item_date_arrive'];
	$rv_item_date_depart = $resDetails['rv_item_date_depart'];


	$lDB->put("
		UPDATE
			rv_registration_card
		SET
			rv_item_date_arrive = '" . $lDB->escape($rv_item_date_arrive) . "',
			rv_item_date_depart = '" . $lDB->escape($rv_item_date_depart) . "',
			rv_registration_card_indemnity_message = '" . $lDB->escape($rv_registration_card_indemnity_message) . "',
			rv_registration_card_indemnity_accept_date = '" . $lDB->escape($rv_registration_card_indemnity_accept_date) . "',
			rv_registration_card_indemnity_accept_date_tz = '" . $lDB->escape($rv_registration_card_indemnity_accept_date_tz) . "',
			rv_registration_card_indemnity_message_yn = '" . $lDB->escape($rv_registration_card_indemnity_message_yn) . "',
			ad_modify_date = '" . $lDB->escape($today) . "',
			ad_modify_date_tz = '" . $lDB->escape($ad_modify_date_tz) . "',
			ad_modify_user_id = '" . $lDB->escape($GLOBALS['userid']) . "'
		WHERE
			rv_registration_card_ix = '" . $lDB->escape($rv_registration_card_id) . "'
	");

	$accommodation_type_desc = $resDetails['ac_accomm_desc'];
	$property_name = $resDetails['pr_name_last'];
	$consultant_email = $resDetails['pr_email'];
	$consultant_name_first = $resDetails['consultant_name_first'];
	$consultant_name_last = $resDetails['consultant_name_last'];
	$res_office_phone_number = $resOfficeContact['pr_phone_number'];
	$res_office_email = $resOfficeContact['pr_email'];

	$rf_obj_registration_card_id = db_rf_obj_registration_card_by_name('accommodation_type_desc');
	$id = db_rv_registration_card_obj_data_select_by_id($rf_obj_registration_card_id, $rv_registration_card_id);
	db_rv_registration_card_obj_data_update($id, 2, $accommodation_type_desc);

	$rf_obj_registration_card_id = db_rf_obj_registration_card_by_name('property_name');
	$id = db_rv_registration_card_obj_data_select_by_id($rf_obj_registration_card_id, $rv_registration_card_id);
	db_rv_registration_card_obj_data_update($id, 2, $property_name);

	$rf_obj_registration_card_id = db_rf_obj_registration_card_by_name('consultant_email');
	$id = db_rv_registration_card_obj_data_select_by_id($rf_obj_registration_card_id, $rv_registration_card_id);
	db_rv_registration_card_obj_data_update($id, 2, $consultant_email);

	$rf_obj_registration_card_id = db_rf_obj_registration_card_by_name('consultant_name_first');
	$id = db_rv_registration_card_obj_data_select_by_id($rf_obj_registration_card_id, $rv_registration_card_id);
	db_rv_registration_card_obj_data_update($id, 2, $consultant_name_first);

	$rf_obj_registration_card_id = db_rf_obj_registration_card_by_name('consultant_name_last');
	$id = db_rv_registration_card_obj_data_select_by_id($rf_obj_registration_card_id, $rv_registration_card_id);
	db_rv_registration_card_obj_data_update($id, 2, $consultant_name_last);

	$rf_obj_registration_card_id = db_rf_obj_registration_card_by_name('res_office_phone_number');
	$id = db_rv_registration_card_obj_data_select_by_id($rf_obj_registration_card_id, $rv_registration_card_id);
	db_rv_registration_card_obj_data_update($id, 2, $res_office_phone_number);

	$rf_obj_registration_card_id = db_rf_obj_registration_card_by_name('res_office_email');
	$id = db_rv_registration_card_obj_data_select_by_id($rf_obj_registration_card_id, $rv_registration_card_id);
	db_rv_registration_card_obj_data_update($id, 2, $res_office_email);
}

function db_rv_registration_card_insert($rv_res_item_group_id, $pr_guest_id)
{
	global $lDB;

	if (db_rv_registration_card_exists_by_registration_card($rv_res_item_group_id, $pr_guest_id)) {
		return false;
	}

	$resDetails = $lDB->get("
		SELECT
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_consultant_id,
			rv_reservation_item.rv_reservation_item_ix,
			rv_reservation_item.rv_item_date_arrive,
			rv_reservation_item.rv_item_date_depart,
			rv_reservation_item.ac_accomm_type_id,
			rv_reservation_item.pr_business_id,
			business.pr_name_last,
			ac_accomm_type.ac_accomm_desc,
			pr_persona.pr_email,
			pr_persona.pr_name_first as consultant_name_first,
			pr_persona.pr_name_last as consultant_name_last
		FROM
			rv_res_item_group
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			INNER JOIN pr_persona AS business ON business.pr_persona_ix = rv_reservation_item.pr_business_id
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_consultant_id
		WHERE
			rv_res_item_group.rv_res_item_group_ix = '$rv_res_item_group_id'
	",6)[0];

	$rf_res_office_id = $lDB->get("select rf_res_office_id from rf_default where rf_default_id = '1'",1)['rf_res_office_id'];
	$resOfficeContact = $lDB->get("
		SELECT
			pr_email,
			pr_phone_number
		FROM
			pr_persona
			INNER JOIN pr_phone ON pr_phone.pr_persona_id = pr_persona.pr_persona_ix
		WHERE pr_persona_ix = '$rf_res_office_id'
	", 1);

	$today = date("Y-m-d H:i:s");
	$ad_create_date_tz = $ad_modify_date_tz = $rv_registration_card_indemnity_accept_date_tz = date("e");

	$rv_registration_card_indemnity_message = $lDB->get("SELECT rf_guest_indemnity_message FROM rf_default", 4);
	$pr_bus_guest_indemnity_message = $lDB->get("
		SELECT
			pr_bus_guest_indemnity_message
		FROM
			pr_business
		WHERE
			pr_business_id = '{$resDetails['pr_business_id']}'
	",4);

	
	$rv_registration_card_indemnity_message_yn = 0;
	$rv_registration_card_indemnity_accept_date = '0000-00-00 00:00:00';
	if (!empty($pr_bus_guest_indemnity_message) || !empty($rv_registration_card_indemnity_message)) {
		$rv_registration_card_indemnity_message_yn = 1;
		$rv_registration_card_indemnity_accept_date = $today;
	}

	if (!empty($pr_bus_guest_indemnity_message)) {
		$rv_registration_card_indemnity_message = $pr_bus_guest_indemnity_message;
	}

	$rv_reservation_id = $resDetails['rv_reservation_ix'];
	$rv_reservation_item_id = $resDetails['rv_reservation_item_ix'];
	$pr_business_id = $resDetails['pr_business_id'];
	$ac_accomm_type_id = $resDetails['ac_accomm_type_id'];
	$rv_item_date_arrive = $resDetails['rv_item_date_arrive'];
	$rv_item_date_depart = $resDetails['rv_item_date_depart'];

	if (empty($resDetails['rv_reservation_ix'])) {
		return false;
	}

	if (!db_pr_guest_exists($pr_guest_id)) {
		return false;
	}

	if (!db_rv_res_item_group_exists($rv_res_item_group_id)) {
		return false;
	}

	if (!db_rv_res_item_guest_exists_by_item($pr_guest_id, $resDetails['rv_reservation_item_ix'])) {
		return false;
	}

	$lDB->put("
		INSERT INTO rv_registration_card (
			rv_res_item_group_id,
			pr_guest_id,
			rv_reservation_id,
			rv_reservation_item_id,
			pr_business_id,
			ac_accomm_type_id,
			rv_item_date_arrive,
			rv_item_date_depart,
			rv_registration_card_indemnity_message,
			rv_registration_card_indemnity_accept_date,
			rv_registration_card_indemnity_accept_date_tz,
			rv_registration_card_indemnity_message_yn,
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id,
			ad_modify_date,
			ad_modify_date_tz,
			ad_modify_user_id
		) VALUES (
			'" . $lDB->escape($rv_res_item_group_id) . "',
			'" . $lDB->escape($pr_guest_id) . "',
			'" . $lDB->escape($rv_reservation_id) . "',
			'" . $lDB->escape($rv_reservation_item_id) . "',
			'" . $lDB->escape($pr_business_id) . "',
			'" . $lDB->escape($ac_accomm_type_id) . "',
			'" . $lDB->escape($rv_item_date_arrive) . "',
			'" . $lDB->escape($rv_item_date_depart) . "',
			'" . $lDB->escape($rv_registration_card_indemnity_message) . "',
			'" . $lDB->escape($rv_registration_card_indemnity_accept_date) . "',
			'" . $lDB->escape($rv_registration_card_indemnity_accept_date_tz) . "',
			'" . $lDB->escape($rv_registration_card_indemnity_message_yn) . "',
			'" . $lDB->escape($today) . "',
			'" . $lDB->escape($ad_create_date_tz) . "',
			'" . $lDB->escape($GLOBALS['userid']) . "',
			'" . $lDB->escape($today) . "',
			'" . $lDB->escape($ad_modify_date_tz) . "',
			'" . $lDB->escape($GLOBALS['userid']) . "'
		)
	");
	$registrationFormId = $lDB->insert_id;


	$accommodation_type_desc = $resDetails['ac_accomm_desc'];
	$property_name = $resDetails['pr_name_last'];
	$consultant_email = $resDetails['pr_email'];
	$consultant_name_first = $resDetails['consultant_name_first'];
	$consultant_name_last = $resDetails['consultant_name_last'];
	$res_office_phone_number = $resOfficeContact['pr_phone_number'];
	$res_office_email = $resOfficeContact['pr_email'];

	$id = db_rf_obj_registration_card_by_name('accommodation_type_desc');
	db_rv_registration_card_obj_data_insert($id, $registrationFormId, $accommodation_type_desc, 2);

	$id = db_rf_obj_registration_card_by_name('property_name');
	db_rv_registration_card_obj_data_insert($id, $registrationFormId, $property_name, 2);

	$id = db_rf_obj_registration_card_by_name('consultant_email');
	db_rv_registration_card_obj_data_insert($id, $registrationFormId, $consultant_email, 2);

	$id = db_rf_obj_registration_card_by_name('consultant_name_first');
	db_rv_registration_card_obj_data_insert($id, $registrationFormId, $consultant_name_first, 2);

	$id = db_rf_obj_registration_card_by_name('consultant_name_last');
	db_rv_registration_card_obj_data_insert($id, $registrationFormId, $consultant_name_last, 2);

	$id = db_rf_obj_registration_card_by_name('res_office_phone_number');
	db_rv_registration_card_obj_data_insert($id, $registrationFormId, $res_office_phone_number, 2);

	$id = db_rf_obj_registration_card_by_name('res_office_email');
	db_rv_registration_card_obj_data_insert($id, $registrationFormId, $res_office_email, 2);

	return $registrationFormId;
}
