<?php
require_once(__DIR__ . "/db.rf_obj_registration_card.php");
function db_rv_registration_card_obj_data_exists($fieldValue, $field='rv_registration_card_obj_data_ix') {
	global $lDB;

	$check = $lDB->get("
		SELECT
			COUNT(rv_registration_card_obj_data_ix)
		FROM
			rv_registration_card_obj_data
		WHERE
			$field = '".$lDB->escape($fieldValue)."'
			AND (
				rv_registration_card_obj_data != ''
				OR rf_obj_registration_card_data_id != ''
			)
	",4);
	if($check > 0) { 
		return true; 
	} else { 
		return false; 
	}
}

function db_rv_registration_card_obj_data_select_by_id($rf_obj_registration_card_id, $rv_registration_card_id) {
	global $lDB;
	$rv_registration_card_obj_data_id = $lDB->get("
		SELECT 
			rv_registration_card_obj_data_ix 
		FROM 
			rv_registration_card_obj_data 
		WHERE 
			rf_obj_registration_card_id = '$rf_obj_registration_card_id' 
			AND rv_registration_card_id = '$rv_registration_card_id' 
	",4);
	if($rv_registration_card_obj_data_id == '') {
		return 0;
	} else {
		return $rv_registration_card_obj_data_id;
	}
}

function db_rv_registration_card_obj_data_select_by_registration_card_id($rv_registration_card_id)
{
	global $lDB;

	$rv_registration_card_obj_data_id = $lDB->get("
		SELECT 
			rv_registration_card_obj_data_ix 
		FROM 
			rv_registration_card_obj_data 
		WHERE 
			rv_registration_card_id = '$rv_registration_card_id' 
	",4);
	if($rv_registration_card_obj_data_id == '') {
		return 0;
	} else {
		return $rv_registration_card_obj_data_id;
	}
}

function db_rv_registration_card_obj_data_field_by_type($rf_obj_registration_card_type_ind) {
	switch($rf_obj_registration_card_type_ind) {
	case DB_RF_OBJ_registration_card_TEXTBOX:
	case DB_RF_OBJ_registration_card_TEXTAREA:
	case DB_RF_OBJ_registration_card_NUMERIC:
		return 'rv_registration_card_obj_data';
	case DB_RF_OBJ_registration_card_RADIO:
	case DB_RF_OBJ_registration_card_SELECTBOX:
	case DB_RF_OBJ_registration_card_CHECKBOX:
		return 'rf_obj_registration_card_data_id';
	}
}

function db_rv_registration_card_obj_data_get_all($rv_registration_card_obj_data_id) {
	global $lDB;

	if(!db_rv_registration_card_obj_data_exists($rv_registration_card_obj_data_id)) {
		return false;
	}

	$rv_registration_card_obj_data = $lDB->get("
		SELECT
			rv_registration_card_obj_data.rf_obj_registration_card_id,
			rv_registration_card_obj_data.rv_registration_card_obj_data,
			rv_registration_card_obj_data.rf_obj_registration_card_data_id,
			rf_obj_registration_card.rf_obj_registration_card_type_ind
		FROM
			rv_registration_card_obj_data
			INNER JOIN rf_obj_registration_card ON rf_obj_registration_card.rf_obj_registration_card_ix = rv_registration_card_obj_data.rf_obj_registration_card_id
		WHERE
			rv_registration_card_obj_data.rv_registration_card_obj_data_ix = '".$lDB->escape($rv_registration_card_obj_data_id)."'
	",1);

	$value = $rv_registration_card_obj_data[db_rv_registration_card_obj_data_field_by_type($rv_registration_card_obj_data['rf_obj_registration_card_type_ind'])];
	return db_rf_obj_registration_card_get_all($rv_registration_card_obj_data['rf_obj_registration_card_id'], $value);
}

function db_rv_registration_card_obj_data_by_rv_registration_card_id($rv_registration_card_id, $rf_obj_registration_card_sys_code = null, $assoc_array = false) {
	global $lDB;

	$whereSql = '';
	if (!is_null($rf_obj_registration_card_sys_code)) {
		if (is_array($rf_obj_registration_card_sys_code)) {
			$rf_obj_registration_card_sys_code = "IN(" . join(',', $rf_obj_registration_card_sys_code) . ")";
			$whereSql = "AND rf_obj_registration_card.rf_obj_registration_card_sys_code " . $rf_obj_registration_card_sys_code;
		} else {
			$rf_obj_registration_card_sys_code = $lDB->escape($rf_obj_registration_card_sys_code);
			$whereSql = "AND rf_obj_registration_card.rf_obj_registration_card_sys_code = '" . $rf_obj_registration_card_sys_code . "'";
		}
	}

	$rv_registration_card_obj_datas = $lDB->get("
		SELECT 
			rf_obj_registration_card.rf_obj_registration_card_name as name,
			rf_obj_registration_card.rf_obj_registration_card_label as label,
			rv_registration_card_obj_data.rv_registration_card_obj_data as value
		FROM 
			 rv_registration_card_obj_data
			 INNER JOIN rf_obj_registration_card ON rf_obj_registration_card.rf_obj_registration_card_ix = rv_registration_card_obj_data.rf_obj_registration_card_id
		WHERE
			rv_registration_card_id = '$rv_registration_card_id'
			$whereSql
		ORDER BY rf_obj_registration_card_sort_seq
	", 6);

	$output = [];
	foreach($rv_registration_card_obj_datas as $data) {
		if ($assoc_array) {
			$output[$data['name']] = $data;
		} else {
			$output[] = $data;
		}
	}

	return $output;
}

function db_rv_registration_card_obj_data_insert($rf_obj_registration_card_id, $rv_registration_card_id, $rv_registration_card_obj_data, $rf_obj_registration_card_type_ind) {

	global $lDB;
	global $dbcode;
	
	
	if(!db_rf_obj_registration_card_exists($rf_obj_registration_card_id)) {
		return false;
	}
	
	$rv_registration_card_obj_data_id = db_rv_registration_card_obj_data_select_by_id($rf_obj_registration_card_id, $rv_registration_card_id);
	if($rv_registration_card_obj_data_id != '0' && $rf_obj_registration_card_type_ind != DB_RF_OBJ_registration_card_CHECKBOX) {

		$rv_registration_card_obj_data_id 			= isset($rv_registration_card_obj_data_id) ? $rv_registration_card_obj_data_id : "";
		$rf_obj_registration_card_type_ind 			= isset($rf_obj_registration_card_type_ind) ? $rf_obj_registration_card_type_ind : "";
		$rv_registration_card_obj_data 				= isset($rv_registration_card_obj_data) ? $rv_registration_card_obj_data : "";
		$rv_registration_card_obj_data_inactive_yn 	= isset($rv_registration_card_obj_data_inactive_yn) ? $rv_registration_card_obj_data_inactive_yn : "0";
		
		db_rv_registration_card_obj_data_update($rv_registration_card_obj_data_id, $rf_obj_registration_card_type_ind, $rv_registration_card_obj_data, $rv_registration_card_obj_data_inactive_yn);
	} else { 
		$data_field = 'rv_registration_card_obj_data';
		if($rf_obj_registration_card_type_ind == DB_RF_OBJ_registration_card_RADIO || $rf_obj_registration_card_type_ind == DB_RF_OBJ_registration_card_CHECKBOX || $rf_obj_registration_card_type_ind == DB_RF_OBJ_registration_card_SELECTBOX) {
			$data_field = 'rf_obj_registration_card_data_id';	
		}
		
		$lDB->put("
			INSERT INTO 
				rv_registration_card_obj_data (
					rv_registration_card_obj_data_db,
					$data_field,
					rf_obj_registration_card_id,
					rv_registration_card_id
				) 
			VALUES (
				'".$lDB->escape($dbcode)."',
				'".$lDB->escape($rv_registration_card_obj_data)."',
				'".$lDB->escape($rf_obj_registration_card_id)."',
				'".$lDB->escape($rv_registration_card_id)."'
			)
		");
	
		$rv_registration_card_obj_data_id = $lDB->insert_id;
	}
	return $rv_registration_card_obj_data_id;
}

function db_rv_registration_card_obj_data_update($rv_registration_card_obj_data_id, $rf_obj_registration_card_type_ind, $rv_registration_card_obj_data) {
	global $lDB;
	$data_field = 'rv_registration_card_obj_data';
	if($rf_obj_registration_card_type_ind == DB_RF_OBJ_registration_card_RADIO || $rf_obj_registration_card_type_ind == DB_RF_OBJ_registration_card_CHECKBOX || $rf_obj_registration_card_type_ind == DB_RF_OBJ_registration_card_SELECTBOX) {
		$data_field = 'rf_obj_registration_card_data_id';	
	}
		
	$lDB->put("
		UPDATE rv_registration_card_obj_data SET
			$data_field = '".$lDB->escape($rv_registration_card_obj_data)."'
		WHERE
			rv_registration_card_obj_data_ix = '".$lDB->escape($rv_registration_card_obj_data_id)."'
	");
}

function db_rv_registration_card_obj_data_delete($rv_registration_card_obj_data_id) {
	global $lDB;
	$res = $lDB->put("
		DELETE 
		FROM 
			rv_registration_card_obj_data 
		WHERE 
			rv_registration_card_obj_data_ix = '".$lDB->escape($rv_registration_card_obj_data_id)."'
	");
	
	return $res;
}

function db_rv_registration_card_obj_data_delete_by_parent($rf_obj_registration_card_id) {
	global $lDB;
	if(!db_rf_obj_registration_card_exists($rf_obj_registration_card_id)) {
		return false;
	}

	$rv_registration_card_obj_data_ixs = $lDB->get("
		SELECT 
			rv_registration_card_obj_data_ix
		FROM 
			rv_registration_card_obj_data
		WHERE
			rf_obj_registration_card_id = '$rf_obj_registration_card_id'
	", 3);

	if(is_array($rv_registration_card_obj_data_ixs)) {
		foreach($rv_registration_card_obj_data_ixs as $rv_registration_card_obj_data_id) {
			db_rv_registration_card_obj_data_delete($rv_registration_card_obj_data_id);
		}
	}
}

function db_rv_registration_card_obj_data_select($rf_obj_registration_card_id) {
	global $lDB;
	
	$obj_registration_card_data = $lDB->get("SELECT * FROM rf_obj_registration_card_data WHERE rf_obj_registration_card_id = '$rf_obj_registration_card_id'", 2);

	if(count($obj_registration_card_data) > 0) {
		return $obj_registration_card_data; 
	} else { 
		return false; 
	}

}

function db_rv_registration_card_obj_data_delete_by_registration_card($rv_registration_card_id, $audit = false) {
	global $lDB;
	
	$rv_registration_card_obj_datas = $lDB->get("
		SELECT 
			rv_registration_card_obj_data_ix,
			rf_obj_registration_card_id
		FROM 
			rv_registration_card_obj_data
		WHERE
			AND rv_registration_card_id = '$rv_registration_card_id'
	", 6);

	foreach($rv_registration_card_obj_datas as $rv_registration_card_obj_data) {
		$rv_registration_card_obj_data_id = $rv_registration_card_obj_data['rv_registration_card_obj_data_ix'];
		$rf_obj_registration_card_id = $rv_registration_card_obj_data['rf_obj_registration_card_id'];
		if($audit !== false) {
			$all = db_rv_registration_card_obj_data_get_all($rv_registration_card_obj_data_id);
			$audit->addDetail($all['id'], "", $rv_registration_card_obj_data_id, "", DB_AD_PERSONA_DETAIL_ACTION_DELETE, "tripsheet", "rv_registration_card_obj_data.", $rf_obj_registration_card_id, $all['value'], "");
		}
		db_rv_registration_card_obj_data_delete($rv_registration_card_obj_data_id);
	}
}
