<?php

require_once(__DIR__ . "/db.rv_reservation_item.php");
require_once(__DIR__ . "/db.rv_res_item_comp_tax.php");
require_once(__DIR__ . "/db.rv_res_item_comp_rate_grp.php");

function db_rv_res_item_comp_exists($rv_res_item_comp_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(rv_res_item_comp_ix) FROM rv_res_item_comp WHERE rv_res_item_comp_ix = '$rv_res_item_comp_id'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_rv_res_item_comp_insert($rv_reservation_item_id, $rt_component_id, $rt_tax_ind=10, $rt_tax_id, $rv_item_comp_freq_ind, $rv_item_comp_freq_factor, $rv_item_comp_rate, $rv_item_comp_rate_comm, $rv_item_comp_comm_ind, $rv_item_comp_option_yn, $rv_item_comp_separate_yn, $rv_item_comp_var, $rv_item_comp_tax_perc, $rv_item_comp_amt_gross, $rv_item_comp_amt_nett, $rv_item_comp_amt_comm, $rv_item_comp_amt_comm_calc, $rv_item_comp_amt_tax, $rv_item_comp_amt_payable, $db_code=false) {
	global $lDB;

	if(!db_rv_reservation_item_exists($rv_reservation_item_id)) {
		return false;
	}

	$extra = array();
	$extraFields = "";
	$extraValues = "";
	if(sizeof($extra) > 0) {
		$extraFields = "," .join(",",array_keys($extra));
		$extraValues = ",'" . join("','",array_values($extra)) . "'";
	}

	if($db_code === false) {
		$db_code = $GLOBALS['dbcode'];
	}	
	
	$lDB->put("
		INSERT INTO rv_res_item_comp (
			rv_res_item_comp_db,
			rv_reservation_item_id,
			rt_component_id,
			rt_tax_ind,
			rt_tax_id,
			rv_item_comp_freq_ind,
			rv_item_comp_freq_factor,
			rv_item_comp_rate,
			rv_item_comp_rate_comm,
			rv_item_comp_comm_ind,
			rv_item_comp_option_yn,
			rv_item_comp_separate_yn,
			rv_item_comp_var,
			rv_item_comp_tax_perc,
			rv_item_comp_amt_gross,
			rv_item_comp_amt_nett,
			rv_item_comp_amt_comm,
			rv_item_comp_amt_comm_calc,
			rv_item_comp_amt_tax,
			rv_item_comp_amt_payable
			$extraFields
		) VALUES (
			'".$lDB->escape($db_code)."',
			'".$lDB->escape($rv_reservation_item_id)."',
			'".$lDB->escape($rt_component_id)."',
			'".$lDB->escape($rt_tax_ind)."',
			'".$lDB->escape($rt_tax_id)."',
			'".$lDB->escape($rv_item_comp_freq_ind)."',
			'".$lDB->escape($rv_item_comp_freq_factor)."',
			".db_round($rv_item_comp_rate,2).",
			".db_round($rv_item_comp_rate_comm,2).",
			'".$lDB->escape($rv_item_comp_comm_ind)."',
			'".$lDB->escape($rv_item_comp_option_yn)."',
			'".$lDB->escape($rv_item_comp_separate_yn)."',
			".db_round($rv_item_comp_var,2).",
			".db_round($rv_item_comp_tax_perc,6).",
			".db_round($rv_item_comp_amt_gross,2).",
			".db_round($rv_item_comp_amt_nett,2).",
			".db_round($rv_item_comp_amt_comm,2).",
			".db_round($rv_item_comp_amt_comm_calc,2).",
			".db_round($rv_item_comp_amt_tax,2).",
			".db_round($rv_item_comp_amt_payable,2)."
			$extraValues
		)
	");

	$rv_res_item_comp_id = $lDB->insert_id;
	
	return $rv_res_item_comp_id;
}

function db_rv_res_item_comp_update($rv_res_item_comp_id,$rv_item_comp_amt_gross,$rv_item_comp_amt_nett,$rv_item_comp_amt_comm,$rv_item_comp_amt_comm_calc,$rv_item_comp_amt_tax,$rv_item_comp_amt_payable,$rv_item_comp_var,$rv_item_comp_amt_sp_discount) {
	global $lDB;

	$lDB->put("
		UPDATE rv_res_item_comp SET
			rv_item_comp_amt_gross = ".db_round($rv_item_comp_amt_gross,2).",
			rv_item_comp_amt_nett = ".db_round($rv_item_comp_amt_nett,2).",
			rv_item_comp_amt_comm = ".db_round($rv_item_comp_amt_comm,2).",
			rv_item_comp_amt_comm_calc = ".db_round($rv_item_comp_amt_comm_calc,2).",
			rv_item_comp_amt_tax = ".db_round($rv_item_comp_amt_tax,6).",
			rv_item_comp_amt_payable = ".db_round($rv_item_comp_amt_payable,2).",
			rv_item_comp_var = ".db_round($rv_item_comp_var,2).",
			rv_item_comp_amt_sp_discount = ".db_round($rv_item_comp_amt_sp_discount,2)."
		WHERE
			rv_res_item_comp.rv_res_item_comp_ix = '$rv_res_item_comp_id'
	");	
}

function db_rv_res_item_comp_set_invoice($rv_res_item_comp_id, $fn_invoice_item_id, $fn_invoice_id=false) {
	global $lDB;

	$rv_reservation_item_id = $lDB->get("SELECT rv_reservation_item_id FROM rv_res_item_comp WHERE rv_res_item_comp_ix = '$rv_res_item_comp_id'",4);
	if($fn_invoice_id === false) {
		$fn_invoice_id = $lDB->get("SELECT fn_invoice_id FROM fn_invoice_item WHERE fn_invoice_item_ix = '$fn_invoice_item_id'",4);
	}

	$lDB->put("UPDATE rv_reservation_item SET fn_invoice_id = '".$lDB->escape($fn_invoice_id)."' WHERE rv_reservation_item_ix = '$rv_reservation_item_id'");
	$lDB->put("UPDATE rv_res_item_comp SET fn_invoice_item_id = '".$lDB->escape($fn_invoice_item_id)."' WHERE rv_res_item_comp_ix = '$rv_res_item_comp_id'");
}

function db_rv_res_item_comp_delete($rv_res_item_comp_id) {
	global $lDB;

	if(db_rv_res_item_comp_exists($rv_res_item_comp_id)) {
		$lDB->put("DELETE FROM rv_res_item_comp WHERE rv_res_item_comp.rv_res_item_comp_ix = '$rv_res_item_comp_id'");
		return true;
	} else {
		return false;
	}
}

function db_rv_res_item_comp_delete_by_item($rv_reservation_item_id) {
	global $lDB;

	$list = $lDB->get("SELECT rv_res_item_comp_ix FROM rv_res_item_comp WHERE rv_reservation_item_id = '$rv_reservation_item_id'",3);
	foreach($list as $rv_res_item_comp_id) {
		db_rv_res_item_comp_delete($rv_res_item_comp_id);
		db_rv_res_item_comp_tax_delete_by_comp($rv_res_item_comp_id);
		db_rv_res_item_comp_rate_grp_delete_by_comp($rv_res_item_comp_id);
	}
}

function db_rv_res_item_comp_set_comm($rv_res_item_comp_id,$rv_item_comp_amt_comm) {
	global $lDB;

	$lDB->put("
		UPDATE rv_res_item_comp SET
			rv_item_comp_amt_comm = ".db_round($rv_item_comp_amt_comm,2)."
		WHERE
			rv_res_item_comp.rv_res_item_comp_ix = '$rv_res_item_comp_id'
	");	
	
	db_rv_res_item_comp_recalc($rv_res_item_comp_id);
}

function db_rv_res_item_comp_recalc($rv_res_item_comp_id) {
	global $lDB;

	$component = $lDB->get("
		SELECT 
			rv_reservation.rv_commission_deduct_yn,
			rv_res_item_comp.rv_item_comp_amt_comm,
			rv_res_item_comp.rv_item_comp_amt_gross
		FROM 
			rv_reservation
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
			INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
		WHERE 
			rv_res_item_comp.rv_res_item_comp_ix = '$rv_res_item_comp_id'
	",1);
	
	$rv_item_comp_amt_nett = $component['rv_item_comp_amt_gross'] - $component['rv_item_comp_amt_comm'];

	if ($component['rv_commission_deduct_yn'] == "1"){
		$rv_item_comp_amt_payable = $rv_item_comp_amt_nett;
	} else {
		$rv_item_comp_amt_payable = $component['rv_item_comp_amt_gross'];
	}
	
	$lDB->put("
		UPDATE rv_res_item_comp SET
			rv_item_comp_amt_nett = ".db_round($rv_item_comp_amt_nett,2).",
			rv_item_comp_amt_payable = ".db_round($rv_item_comp_amt_payable,2).",
			rv_item_comp_amt_nett = ".db_round($rv_item_comp_amt_nett,2).",
			rv_item_comp_amt_payable = ".db_round($rv_item_comp_amt_payable,2)."
		WHERE
			rv_res_item_comp.rv_res_item_comp_ix = '$rv_res_item_comp_id'
	");	
}

function db_rv_res_item_comp_set_variance_by_res_exchg_rate($rv_reservation_id, $exchg_rate){
	global $lDB;

	$components = $GLOBALS['lDB']->get("
		SELECT
			rv_res_item_comp_ix,
			rv_item_comp_var
		FROM
			rv_res_item_comp
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$rv_reservation_id'
	",2);

	foreach ($components as $component){
		$newVariance = $component['rv_item_comp_var'] * $exchg_rate;
		$lDB->put("
			UPDATE rv_res_item_comp SET
				rv_item_comp_var = ".db_round($newVariance,2)."
			WHERE
				rv_res_item_comp.rv_res_item_comp_ix = '".$component['rv_res_item_comp_ix']."'
		");			

		// Update each rate group record too
		db_rv_res_item_comp_rate_group_set_variance_by_comp_exchg_rate($component['rv_res_item_comp_ix'], $exchg_rate);
	}
}

function db_rv_res_item_comp_by_reservation($rv_reservation_id) {
	global $lDB;

	$res_item_comps = $lDB->get("
		SELECT
			rv_res_item_comp.rv_res_item_comp_ix
		FROM
			rv_res_item_comp
			LEFT JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
		WHERE
			rv_reservation_item.rv_reservation_id = '".$rv_reservation_id."'
	",3);
	return $res_item_comps;
}

function db_rv_res_item_comp_by_reservation_item($rv_reservation_item_id) {
	global $lDB;

	$res_item_comps = $lDB->get("
		SELECT
			rv_res_item_comp.rv_res_item_comp_ix
		FROM
			rv_res_item_comp
		WHERE
			rv_reservation_item_id = '".$rv_reservation_item_id."'
	",3);
	return $res_item_comps;
}

function db_rv_res_item_comp_set_discount($rv_res_item_comp_ix, $rv_item_comp_amt_sp_discount) {
	global $lDB;

	$rv_res_item_comp_set = $lDB->put("
		UPDATE
			rv_res_item_comp
		SET
			rv_item_comp_amt_sp_discount = ".$rv_item_comp_amt_sp_discount."
		WHERE
			rv_res_item_comp_ix = '".$rv_res_item_comp_ix."'
	");
	return true;
}

function db_rv_res_item_comp_set_discount_by_reservation($rv_reservation_id) {
	
	$rate_comps = db_rv_res_item_comp_by_reservation($rv_reservation_id);
	
	foreach ($rate_comps as $rv_res_item_comp_ix) {
		db_rv_res_item_comp_set_discount($rv_res_item_comp_ix,0);
	}
}
