<?php

require_once(__DIR__ . "/db.rv_res_item_comp.php");

function db_rv_res_item_comp_rate_grp_exists($rv_res_item_comp_rate_grp_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(rv_res_item_comp_rate_grp_ix) FROM rv_res_item_comp_rate_grp WHERE rv_res_item_comp_rate_grp_ix = '$rv_res_item_comp_rate_grp_id'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_rv_res_item_comp_rate_grp_insert($rv_res_item_comp_id, $rt_rate_group_id, $rv_item_comp_rate_grp_rate, $rv_item_comp_rate_grp_rate_comm, $rv_item_comp_rate_grp_amt_gross, $rv_item_comp_rate_grp_amt_nett, $rv_item_comp_rate_grp_amt_comm, $rv_item_comp_rate_grp_amt_add_comm, $rv_item_comp_rate_grp_amt_tax, $rv_item_comp_rate_grp_amt_payable, $rv_item_comp_rate_grp_amt_var, $db_code=false) {
	global $lDB;

	if(!db_rv_res_item_comp_exists($rv_res_item_comp_id)) {
		return false;
	}

	if($db_code === false) {
		$db_code = $GLOBALS['dbcode'];
	}	
	
	$lDB->put("
		INSERT INTO rv_res_item_comp_rate_grp (
			rv_res_item_comp_rate_grp_db,
			rv_res_item_comp_id,
			rt_rate_group_id,
			rv_item_comp_rate_grp_rate,
			rv_item_comp_rate_grp_rate_comm,
			rv_item_comp_rate_grp_amt_gross,
			rv_item_comp_rate_grp_amt_nett,
			rv_item_comp_rate_grp_amt_comm,
			rv_item_comp_rate_grp_amt_add_comm,			
			rv_item_comp_rate_grp_amt_tax,
			rv_item_comp_rate_grp_amt_payable,
			rv_item_comp_rate_grp_amt_var
		) VALUES (
			'".$lDB->escape($db_code)."',
			'".$lDB->escape($rv_res_item_comp_id)."',
			'".$lDB->escape($rt_rate_group_id)."',
			".db_round($rv_item_comp_rate_grp_rate,2).",
			".db_round($rv_item_comp_rate_grp_rate_comm,2).",
			".db_round($rv_item_comp_rate_grp_amt_gross,2).",
			".db_round($rv_item_comp_rate_grp_amt_nett,2).",
			".db_round($rv_item_comp_rate_grp_amt_comm,2).",
			".db_round($rv_item_comp_rate_grp_amt_add_comm,2).",
			".db_round($rv_item_comp_rate_grp_amt_tax,6).",
			".db_round($rv_item_comp_rate_grp_amt_payable,2).",
			".db_round($rv_item_comp_rate_grp_amt_var,2)."
		)
	");

	$rv_res_item_comp_rate_grp_id = $lDB->insert_id;

	return $rv_res_item_comp_rate_grp_id;
}

function db_rv_res_item_comp_rate_grp_update($rv_res_item_comp_rate_grp_id, $rv_item_comp_rate_grp_rate, $rv_item_comp_rate_grp_rate_comm, $rv_item_comp_rate_grp_amt_gross, $rv_item_comp_rate_grp_amt_nett, $rv_item_comp_rate_grp_amt_comm, $rv_item_comp_rate_grp_amt_add_comm, $rv_item_comp_rate_grp_amt_tax, $rv_item_comp_rate_grp_amt_payable, $rv_item_comp_rate_grp_amt_var, $rv_item_comp_rate_grp_amt_sp_discount) {
	global $lDB;

	if ($rv_item_comp_rate_grp_rate === false){
		$rate_grp_rate = "";
	} else {
		$rate_grp_rate = "rv_item_comp_rate_grp_rate = ".db_round($rv_item_comp_rate_grp_rate,2).",";
	}

	if ($rv_item_comp_rate_grp_rate_comm === false){
		$rate_grp_rate_comm = "";
	} else {
		$rate_grp_rate_comm = "rv_item_comp_rate_grp_rate_comm = ".db_round($rv_item_comp_rate_grp_rate_comm,2).",";
	}

	$lDB->put("
		UPDATE rv_res_item_comp_rate_grp SET
			$rate_grp_rate
			$rate_grp_rate_comm
			rv_item_comp_rate_grp_amt_gross = ".db_round($rv_item_comp_rate_grp_amt_gross,2).",
			rv_item_comp_rate_grp_amt_nett = ".db_round($rv_item_comp_rate_grp_amt_nett,2).",
			rv_item_comp_rate_grp_amt_comm = ".db_round($rv_item_comp_rate_grp_amt_comm,2).",
			rv_item_comp_rate_grp_amt_add_comm = ".db_round($rv_item_comp_rate_grp_amt_add_comm,2).",
			rv_item_comp_rate_grp_amt_tax = ".db_round($rv_item_comp_rate_grp_amt_tax,6).",
			rv_item_comp_rate_grp_amt_payable = ".db_round($rv_item_comp_rate_grp_amt_payable,2).",
			rv_item_comp_rate_grp_amt_var = ".db_round($rv_item_comp_rate_grp_amt_var,2).",
			rv_item_comp_rate_grp_amt_sp_discount = ".db_round($rv_item_comp_rate_grp_amt_sp_discount,2)."
		WHERE
			rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix = '$rv_res_item_comp_rate_grp_id'
	");	
}

function db_rv_res_item_comp_rate_grp_set_variance($rv_res_item_comp_rate_grp_id, $rv_item_comp_rate_grp_amt_var) {
	global $lDB;

	$lDB->put("
		UPDATE rv_res_item_comp_rate_grp SET
			rv_item_comp_rate_grp_amt_var = ".db_round($rv_item_comp_rate_grp_amt_var,2)."
		WHERE
			rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix = '$rv_res_item_comp_rate_grp_id'
	");	
}

function db_rv_res_item_comp_rate_grp_delete($rv_res_item_comp_rate_grp_id) {
	global $lDB;

	if(db_rv_res_item_comp_rate_grp_exists($rv_res_item_comp_rate_grp_id)) {
		$lDB->put("DELETE FROM rv_res_item_comp_rate_grp WHERE rv_res_item_comp_rate_grp_ix = '$rv_res_item_comp_rate_grp_id'");
		return true;
	} else {
		return false;
	}
}


function db_rv_res_item_comp_rate_grp_delete_by_comp($rv_res_item_comp_id) {
	global $lDB;
	
	$comp_rate_grps = $lDB->get("
		SELECT 
			rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix
		FROM
			rv_res_item_comp_rate_grp 
		WHERE 
			rv_res_item_comp_rate_grp.rv_res_item_comp_id = '$rv_res_item_comp_id'
	",3);
	
	foreach($comp_rate_grps as $rv_res_item_comp_rate_grp_id) {
		db_rv_res_item_comp_rate_grp_delete($rv_res_item_comp_rate_grp_id);
	}
	
	return true;

}

function db_rv_res_item_comp_rate_grp_set_comm($rv_res_item_comp_rate_grp_ix,$rv_item_comp_rate_grp_amt_comm) {
	global $lDB;

	$lDB->put("
		UPDATE rv_res_item_comp_rate_grp SET
			rv_item_comp_rate_grp_amt_comm = ".db_round($rv_item_comp_rate_grp_amt_comm,2)."
		WHERE
			rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix = '$rv_res_item_comp_rate_grp_ix'
	");	
	
	db_rv_res_item_comp_rate_grp_recalc($rv_res_item_comp_rate_grp_ix);
}

function db_rv_res_item_comp_rate_grp_recalc($rv_res_item_comp_rate_grp_ix) {
	global $lDB;

	$component = $lDB->get("
		SELECT 
			rv_reservation.rv_commission_deduct_yn,
			rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_comm,
			rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_amt_gross
		FROM 
			rv_res_item_comp_rate_grp
			INNER JOIN rv_res_item_comp ON rv_res_item_comp_rate_grp.rv_res_item_comp_id = rv_res_item_comp.rv_res_item_comp_ix
			INNER JOIN rv_reservation_item ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			INNER JOIN rv_reservation ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
		WHERE 
			rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix = '$rv_res_item_comp_rate_grp_ix'	
	",1);
	
	$rv_item_comp_rate_grp_amt_nett = $component['rv_item_comp_rate_grp_amt_gross'] - $component['rv_item_comp_rate_grp_amt_comm'];

	if ($component['rv_commission_deduct_yn'] == "1"){
		$rv_item_comp_rate_grp_amt_payable = $rv_item_comp_rate_grp_amt_nett;
	} else {
		$rv_item_comp_rate_grp_amt_payable = $component['rv_item_comp_rate_grp_amt_gross'];
	}
	
	$lDB->put("
		UPDATE rv_res_item_comp_rate_grp SET
			rv_item_comp_rate_grp_amt_nett = ".db_round($rv_item_comp_rate_grp_amt_nett,2).",
			rv_item_comp_rate_grp_amt_payable = ".db_round($rv_item_comp_rate_grp_amt_payable,2)."
		WHERE
			rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix = '$rv_res_item_comp_rate_grp_ix'
	");	
}

function db_rv_res_item_comp_rate_group_set_variance_by_comp_exchg_rate($rv_res_item_comp_id, $exchg_rate){
	global $lDB;

	$componentRateGroups = $GLOBALS['lDB']->get("
		SELECT
			rv_res_item_comp_rate_grp_ix,
			rv_item_comp_rate_grp_amt_var
		FROM
			rv_res_item_comp_rate_grp
		WHERE
			rv_res_item_comp_rate_grp.rv_res_item_comp_id = '$rv_res_item_comp_id'
	",2);

	foreach ($componentRateGroups as $componentRateGroup){
		$newVariance = $componentRateGroup['rv_item_comp_rate_grp_amt_var'] * $exchg_rate;
		$lDB->put("
			UPDATE rv_res_item_comp_rate_grp SET
				rv_item_comp_rate_grp_amt_var = ".db_round($newVariance,2)."
			WHERE
				rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix = '".$componentRateGroup['rv_res_item_comp_rate_grp_ix']."'
		");			
	}
}

function db_rv_res_item_comp_rate_grp_set_discount($rv_res_item_comp_rate_grp_ix, $rv_item_comp_rate_grp_amt_sp_discount) {
	global $lDB;

	$rv_res_item_comp_rate_grp_set = $lDB->put("
		UPDATE
			rv_res_item_comp_rate_grp
		SET
			rv_item_comp_rate_grp_amt_sp_discount = ".$rv_item_comp_rate_grp_amt_sp_discount."
		WHERE
			rv_res_item_comp_rate_grp_ix = '".$rv_res_item_comp_rate_grp_ix."'
	");
	return true;
}

function db_rv_res_item_comp_rate_grp_by_reservation($rv_reservation_id) {
	global $lDB;

	$res_item_comp_rate_grps = $lDB->get("
		SELECT
			rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix
		FROM
			rv_res_item_comp_rate_grp
			LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_res_item_comp_ix = rv_res_item_comp_rate_grp.rv_res_item_comp_id
			LEFT JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
		WHERE
			rv_reservation_item.rv_reservation_id = '".$rv_reservation_id."'
	",3);
	return $res_item_comp_rate_grps;
}

function db_rv_res_item_comp_rate_grp_by_res_item_comp($rv_res_item_comp_id) {
	global $lDB;

	$res_item_comp_rate_grps = $lDB->get("
		SELECT
			rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix
		FROM
			rv_res_item_comp_rate_grp
		WHERE
			rv_res_item_comp_id = '".$rv_res_item_comp_id."'
	",3);
	return $res_item_comp_rate_grps;
}

function db_rv_res_item_comp_rate_grp_set_discount_by_reservation($rv_reservation_id) {
	
	$rate_groups = db_rv_res_item_comp_rate_grp_by_reservation($rv_reservation_id);

	foreach ($rate_groups as $rv_res_item_comp_rate_grp_ix) {
		db_rv_res_item_comp_rate_grp_set_discount($rv_res_item_comp_rate_grp_ix,0);
	}
}
