<?php

require_once(__DIR__ . "/functions.reservation.php");

function db_rv_res_item_group_exists($rv_res_item_group_id) {
	$count = $GLOBALS['lDB']->get("SELECT COUNT(rv_res_item_group_id) FROM rv_res_item_group WHERE rv_res_item_group_ix = '$rv_res_item_group_id'",4);
	if($count > 0) {
		return true;
	} else {
		return false;
	}
}

function db_rv_res_item_group_count_by_item($rv_reservation_item_id) {
	$count = $GLOBALS['lDB']->get("
		SELECT
			COUNT(rv_res_item_group.rv_res_item_group_id)
		FROM
			rv_res_item_group
		WHERE
			rv_res_item_group.rv_reservation_item_id = '$rv_reservation_item_id'
	",4);
	return $count;
}

function db_rv_reservation_item_select_accomm_count($rv_reservation_item_id) {
	$count = $GLOBALS['lDB']->get("
		SELECT
			rv_item_accomm_count
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item_ix = '$rv_reservation_item_id'
	",4);
	return $count;
}

function db_rv_reservation_item_select_item_id($rv_res_item_group_id) {
	$itemId = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation_item_id
		FROM
			rv_res_item_group
		WHERE
			rv_res_item_group.rv_res_item_group_ix = '$rv_res_item_group_id'
	",4);
	return $itemId;
}

function db_rv_res_item_group_by_reservation($rv_reservation_id) {
	$rv_res_item_groups = $GLOBALS['lDB']->get("
		SELECT
			rv_res_item_group.rv_res_item_group_ix,
			rv_res_item_group.rv_reservation_item_id,
			ac_accomm_room.ac_desc
		FROM
			rv_res_item_group
			LEFT JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		WHERE
			rv_reservation_item.rv_reservation_id = '" . $rv_reservation_id . "'
	",2);
	return $rv_res_item_groups;
}

function db_rv_res_item_group_insert($rv_reservation_item_id, $ac_accomm_room_id = "", $rv_room_requested_yn = "0", $rv_room_request_reason = "", $rv_grp_status_ind="2" ) {
	global $lDB;
	if( db_rv_res_item_group_count_by_item($rv_reservation_item_id) >= db_rv_reservation_item_select_accomm_count($rv_reservation_item_id) ) {
		return false;
	}
	$ac_accomm_type_id = $lDB->get("SELECT ac_accomm_type_id FROM ac_accomm_room WHERE ac_accomm_room_ix = '$ac_accomm_room_id'",4);
	$overideCheck = $lDB->get("
		SELECT
			rv_reservation_item.ac_accomm_type_id
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_item_ix = '$rv_reservation_item_id'
	",4);
	if($ac_accomm_type_id != $overideCheck) {
		$rv_grp_accomm_overide_yn = "1";
	} else {
		$rv_grp_accomm_overide_yn = "0";
	}

	$lDB->put("
		INSERT INTO rv_res_item_group (
			rv_res_item_group_db,
			rv_res_item_group_id,
			rv_reservation_item_id,
			ac_accomm_room_id,
			rv_room_requested_yn,
			rv_room_request_reason,
			rv_grp_status_ind,
			ac_accomm_type_id,
			rv_grp_accomm_overide_yn,
			rv_grp_date_allocated
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'',
			'".$lDB->escape($rv_reservation_item_id)."',
			'".$lDB->escape($ac_accomm_room_id)."',
			'".$lDB->escape($rv_room_requested_yn)."',
			'".$lDB->escape($rv_room_request_reason)."',
			'".$lDB->escape($rv_grp_status_ind)."',
			'".$lDB->escape($ac_accomm_type_id)."',
			'".$lDB->escape($rv_grp_accomm_overide_yn)."',
			'".date("Y-m-d")."'
		)
	",1);

	$rv_res_item_group_id = $lDB->insert_id;

	// Check reservation folio level
	$resInfo = $lDB->get("
		SELECT
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_folio_level_ind,
			rv_reservation_item.pr_business_id,
			rv_reservation.rv_invoice_persona_id
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		WHERE
			rv_reservation_item.rv_reservation_item_ix = '$rv_reservation_item_id'
	",1);

	$businessId = "";
	$currId = $resInfo['pr_business_id'];
	while($businessId == "" && $currId != "0" && trim($currId) != "") {
		$billingYN = $lDB->get("SELECT pr_bus_billing_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
		if($billingYN == "1") {
			$businessId = $currId;
		} else {
			$currId = $lDB->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
		}
	}
	if($businessId == "" || $businessId == "0") {
		debug("ERROR - No billing entity found, please contact your system administrator!");
		die();
		return false;
	}

	$rf_currency_id = $lDB->get("SELECT pr_bus_home_curr_id FROM pr_business WHERE pr_business_id = '$businessId'",4);

	return $rv_res_item_group_id;
}

function db_rv_res_item_group_delete($rv_res_item_group_id) {
	$GLOBALS['lDB']->put("DELETE FROM rv_res_item_group WHERE rv_res_item_group_ix = '$rv_res_item_group_id'");
}

function db_rv_res_item_group_delete_by_item($rv_reservation_item_id) {
	$list = $GLOBALS['lDB']->get("SELECT rv_res_item_group_ix FROM rv_res_item_group WHERE rv_reservation_item_id = '$rv_reservation_item_id'",3);
	foreach($list as $item) {
		db_rv_res_item_group_delete($item);
	}
}

function db_rv_res_item_group_delete_by_reservation($rv_reservation_id) {
	$list = $GLOBALS['lDB']->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE rv_reservation_id = '$rv_reservation_id'",3);
	foreach($list as $item) {
		db_rv_res_item_group_delete_by_item($item);
	}
}

/*
	Status levels:

	2 (default): Not checked in, still awaiting arrival
	5: Checked in, awaiting checkout
	8: Checked out
*/
function db_rv_res_item_group_set_status($rv_res_item_group_id,$rv_grp_status_ind,$rv_grp_status_time=false) {
	global $lDB;
	$resItemDate = $lDB->get("
		SELECT
			rv_item_date_arrive,
			rv_item_date_depart,
			rv_reservation_id
		FROM
			rv_res_item_group
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
		WHERE
			rv_res_item_group.rv_res_item_group_ix = '$rv_res_item_group_id'
	",1);
	if($rv_grp_status_time !== false && $rv_grp_status_ind == '8') {
		if($resItemDate['rv_item_date_arrive'] > $rv_grp_status_time) {
			$rv_grp_status_time = $resItemDate['rv_item_date_depart'];
		}
		$timeStamp = $rv_grp_status_time . " 00:00:00";
	} else if($resItemDate['rv_item_date_arrive'] >= date("Y-m-d") && $rv_grp_status_ind == '8') {
		$timeStamp = $resItemDate['rv_item_date_depart'];
	} else {
		$timeStamp = date("Y-m-d H:i:s");
	}
	$timeZone = date("e");
	if($rv_grp_status_ind == '5') {
		ammendReservation($resItemDate['rv_reservation_id'],"Check in");
	}
	if($rv_grp_status_ind == '8') {
		if($resItemDate['rv_item_date_depart'] > date("Y-m-d")) {
			ammendReservation($resItemDate['rv_reservation_id'],"Check out (EARLY)");
		} else {
			ammendReservation($resItemDate['rv_reservation_id'],"Check out");
		}
	}
	$lDB->put("
		INSERT INTO rv_res_item_grp_status (
			rv_res_item_grp_status_db,
			rv_grp_status_ind,
			rv_grp_status_time,
			rv_grp_status_time_tz,
			rv_res_item_group_id
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'".$lDB->escape($rv_grp_status_ind)."',
			'".$lDB->escape($timeStamp)."',
			'".$lDB->escape($timeZone)."',
			'".$lDB->escape($rv_res_item_group_id)."'
		)
	");
	$lDB->put("
		UPDATE rv_res_item_group SET
			rv_grp_status_ind = '".$lDB->escape($rv_grp_status_ind)."',
			rv_grp_status_time = '".$lDB->escape($timeStamp)."',
			rv_grp_status_time_tz = '".$lDB->escape($timeZone)."'
		WHERE
			rv_res_item_group_ix = '$rv_res_item_group_id'
	");
}

function db_rv_res_item_group_set_room($rv_res_item_group_id, $ac_accomm_room_id, $rv_room_requested_yn="0", $rv_room_request_reason="") {
	global $lDB;

	$ac_accomm_type_id = $lDB->get("SELECT ac_accomm_type_id FROM ac_accomm_room WHERE ac_accomm_room_ix = '$ac_accomm_room_id'",4);
	$overideCheck = $lDB->get("
		SELECT
			rv_reservation_item.ac_accomm_type_id
		FROM
			rv_res_item_group
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
		WHERE
			rv_res_item_group.rv_res_item_group_ix = '$rv_res_item_group_id'
	",4);
	if($ac_accomm_type_id != $overideCheck) {
		$rv_grp_accomm_overide_yn = "1";
	} else {
		$rv_grp_accomm_overide_yn = "0";
	}

	$lDB->put("
		UPDATE
			rv_res_item_group
		SET
			ac_accomm_room_id = '".$lDB->escape($ac_accomm_room_id)."',
			ac_accomm_type_id = '".$lDB->escape($ac_accomm_type_id)."',
			rv_room_requested_yn = '".$lDB->escape($rv_room_requested_yn)."',
			rv_room_request_reason = '".$lDB->escape($rv_room_request_reason)."',
			rv_grp_accomm_overide_yn = '".$lDB->escape($rv_grp_accomm_overide_yn)."',
			rv_grp_date_allocated = '".date("Y-m-d")."'
		WHERE
			rv_res_item_group.rv_res_item_group_ix = '$rv_res_item_group_id'
	");
}
