<?php

function db_rv_res_item_guest_exists($rv_res_item_guest_id) {
	$count = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM rv_res_item_guest WHERE rv_res_item_guest_ix = '$rv_res_item_guest_id'",4);
	if($count > 0) {
		return true;
	} else {
		return false;
	}
}

function db_rv_res_item_guest_exists_by_item($pr_guest_id, $rv_reservation_item_id) {
	$count = $GLOBALS['lDB']->get("
		SELECT
			count(rv_res_item_guest_id)
		FROM
			rv_res_item_guest
		WHERE
			pr_guest_id = '$pr_guest_id'
			AND rv_reservation_item_id = '$rv_reservation_item_id'
	",4);
	  
	if($count > 0) {
		return true;
	} else {
		return false;
	}
}

function db_rv_res_item_guests_by_item($rv_reservation_item_id) {
	$guests = $GLOBALS['lDB']->get("
		SELECT
			rv_res_item_guest.rv_res_item_guest_ix,
			pr_persona.pr_name_first,
			pr_persona.pr_name_last
		FROM
			rv_res_item_guest
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
		WHERE
			rv_reservation_item_id = '$rv_reservation_item_id'
	",2);
	return $guests;
}

function db_rv_res_item_guest_insert($pr_guest_id, $rv_res_item_group_id) {
	if ($rv_res_item_group_id == "" || is_null($rv_res_item_group_id)) {
		return false;
	}
	global $lDB;
	$itemId = db_rv_reservation_item_select_item_id($rv_res_item_group_id);
	if(db_rv_res_item_guest_exists_by_item($pr_guest_id, $itemId)) {
		return false;
	}

	$maxOccupants = $GLOBALS['lDB']->get("
		SELECT
			rv_reservation_item.rv_item_adult_count + rv_reservation_item.rv_item_child_count
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_item_ix = '$itemId'
	",4);

	$currentOccupants = $GLOBALS['lDB']->get("
		SELECT
			COUNT(rv_res_item_guest_ix)
		FROM
			rv_res_item_guest
		WHERE
		rv_res_item_group_id = '$rv_res_item_group_id'
	",4);

	if ($currentOccupants >= $maxOccupants) {
		return false;
	}

	$lDB->put("
		INSERT INTO rv_res_item_guest (
			rv_res_item_guest_db,
			rv_res_item_guest_id,
			pr_guest_id,
			rv_res_item_group_id,
			rv_reservation_item_id
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'',
			'".$lDB->escape($pr_guest_id)."',
			'".$lDB->escape($rv_res_item_group_id)."',
			'".$lDB->escape($itemId)."'
		)
	");
	return $lDB->insert_id;
}

function db_rv_res_item_guest_delete($rv_res_item_guest_id) {
	$GLOBALS['lDB']->put("DELETE FROM rv_res_item_guest WHERE rv_res_item_guest_ix = '$rv_res_item_guest_id'");
}

function db_rv_res_item_guest_delete_by_group($rv_res_item_group_id) {
	$list = $GLOBALS['lDB']->get("
		SELECT
			rv_res_item_guest_ix
		FROM
			rv_res_item_guest
		WHERE
			rv_res_item_group_id = '$rv_res_item_group_id'
	",3);
	foreach($list as $item) {
		db_rv_res_item_guest_delete($item);
	}
}

function db_rv_res_item_guest_delete_by_guest($pr_guest_id, $rv_reservation_id) {
	$list = $GLOBALS['lDB']->get("
		SELECT
			rv_res_item_guest_ix
		FROM
			rv_res_item_guest
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_guest.rv_reservation_item_id
		WHERE
			rv_res_item_guest.pr_guest_id = '$pr_guest_id'
			AND rv_reservation_item.rv_reservation_id = '$rv_reservation_id'
	",3);
	foreach($list as $item) {
		db_rv_res_item_guest_delete($item);
	}
}

function db_rv_res_item_guest_delete_by_reservation($rv_reservation_id) {
	// Remove all guests from reservation
	$list = $GLOBALS['lDB']->get("
		SELECT
			rv_res_item_guest_ix
		FROM
			rv_res_item_guest
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_guest.rv_reservation_item_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$rv_reservation_id'
	",3);
	foreach($list as $item) {
		db_rv_res_item_guest_delete($item);
	}
}

function db_rv_res_item_guest_delete_by_group_guest($pr_guest_id, $rv_res_item_group_id) {
	$list = $GLOBALS['lDB']->get("
		SELECT
			rv_res_item_guest_ix
		FROM
			rv_res_item_guest
		WHERE
			pr_guest_id = '$pr_guest_id'
			AND rv_res_item_group_id = '$rv_res_item_group_id'
	",3);
	foreach($list as $item) {
		db_rv_res_item_guest_delete($item);
	}
}

function db_rv_res_item_guest_set_group($rv_res_item_guest_id, $rv_res_item_group_id) {
	global $lDB;
	if(!db_rv_res_item_guest_exists($rv_res_item_guest_id)) {
		return false;
	}
	$lDB->put("
		UPDATE 
			rv_res_item_guest 
		SET
			rv_res_item_group_id = '".$lDB->escape($rv_res_item_group_id)."'
		WHERE 
			rv_res_item_guest_ix = '$rv_res_item_guest_id'
	");		
}

function db_rv_res_item_guest_set_reservation_item($rv_res_item_guest_id, $rv_reservation_item_id) {
	global $lDB;
	if(!db_rv_res_item_guest_exists($rv_res_item_guest_id)) {
		return false;
	}
	$lDB->put("
		UPDATE 
			rv_res_item_guest 
		SET 
			rv_reservation_item_id = '".$lDB->escape($rv_reservation_item_id)."'
		WHERE 
			rv_res_item_guest_ix = '$rv_res_item_guest_id'
	");
}

function db_rv_res_item_guest_exists_by_guest_group($pr_guest_id, $rv_res_item_group_id) {
	$rv_res_item_guest_id = $GLOBALS['lDB']->get("
		SELECT
			rv_res_item_guest_ix
		FROM
			rv_res_item_guest 
		WHERE 
			rv_res_item_group_id = '$rv_res_item_group_id'
			AND rv_res_item_guest.pr_guest_id = '$pr_guest_id' 
	", 4);

	return $rv_res_item_guest_id;
}
