<?php

require_once(__DIR__ . "/db.rv_reservation.php");
require_once(__DIR__ . "/db.rv_reservation_item.php");
require_once(__DIR__ . "/db.sp_special.php");

function db_rv_res_item_special_exists($rv_res_item_special_id) {
	global $lDB;

	$count = $lDB->get("
		SELECT COUNT(rv_res_item_special_ix) FROM rv_res_item_special WHERE rv_res_item_special_ix = '" . $lDB->escape($rv_res_item_special_id) . "'
	",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_rv_res_item_special_insert($rv_reservation_item_id, $sp_special_id, $rv_sp_amt_discount) {
	global $lDB;
	global $dbcode;

	if(!db_rv_reservation_item_exists($rv_reservation_item_id)) {
		return false;
	}

	if(!db_sp_special_exists($sp_special_id)) {
		return false;
	}

	$lDB->put("
		INSERT INTO rv_res_item_special (
			rv_res_item_special_db,
			rv_reservation_item_id,
			sp_special_id,
			rv_sp_amt_discount
		) VALUES (
			'" . $lDB->escape($dbcode) . "',
			'" . $lDB->escape($rv_reservation_item_id) . "',
			'" . $lDB->escape($sp_special_id) . "',
			'" . $lDB->escape($rv_sp_amt_discount) . "'
		)
	");

	$rv_res_item_special_id = $lDB->insert_id;

	return $rv_res_item_special_id;
}

function db_rv_res_item_special_delete($rv_res_item_special_id) {
	global $lDB;

	if(!db_rv_res_item_special_exists($rv_res_item_special_id)) {
		return false;
	}

	$lDB->put("
		DELETE FROM rv_res_item_special WHERE rv_res_item_special_ix = '" . $lDB->escape($rv_res_item_special_id) . "'
	");

	return true;
}

function db_rv_res_item_special_delete_by_reservation($rv_reservation_id) {
	global $lDB;

	if(!db_rv_reservation_exists($rv_reservation_id)) {
		return false;
	}

	$list = $lDB->get("
		SELECT
			rv_res_item_special.rv_res_item_special_ix
		FROM
			rv_res_item_special
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_special.rv_reservation_item_id
		WHERE
			rv_reservation_item.rv_reservation_id = '" . $lDB->escape($rv_reservation_id) . "'
	",3);

	foreach($list as $rv_res_item_special_id) {
		db_rv_res_item_special_delete($rv_res_item_special_id);
	}

	return true;
}
