<?php

/*
 * $Id: db.rv_reservation.php,v 1.16 2013-08-19 17:02:51 light Exp $
 *
 * $Log: db.rv_reservation.php,v $
 * Revision 1.16  2013-08-19 17:02:51  light
 * Bug #8252 - API extensions for TVL
 *
 * Revision 1.15  2012-08-06 16:49:27  light
 * Bug #7998 - Create online payments from API
 *
 */

/**
 * db.rv_reservation.php - Database functions for table rv_reservation
 */

require_once(__DIR__ . "/db.ac_pay_plan.php");
require_once(__DIR__ . "/db.tc_res_update.php");
require_once(__DIR__ . "/db.pr_agent.php");
require_once(__DIR__ . "/db.pr_persona.php");
require_once(__DIR__ . "/db.rf_reservation_status.php");
require_once(__DIR__ . "/db.rt_rate_type.php");
require_once(__DIR__ . "/db.rv_extra.php");
require_once(__DIR__ . "/db.rv_note.php");
require_once(__DIR__ . "/db.rv_res_item_group.php");
require_once(__DIR__ . "/db.rv_res_item_guest.php");

require_once(__DIR__ . "/class.stock.php");
require_once(__DIR__ . '/class.audit.php');

require_once(__DIR__ . "/functions.reservation.php");
require_once(__DIR__ . "/functions.reservation.itinerary.php");

// Folio level indicators
define("DB_RV_FOLIO_LEVEL_BUSINESS",1);
define("DB_RV_FOLIO_LEVEL_GROUP",3);

function db_rv_reservation_exists($rv_reservation_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(rv_reservation_ix) FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_rv_reservation_insert($rt_rate_type_id,$rv_corr_persona_id=false,$rv_agent_id=false,$rv_commission_perc=false,$rv_commission_deduct_yn=false,$rv_invoice_currency_id=false,$rv_billing_persona_id=false,$rv_invoice_persona_id=false,$rv_res_name=false,$rv_agent_ref=false,$rv_note_general=false,$rv_note_guests=false,$rv_note_internal=false,$ac_pay_plan_id=false,$rf_country_id=false,$rf_source_ix=false,$rf_reservation_status_id=false,$rf_reservation_status_date=false,$rv_provision_expiry_date=false,$pr_user_id=false,$rv_consultant_id=false,$rv_date_recorded=false,$rv_date_changed=false,$rv_ref_num=false,$db_code=false,$rv_reservation_id=false,$rv_origin_agent_id=false,$ac_pos_id=false) {

	global $lDB;
	global $userStatusId;
	global $isConsultant;

	if(!db_rt_rate_type_exists($rt_rate_type_id)) {
		return false;
	}

	if($db_code === false) {
		$db_code = $GLOBALS['dbcode'];
	}

    if ($rv_reservation_id !== false && db_rv_reservation_exists($db_code.$rv_reservation_id)) {
        return false;
    }

	$today = date("Y-m-d");

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}
	if($rf_reservation_status_date === false) {
		$rf_reservation_status_date = $today;
	}
	if($rv_date_changed === false) {
		$rv_date_changed = $today;
	}
	if($rv_date_recorded === false) {
		$rv_date_recorded = $today;
	}

	if($rv_invoice_currency_id === false) {
		$rv_invoice_currency_id = $lDB->get("SELECT rf_currency_id FROM rt_rate_type WHERE rt_rate_type_ix = '$rt_rate_type_id'",4);
	}

	if($rv_reservation_id === false) {
		$rv_reservation_id = "";
	}

	$extra = array();

	if($rv_agent_id !== false && db_pr_agent_exists($rv_agent_id)) {
		$extra['rv_agent_id'] = $lDB->escape($rv_agent_id);
		$agentComm = $lDB->get("
			SELECT
				pr_agent_commission_perc,
				pr_agent_comm_deduct_yn,
				ac_pay_plan_id
			FROM
				pr_agent
			WHERE
				pr_agent_id = '$rv_agent_id'
		",1);

		if($rv_commission_perc === false) {
			$extra['rv_commission_perc'] = $lDB->escape($agentComm['pr_agent_commission_perc']);
		} else {
			$extra['rv_commission_perc'] = $lDB->escape($rv_commission_perc);
		}
		if($rv_commission_deduct_yn === false) {
			$extra['rv_commission_deduct_yn'] = $lDB->escape($agentComm['pr_agent_comm_deduct_yn']);
		} else {
			$extra['rv_commission_deduct_yn'] = $lDB->escape($rv_commission_deduct_yn);
		}
		if($ac_pay_plan_id === false && db_ac_pay_plan_exists($agentComm['ac_pay_plan_id'])) {
			$ac_pay_plan_id = $agentComm['ac_pay_plan_id'];
		}
		if($rv_corr_persona_id == "" || $rv_corr_persona_id == "0") {
			if($userStatusId != "1") {
				if ($rv_agent_id != ""){
					$rv_corr_persona_id = $rv_agent_id;
				} else {
					$rv_corr_persona_id = "0";
				}
			} else {
				$rv_corr_persona_id = $GLOBALS['userid'];
			}
		}
	}

	if($rv_corr_persona_id !== false) {
		$extra['rv_corr_persona_id'] = $lDB->escape($rv_corr_persona_id);
	}

	if($rv_billing_persona_id === false) {
		if($rv_corr_persona_id !== false) {
			$rv_billing_persona_id = $rv_corr_persona_id;
		} else {
			if($rv_agent_id !== false) {
				$rv_billing_persona_id = $rv_agent_id;
			}
		}
	}

	if($rv_invoice_persona_id === false) {
		if($rv_agent_id !== false) {
			$rv_invoice_persona_id = $rv_agent_id;
		} else {
			if($rv_corr_persona_id !== false) {
				$rv_invoice_persona_id = $rv_corr_persona_id;
			}
		}
	}

	if($rv_billing_persona_id !== false) {
		$extra['rv_billing_persona_id'] = $lDB->escape($rv_billing_persona_id);
	}
	if($rv_invoice_persona_id !== false) {
		$extra['rv_invoice_persona_id'] = $lDB->escape($rv_invoice_persona_id);
	}
	if($rv_res_name !== false) {
		$extra['rv_res_name'] = $lDB->escape($rv_res_name);
	}
	if($rv_agent_ref !== false) {
		$extra['rv_agent_ref'] = $lDB->escape($rv_agent_ref);
	}
	if($rv_note_general !== false) {
		$extra['rv_note_general'] = $lDB->escape($rv_note_general);
	}
	if($rv_note_guests !== false) {
		$extra['rv_note_guests'] = $lDB->escape($rv_note_guests);
	}
	if($rv_note_internal !== false) {
		$extra['rv_note_internal'] = $lDB->escape($rv_note_internal);
	}
	if($rv_commission_perc !== false) {
		$extra['rv_commission_perc'] = $lDB->escape($rv_commission_perc);
	}
	if($rv_commission_deduct_yn !== false) {
		$extra['rv_commission_deduct_yn'] = $lDB->escape($rv_commission_deduct_yn);
	}
	if($ac_pay_plan_id !== false) {
		$extra['ac_pay_plan_id'] = $lDB->escape($ac_pay_plan_id);
	}
	if($rf_country_id !== false) {
		$extra['rf_country_id'] = $lDB->escape($rf_country_id);
	}
	if($rf_source_ix != false) {
		$extra['rf_source_ix'] = $lDB->escape($rf_source_ix);
	}

	if ($rf_reservation_status_id === false){
		$rf_reservation_status_id = 25;
	}

	if($rf_reservation_status_id == 25) {
		$extra['rv_create_expiry_date'] = $lDB->escape(db_rv_reservation_get_expiry());
	}
	if($rf_reservation_status_id == 30) {
		$extra['rv_confirmation_user_id'] = $lDB->escape($pr_user_id);
		$extra['rv_confirmation_date'] = $lDB->escape($rf_reservation_status_date);
	}
	if($rf_reservation_status_id == 20) {
		$extra['rv_prov_date'] = $lDB->escape($rf_reservation_status_date);
		if($rv_provision_expiry_date !== false) {
			$extra['rv_provision_expiry_date'] = $lDB->escape($rv_provision_expiry_date);
		} else {
			$extra['rv_provision_expiry_date'] = $lDB->escape($today);
		}
	}
	if($rf_reservation_status_id == 10) {
		$extra['rv_wait_list_user_id'] = $lDB->escape($pr_user_id);
		$extra['rv_wait_list_date'] = $lDB->escape($rf_reservation_status_date);
	}

	if ($rv_consultant_id == "none"){
		$extra['rv_consultant_id'] = "";
	} elseif ($rv_consultant_id !== false) {
		$extra['rv_consultant_id'] = $lDB->escape($rv_consultant_id);
	}
	if ($userStatusId > "1" && $isConsultant != "0") {
		if($rv_consultant_id === false) {
			$extra['rv_consultant_id'] = $lDB->escape($GLOBALS['userid']);
		}
		$extra['rv_date_consultant'] = $lDB->escape($today);
	}

	if($rv_ref_num !== false) {
		$extra['rv_ref_num'] = $lDB->escape($rv_ref_num);
	}

	if($ac_pos_id !== false) {
		$extra['ac_pos_id'] = $lDB->escape($ac_pos_id);
	}


	$extraFields = "";
	$extraValues = "";
	if(sizeof($extra) > 0) {
		$extraFields = "," .join(",",array_keys($extra));
		$extraValues = ",'" . join("','",array_values($extra)) . "'";
	}

	$lDB->put("
		INSERT INTO rv_reservation (
			rv_reservation_db,
			rv_reservation_id,
			rt_rate_type_id,
			rv_invoice_currency_id,
			rf_reservation_status_id,
			rv_date_recorded,
			rv_date_changed,
			pr_reservation_user_id
			$extraFields
		) VALUES (
			'".$lDB->escape($db_code)."',
			'".$lDB->escape($rv_reservation_id)."',
			'".$lDB->escape($rt_rate_type_id)."',
			'".$lDB->escape($rv_invoice_currency_id)."',
			'".$lDB->escape($rf_reservation_status_id)."',
			'".$lDB->escape($rv_date_recorded)."',
			'".$lDB->escape($rv_date_changed)."',
			'".$lDB->escape($pr_user_id)."'
			$extraValues
		)
	");
    if ($rv_reservation_id) {
        $lDB->put("UPDATE rv_reservation SET rv_reservation_ix = '{$db_code}{$rv_reservation_id}' WHERE rv_reservation_ix = '$lDB->insert_id'");
        $rv_reservation_id = $db_code.$rv_reservation_id;
    } else {
        $rv_reservation_id = $lDB->insert_id;
    }

	db_rv_extra_delete_by_rv_reservation_id($rv_reservation_id);
	return $rv_reservation_id;
}

function db_rv_reservation_update_paid_amount($rv_reservation_id) {
	global $lDB;

	$oldFlagChngs = $GLOBALS['flagChngs'];
	$GLOBALS['flagChngs'] = "0";

	$total = $lDB->get("SELECT SUM(rv_payment_item_amt) FROM rv_payment_item WHERE rv_payment_item.rv_reservation_id = '$rv_reservation_id'",4);

	$wasMaster = true;
	if ($lDB->isMaster != "1"){
		$lDB->isMaster = "1";
		$wasMaster = false;
	}
	$lDB->put("UPDATE rv_reservation SET rv_amt_paid = '".$lDB->escape($total)."' WHERE rv_reservation_ix = '$rv_reservation_id'");
	if(!$wasMaster) {
		$lDB->isMaster = "0";
	}
	if (isset($record)) {
		db_tc_res_update_insert($record);
	}
	$GLOBALS['flagChngs'] = $oldFlagChngs;

	return $total;
}

function db_rv_reservation_update_travel_dates($rv_reservation_id) {
	global $lDB;

	$dates = $lDB->get("
		SELECT
			MIN(rv_reservation_item.rv_item_date_arrive) as arrive,
			MAX(rv_reservation_item.rv_item_date_depart) as depart
		FROM
			rv_reservation_item
			LEFT JOIN rv_reservation_item as link_item ON link_item.rv_reservation_item_ix = rv_reservation_item.rv_link_res_item_id
		WHERE
			rv_reservation_item.rv_reservation_id = '$rv_reservation_id'
			AND link_item.rv_reservation_item_ix IS NULL
	",1);

	$lDB->put("
		UPDATE
			rv_reservation
		SET
			rv_date_arrive = '".$lDB->escape($dates['arrive'])."',
			rv_date_depart = '".$lDB->escape($dates['depart'])."'
		WHERE
			rv_reservation_ix = '$rv_reservation_id'
	");
}

function db_rv_reservation_get_expiry() {
	global $lDB;
	global $userStatusId;

	$pad = $lDB->get("SELECT rf_res_create_expiry_mins FROM rf_default",4);
	if($userStatusId > 1) {
		$pad = $lDB->get("SELECT rf_res_create_expiry_internal FROM rf_default",4);
	}
	$total = $pad * 60;
	return date("Y-m-d H:i:s",mktime(date("H"),date("i"),date("s")+$total,date("m"),date("d"),date("Y")));
}

function db_rv_reservation_set_expiry($rv_reservation_id) {
	global $lDB;

	$lDB->put("UPDATE rv_reservation SET rv_create_expiry_date = '".$lDB->escape(db_rv_reservation_get_expiry())."' WHERE rv_reservation_ix = '$rv_reservation_id'");

}

function db_rv_reservation_get_status($rv_reservation_id) {
	global $lDB;
	global $userid;

	if(!db_rv_reservation_exists($rv_reservation_id)) {
		return false;
	}

	$rf_reservation_status = $lDB->get("
		SELECT
			rf_reservation_status.rf_reservation_status_desc,
			rf_reservation_status.rf_reservation_status_id
		FROM
			rv_reservation
			INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
		WHERE
			rv_reservation.rv_reservation_ix = '$rv_reservation_id'
	",1);
	return $rf_reservation_status;
}

function db_rv_reservation_set_status($rv_reservation_id,$rf_reservation_status_id,$rv_provision_expiry_date=false,$rv_cancel_reason=false, $checkOverbooking=true) {
	global $lDB;
	global $userid;

	if(!db_rv_reservation_exists($rv_reservation_id)) {
		return false;
	}

	$rf_reservation_status_from = $lDB->get("
		SELECT
			rf_reservation_status.rf_reservation_status_desc,
			rf_reservation_status.rf_reservation_status_id,
			rv_reservation.rv_cancel_date,
			rv_reservation.rv_cancel_reason,
			rv_reservation.rv_cancel_user_id,
			rv_reservation.rv_confirmation_date,
			rv_reservation.rv_confirmation_user_id,
			rv_reservation.rv_date_deleted,
			rv_reservation.rv_date_quote,
			rv_reservation.rv_provision_expiry_date,
			rv_reservation.rv_wait_list_date,
			rv_reservation.rv_wait_list_user_id,
			rv_reservation.rv_prov_date
		FROM
			rv_reservation
			INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
		WHERE
			rv_reservation.rv_reservation_ix = '$rv_reservation_id'
	",1);
	$rf_reservation_status_to = $lDB->get("
		SELECT
			rf_reservation_status.rf_reservation_status_desc
		FROM
			rf_reservation_status
		WHERE
			rf_reservation_status.rf_reservation_status_id = '$rf_reservation_status_id'
	",4);

	$fromStatusStockholding = $rf_reservation_status_from['rf_reservation_status_id'] == DB_RF_RESERVATION_STATUS_CONFIRMED ||
		($rf_reservation_status_from['rf_reservation_status_id'] == DB_RF_RESERVATION_STATUS_PROVISIONAL && 
		$rf_reservation_status_from['rv_provision_expiry_date'] >= date('Y-m-d')) ? true : false;

	$toStatusStockholding 	= $rf_reservation_status_id == DB_RF_RESERVATION_STATUS_CONFIRMED ||
		($rf_reservation_status_id == DB_RF_RESERVATION_STATUS_PROVISIONAL && 
		$rv_provision_expiry_date >= date('Y-m-d')) ? true : false;

	if ($checkOverbooking) {
		if (!$fromStatusStockholding && $toStatusStockholding) {
			// Changing from non-stockholding to stockholding status.
			$hasOverbooking = !(check_availability($rv_reservation_id)===true);
			$allowOverbooking = db_sc_group_get_user_setting("sc_grp_res_ovr_overbooking_yn") == "1";
			if ($hasOverbooking && !$allowOverbooking) {
				// Overbooking, not allowed
				return false;
			}
		}
	}

	$today = date("Y-m-d");
	if($rf_reservation_status_id != DB_RF_RESERVATION_STATUS_PROVISIONAL) {
		$rv_provision_expiry_date = '0000-00-00';
	}

	$extra = array();

	$moduleFieldValues = array();
	$checkAlloc = false;
	switch($rf_reservation_status_id) {
	case DB_RF_RESERVATION_STATUS_QUOTATION:
		$extra['rv_date_quote'] = $lDB->escape($today);
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_date_quote", 'from'=>$rf_reservation_status_from['rv_date_quote'], 'to'=>$today);
		break;
	case DB_RF_RESERVATION_STATUS_WAITLIST:
		$extra['rv_wait_list_date'] = $lDB->escape($today);
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_wait_list_date", 'from'=>$rf_reservation_status_from['rv_wait_list_date'], 'to'=>$extra['rv_wait_list_date']);
		$extra['rv_wait_list_user_id'] = $lDB->escape($userid);
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_wait_list_user_id", 'from'=>$rf_reservation_status_from['rv_wait_list_user_id'], 'to'=>$extra['rv_wait_list_user_id']);
		break;
	case DB_RF_RESERVATION_STATUS_PROVISIONAL:
		$extra['rv_prov_date'] = $lDB->escape($today);
		//$rv_provision_expiry_date = $rf_reservation_status_data;
		if(empty($rv_provision_expiry_date)) {
			$rf_prov_expiry_days = $lDB->get("SELECT rf_prov_expiry_days FROM rf_default",4);
			$rv_provision_expiry_date = date("Y-m-d",mktime(0,0,0,date("m"),date("d")+$rf_prov_expiry_days,date("Y")));
		}
		$checkAlloc = true;
		$rf_reservation_status_to .= ", expires " . chng_date($rv_provision_expiry_date,"-");
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_provision_expiry_date", 'from'=>$rf_reservation_status_from['rv_provision_expiry_date'], 'to'=>$rv_provision_expiry_date);
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_prov_date", 'from'=>$rf_reservation_status_from['rv_prov_date'], 'to'=>$lDB->escape($today));
		break;
	case DB_RF_RESERVATION_STATUS_CONFIRMED:
		$extra['rv_confirmation_date'] = $lDB->escape($today);
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_confirmation_date", 'from'=>$rf_reservation_status_from['rv_confirmation_date'], 'to'=>$extra['rv_confirmation_date']);
		$extra['rv_confirmation_user_id'] = $lDB->escape($userid);
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_confirmation_user_id", 'from'=>$rf_reservation_status_from['rv_confirmation_user_id'], 'to'=>$extra['rv_confirmation_user_id']);
		$checkAlloc = true;
		break;
	case DB_RF_RESERVATION_STATUS_CANCELLED:
		$extra['rv_cancel_date'] = $lDB->escape($today);
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_cancel_date", 'from'=>$rf_reservation_status_from['rv_cancel_date'], 'to'=>$extra['rv_cancel_date']);
		$extra['rv_cancel_user_id'] = $lDB->escape($userid);
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_cancel_user_id", 'from'=>$rf_reservation_status_from['rv_cancel_user_id'], 'to'=>$extra['rv_cancel_user_id']);
		if(empty($rv_cancel_reason)) {
			$rv_cancel_reason = "No reason given.";
		}
		$extra['rv_cancel_reason'] = $lDB->escape($rv_cancel_reason);
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_cancel_reason", 'from'=>$rf_reservation_status_from['rv_cancel_reason'], 'to'=>$extra['rv_cancel_reason']);
		break;
	case DB_RF_RESERVATION_STATUS_DELETED:
		$extra['rv_date_deleted'] = $lDB->escape($today);
		$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rv_date_deleted", 'from'=>$rf_reservation_status_from['rv_date_deleted'], 'to'=>$extra['rv_date_deleted']);
		break;
	}

	$extraSQL = "";
	foreach($extra as $key=>$item) {
		$extraSQL .= "$key = '$item',\n";
	}

	$lDB->put("
		UPDATE rv_reservation SET
			rf_reservation_status_id = '".$lDB->escape($rf_reservation_status_id)."',
			rv_provision_expiry_date = '".$lDB->escape($rv_provision_expiry_date)."',
			$extraSQL
			rv_date_changed = '".$lDB->escape($today)."'
		WHERE
			rv_reservation.rv_reservation_ix = '$rv_reservation_id'
	");

	if($checkAlloc) {
		if($lDB->get("
			SELECT
				COUNT(*)
			FROM
				rv_reservation_item
				INNER JOIN rv_reservation_item AS link_item ON rv_reservation_item.rv_reservation_item_ix = link_item.rv_link_res_item_id
			WHERE
				rv_reservation_item.rv_reservation_id = '$rv_reservation_id'
		",4) > 0) {
			$agentInfo = $lDB->get("
				SELECT
					pr_agent.pr_agent_id,
					pr_agent.pr_agent_alloc_auto_yn
				FROM
					rv_reservation
					INNER JOIN pr_agent ON pr_agent.pr_agent_id = rv_reservation.rv_agent_id
				WHERE
					rv_reservation.rv_reservation_ix = '$rv_reservation_id'
			",1);
			$agentId = $agentInfo['pr_agent_id'];
			if(trim($agentId) == "") {
				$agentId = "0";
			}
			$itemList = $lDB->get("
				SELECT
					rv_reservation_item.rv_reservation_item_ix,
					rv_reservation_item.ac_accomm_type_id,
					rv_reservation_item.rv_item_date_arrive,
					rv_reservation_item.rv_item_date_depart,
					rv_reservation_item.rv_item_accomm_count
				FROM
					rv_reservation_item
				WHERE
					rv_reservation_item.rv_reservation_id = '$rv_reservation_id'
			",2);
			foreach($itemList as $item) {
				$allocations = array();
                $allocationDetails = $lDB->get("
                    SELECT DISTINCT
                        alloc.rv_reservation_ix,
                        alloc_item.bl_series_id
                    FROM
                        rv_reservation_item
                        LEFT JOIN rv_reservation_item AS alloc_item ON alloc_item.rv_link_res_item_id = rv_reservation_item.rv_reservation_item_ix
                        LEFT JOIN rv_reservation AS alloc ON alloc.rv_reservation_ix = alloc_item.rv_reservation_id
                    WHERE
                        rv_reservation_item.rv_reservation_item_ix = '$item[rv_reservation_item_ix]'
                ",1);
                $bl_series_id = !empty($allocationDetails) && isset($allocationDetails['bl_series_id']) ? $allocationDetails['bl_series_id'] : false;
				if($bl_series_id === false && $agentInfo['pr_agent_alloc_auto_yn'] == "0") {
                    $endArray = explode("-",$item['rv_item_date_depart']);
                    $newEndDate = date("Y-m-d",mktime(0,0,0,$endArray[1],$endArray[2]-1,$endArray[0]));
                    $stock = new Stock($item['ac_accomm_type_id'],$item['rv_item_date_arrive'],$newEndDate,false,$agentId,true);
                    $allocationArray = $stock->ToReservationAllocation($item['rv_reservation_item_ix']);
					$allocations = array();
					foreach($allocationArray as $day) {
						foreach($day as $allocId=>$allocItem) {
							array_push($allocations,$allocId);
						}
					}
					$allocations = array_unique($allocations);
				}
				if(!empty($allocations)) {
					drawAllocations($item['rv_reservation_item_ix'],$allocations,false,$bl_series_id);
				}
			}
		}
	}
	$reservationAuditTrail = new AuditTrail($rv_reservation_id,TYPE_RESERVATION);
	$moduleFieldValues[] = array("ad_module_field_name"=>"rv_reservation.rf_reservation_status_id", 'from'=>$rf_reservation_status_from['rf_reservation_status_id'], 'to'=>$rf_reservation_status_id);
	foreach ($moduleFieldValues as $moduleFieldValue) {
		$moduleFieldName = explode(".", $moduleFieldValue['ad_module_field_name'])[1];
		$reservationAuditTrail->addDetail(
			$moduleFieldValue['from'],
			$moduleFieldValue['to'],
			Null,
			Null,
			DB_AD_RES_DETAIL_ACTION_EDIT,
			"resdetail",
			$moduleFieldValue['ad_module_field_name']
		);
	}

	$reservationAuditTrail->save("Reservation Status: " . $rf_reservation_status_from['rf_reservation_status_desc'] . " to $rf_reservation_status_to");

	// Change to non-stock-holding status, remove any rooming information
	$nonStockHoldingStatuses = [DB_RF_RESERVATION_STATUS_CANCELLED, DB_RF_RESERVATION_STATUS_DELETED, DB_RF_RESERVATION_STATUS_QUOTATION, DB_RF_RESERVATION_STATUS_WAITLIST];
	if (in_array($rf_reservation_status_id, $nonStockHoldingStatuses)) {
		removeRoomingInfo($rv_reservation_id);
	}

	// Clear cache on status change
	$expiredBefore = $rf_reservation_status_from['rv_provision_expiry_date'] < $today;
	$expiredAfter = $rv_provision_expiry_date < $today;
	$provExpStatusChanged = ($expiredBefore != $expiredAfter) ? true : false;

	if(
		($rf_reservation_status_from['rf_reservation_status_id'] != $rf_reservation_status_id)
		|| ($rf_reservation_status_id == "20" && $provExpStatusChanged)
	) {
		// Status has changed or provisional expiry has changed
		$accomms = $lDB->get("
			SELECT
				ac_accomm_type_id,
				rv_item_date_arrive,
				rv_item_date_depart
			FROM
				rv_reservation_item
			WHERE
				rv_reservation_id = '".$rv_reservation_id."'
		",2);

		foreach ($accomms as $accomm) {
			$rv_item_date_end = date("Y-m-d",strtotime($accomm['rv_item_date_depart'] . " -1 day"));
			$stock = new Stock($accomm['ac_accomm_type_id'],$accomm['rv_item_date_arrive'],$rv_item_date_end);
			$stock->ClearCache(array('occupancy'));
		}
	}

	return true;
}

function db_rv_reservation_update_notes($rv_reservation_id) {
	global $lDB;

	$oldFlagChngs = $GLOBALS['flagChngs'];
	$GLOBALS['flagChngs'] = "0";


	$wasMaster = true;
	if ($lDB->isMaster != "1"){
		$lDB->isMaster = "1";
		$wasMaster = false;
	}

	$notes = db_rv_note_get_by_reservation($rv_reservation_id);
	if($notes !== false) {
		$lDB->put("
			UPDATE
				rv_reservation
			SET
				rf_country_id = '$notes[rf_country_id]',
				rv_note_conf = '".$lDB->escape($notes['rv_note_conf'])."',
				rv_note_general = '".$lDB->escape($notes['rv_note_general'])."',
				rv_note_guests = '".$lDB->escape($notes['rv_note_guests'])."',
				rv_note_internal = '".$lDB->escape($notes['rv_note_internal'])."'
			WHERE
				rv_reservation_ix = '$rv_reservation_id'
		");
	}

	if(!$wasMaster) {
		$lDB->isMaster = "0";
	}

	db_tc_res_update_insert($rv_reservation_id);

	$GLOBALS['flagChngs'] = $oldFlagChngs;

	return true;
}

function db_rv_reservation_is_tba($rv_reservation_id) {
	global $lDB;

	$compCount = $lDB->get("
		SELECT
			COUNT(rv_res_item_comp.rv_res_item_comp_ix)
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
		WHERE
			rv_reservation.rv_reservation_ix = '$rv_reservation_id'
		GROUP BY
			rv_reservation_item.rv_reservation_item_ix
	",3);
	if(in_array(0,$compCount)) {
		return true;
	} else {
		return false;
	}
}

function db_rv_folio_level_desc($rv_folio_level_ind) {
	switch($rv_folio_level_ind) {
		case DB_RV_FOLIO_LEVEL_BUSINESS:
			return "Business Level";
			break;
		case DB_RV_FOLIO_LEVEL_GROUP:
			return "Group (room) Level";
			break;
		default:
			return $rv_folio_level_ind;
	}
}

function db_rv_reservation_set_discount($rv_reservation_ix, $rv_amt_sp_discount) {
	global $lDB;

	$rv_res_item_comp_set = $lDB->put("
		UPDATE
			rv_reservation
		SET
			rv_amt_sp_discount = ".$rv_amt_sp_discount."
		WHERE
			rv_reservation_ix = '".$rv_reservation_ix."'
	");
	return true;
}

function db_get_rv_reservation_by_folio($fn_folio_id) {
	global $lDB;

	return $lDB->get("
		SELECT
			rv_reservation_id
		FROM
			fn_folio
		WHERE
			fn_folio_ix = '$fn_folio_id'
		",4);
}

function db_rv_reservation_set_terms($rv_reservation_id, $rt_rate_type_id, $rv_commission_perc) {
	global $lDB;

	if(!db_rv_reservation_exists($rv_reservation_id) || !db_rt_rate_type_exists($rt_rate_type_id)) {
		return false;
	}

	$lDB->put("
		UPDATE rv_reservation SET
			rt_rate_type_id = '" . $lDB->escape($rt_rate_type_id) . "',
			rv_commission_perc = '" . $lDB->escape($rv_commission_perc) . "'
		WHERE
			rv_reservation_ix = '" . $lDB->escape($rv_reservation_id) . "'
	");

	return true;
}

function db_rv_reservation_has_special_discount($rv_reservation_id) {
	global $lDB;

	if(!db_rv_reservation_exists($rv_reservation_id)) {
		return false;
	}

	$orphaned_special = $lDB->get("
		SELECT
			rv_reservation.rv_reservation_ix
		FROM
			rv_reservation
			LEFT JOIN rv_special ON rv_special.rv_reservation_id = rv_reservation.rv_reservation_ix
		WHERE
			rv_reservation.rv_amt_sp_discount != 0.00
			AND rv_reservation.rv_reservation_ix = '".$rv_reservation_id."'
			AND rv_special.rv_reservation_id IS NULL
	",4);
}

function db_rv_reservation_set_special_override($rv_reservation_id, $rv_sp_override_yn=true) {
	global $lDB;
	global $userid;

	if(!db_rv_reservation_exists($rv_reservation_id)) {
		return false;
	}

	if(empty($rv_sp_override_yn)) {
		$rv_sp_override_yn = "0";
	} else {
		$rv_sp_override_yn = "1";
	}

	$lDB->put("
		UPDATE rv_reservation SET
			rv_sp_override_yn = '" . $lDB->escape($rv_sp_override_yn) . "',
			rv_sp_override_user_id = '" . $lDB->escape($userid) . "',
			rv_sp_override_date = '" . $lDB->escape(date("Y-m-d H:i:s")) . "',
			rv_sp_override_date_tz = '" . $lDB->escape(date("e")) . "'
		WHERE
			rv_reservation_ix = '" . $lDB->escape($rv_reservation_id) . "'
	");

	return true;
}

function db_rv_reservation_has_special_override($rv_reservation_id) {
	global $lDB;

	if(!db_rv_reservation_exists($rv_reservation_id)) {
		return false;
	}

	$rv_sp_override_yn = $lDB->get("
		SELECT rv_sp_override_yn FROM rv_reservation WHERE rv_reservation_ix = '" . $lDB->escape($rv_reservation_id) . "'
	",4);

	if($rv_sp_override_yn == "1") {
		return true;
	} else {
		return false;
	}
}

function removeRoomingInfo($rv_reservation_id, $audit=true) {
	$rv_res_item_groups = db_rv_res_item_group_by_reservation($rv_reservation_id);
	if (!empty($rv_res_item_groups)) {
		foreach ($rv_res_item_groups as $rv_res_item_group) {
			db_rv_res_item_group_delete($rv_res_item_group['rv_res_item_group_ix']);
			if ($audit) {
				ammendReservation($rv_reservation_id, "Room Allocation ('" . $rv_res_item_group['ac_desc'] . "' to 'None')");
			}
			$guests = db_rv_res_item_guests_by_item($rv_res_item_group['rv_reservation_item_id']);
			if (!empty($guests)) {
				$guestNames = array();
				foreach ($guests as $guest) {
					$guestNames[] = trim($guest['pr_name_first'] . ' ' . $guest['pr_name_last']);
					db_rv_res_item_guest_delete($guest['rv_res_item_guest_ix']);
				}
				if ($audit) {
					ammendReservation($rv_reservation_id, "Guests (Remove: " . join(', ', $guestNames) . ")");
				}
			}
		}
	}
}
