<?php

require_once(__DIR__ . "/db.rt_rate_type.php");
require_once(__DIR__ . "/db.rv_reservation.php");
require_once(__DIR__ . "/db.rv_res_item_rate_grp.php");
require_once(__DIR__ . "/db.ac_accomm_type.php");
require_once(__DIR__ . "/db.fn_folio.php");

require_once(__DIR__ . "/functions.php");

// Item override level
define("DB_RV_ITEM_OVERIDE_LEVEL_PERSON",1);
define("DB_RV_ITEM_OVERIDE_LEVEL_UNIT",2);
define("DB_RV_ITEM_OVERIDE_LEVEL_STAY",3);

function db_rv_reservation_item_exists($rv_reservation_item_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(rv_reservation_item_ix) FROM rv_reservation_item WHERE rv_reservation_item_ix = '$rv_reservation_item_id'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_rv_reservation_item_insert($rv_reservation_id,$ac_accomm_type_id,$rv_item_date_arrive,$rv_item_date_depart,$rateGroups,$rt_rate_comm_yn,$override=false,$rv_item_split_yn=false,$rt_rate_type_id=false,$rv_link_res_item_id=false,$pr_user_id=false,$db_code=false,$bl_block_itinerary_id=false,$bl_series_id=false,$bl_series_sequence_number=false,$rv_alloc_expiry_date=false,$rv_item_comm_perc=false) {
	global $lDB;

	if(!db_rv_reservation_exists($rv_reservation_id)) {
		return false;
	}

	if(!db_ac_accomm_type_exists($ac_accomm_type_id)) {
		return false;
	}

	if (is_array($override) && !empty($override)){
		$rv_item_overide_level_ind = $override['level'];
		if ($rv_item_overide_level_ind == 3 && $override['amounts']['stay'] != ""){
			$rv_item_overide_amt = "'".$override['amounts']['stay']."'";
		} else {
			$rv_item_overide_amt = "NULL";
		}
	} else {
		$rv_item_overide_level_ind = "";
		$rv_item_overide_amt = "NULL";
	}
	
	$today = date("Y-m-d H:i:s");
	$timezone = date("e");

	$pr_business_id = $lDB->get("SELECT pr_business_id FROM ac_accomm_type WHERE ac_accomm_type_ix = '$ac_accomm_type_id'",4);
	$rf_reservation_status_id = $lDB->get("SELECT rf_reservation_status_id FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'",4);

	$rv_item_nights = dateSubtract($rv_item_date_depart,$rv_item_date_arrive);

	if(!$rv_item_split_yn) {
		$rv_item_split_yn = "0";
	} else {
		$rv_item_split_yn = "1";
	}

	if($rv_item_comm_perc === false) {
		$rv_item_comm_perc = $lDB->get("
			SELECT rv_commission_perc FROM rv_reservation WHERE rv_reservation_ix = '" . $lDB->escape($rv_reservation_id) . "'
		",4);
	}

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}

	$extra = array();
	if(!empty($rt_rate_type_id)) {
		$extra['rt_rate_type_id'] = $lDB->escape($rt_rate_type_id);
	}
	// these fields should only be set on an allocation item
	if (in_array($rf_reservation_status_id,array(15,97))) {
		if(!empty($rv_link_res_item_id)) {
			$extra['rv_link_res_item_id'] = $lDB->escape($rv_link_res_item_id);
		}
		if(!empty($bl_block_itinerary_id)) {
			$extra['bl_block_itinerary_id'] = $lDB->escape($bl_block_itinerary_id);
		}
		if(!empty($bl_series_id)) {
			$extra['bl_series_id'] = $lDB->escape($bl_series_id);
		}
		if(!empty($bl_series_sequence_number)) {
			$extra['bl_series_sequence_number'] = $lDB->escape($bl_series_sequence_number);
		}
		if(!empty($rv_alloc_expiry_date)) {
			$extra['rv_alloc_expiry_date'] = $lDB->escape($rv_alloc_expiry_date);
		} elseif (empty($rv_alloc_expiry_date) && !empty($bl_series_id)) {
			$extra['rv_alloc_expiry_date'] = $lDB->get("SELECT rv_alloc_expiry_date FROM rv_reservation_item WHERE rv_reservation_item_ix = '$bl_series_id' AND rv_alloc_expiry_date IS NOT NULL",4);
		}
	}

	$extraFields = "";
	$extraValues = "";
	if(sizeof($extra) > 0) {
		$extraFields = "," .join(",",array_keys($extra));
		$extraValues = ",'" . join("','",array_values($extra)) . "'";
	}
	
	if($db_code === false) {
		$db_code = $GLOBALS['dbcode'];
	}	
	
	$rv_item_child_count = 0;
	$rv_item_adult_count = 0;
	$rv_item_accomm_count = 0;
	$unitCode = $lDB->get("SELECT rt_rate_group_ix FROM rt_rate_group WHERE rt_rate_group_sys_code = 1",4);

	foreach($rateGroups as $rateGroup){
		$classification = $lDB->get("SELECT rt_rate_group_class FROM rt_rate_group WHERE rt_rate_group_ix = '".$rateGroup['rt_rate_group_ix']."'",4);
		switch($classification){
			case 1:
				$rv_item_adult_count = $rv_item_adult_count + $rateGroup['qty'];
				break;
			case 2:
				$rv_item_child_count = $rv_item_child_count + $rateGroup['qty'];
				break;
		}
		if ($rateGroup['rt_rate_group_ix'] == $unitCode) {
			// previously the assumption was that the first rate group is the unit group. This makes provision for
			// the rate groups to be passed in a different order, eg. from an API call
			$rv_item_accomm_count = $rateGroup['qty'];
		}
	}
	
	if ($rv_item_accomm_count == 0) {	// fall back to previous (flawed) logic
		$rv_item_accomm_count = $rateGroups[0]['qty'];
	}

	$lDB->put("
		INSERT INTO rv_reservation_item (
			rv_reservation_item_db,
			rv_reservation_id,
			ac_accomm_type_id,
			pr_business_id,
			rv_item_date_arrive,
			rv_item_date_depart,
			rv_item_nights,
			rv_item_accomm_count,
			rv_item_adult_count,
			rv_item_child_count,
			rv_item_split_yn,
			rv_item_comm_yn,
			rv_item_user_id,
			rv_item_date_added,
			rv_item_date_added_tz,
			rv_item_date_changed,
			rv_item_date_changed_tz,
			rv_item_overide_level_ind,
			rv_item_overide_amt,
			rv_item_comm_perc
			$extraFields
		) VALUES (
			'".$lDB->escape($db_code)."',
			'".$lDB->escape($rv_reservation_id)."',
			'".$lDB->escape($ac_accomm_type_id)."',
			'".$lDB->escape($pr_business_id)."',
			'".$lDB->escape($rv_item_date_arrive)."',
			'".$lDB->escape($rv_item_date_depart)."',
			'".$lDB->escape($rv_item_nights)."',
			'".$lDB->escape($rv_item_accomm_count)."',
			'".$lDB->escape($rv_item_adult_count)."',
			'".$lDB->escape($rv_item_child_count)."',
			'".$lDB->escape($rv_item_split_yn)."',
			'".$lDB->escape($rt_rate_comm_yn)."',
			'".$lDB->escape($pr_user_id)."',
			'".$lDB->escape($today)."',
			'".$lDB->escape($timezone)."',
			'".$lDB->escape($today)."',
			'".$lDB->escape($timezone)."',
			'".$lDB->escape($rv_item_overide_level_ind)."',
			$rv_item_overide_amt,
			'".$lDB->escape($rv_item_comm_perc)."'
			$extraValues
		)
	");

	$rv_reservation_item_id = $lDB->insert_id;
	// Update block allocation item grouping ids
	if(!empty($bl_series_id)) {
		if ($bl_series_sequence_number == "1" && $bl_series_id != $rv_reservation_item_id) {
			$series_items = $lDB->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE bl_series_id = '$bl_series_id'", 3);
			foreach ($series_items as $series_item) {
				$lDB->put("UPDATE rv_reservation_item SET bl_series_id = '$rv_reservation_item_id' WHERE rv_reservation_item_ix = '$series_item'");
			}
		}
	}

	foreach($rateGroups as $rateGroup){
		if (!empty($rateGroup['qty'])){
			$rate_group_override = false;
			if (is_array($override) && !empty($override)){
				if (($rv_item_overide_level_ind == 1 || $rv_item_overide_level_ind == 2) && isset($override['amounts']['rate_group'][$rateGroup['rt_rate_group_ix']]) && $override['amounts']['rate_group'][$rateGroup['rt_rate_group_ix']] != ""){
					$rate_group_override = $override['amounts']['rate_group'][$rateGroup['rt_rate_group_ix']];
				}
			}
			db_rv_res_item_rate_grp_insert($rateGroup['qty'],$rateGroup['rt_rate_group_ix'],$rv_reservation_item_id,$rate_group_override);
		}
	}
	
	return $rv_reservation_item_id;	
}

function db_rv_item_overide_level_desc($rv_item_overide_level_ind) {
	switch($rv_item_overide_level_ind) {
		case DB_RV_ITEM_OVERIDE_LEVEL_PERSON:
			return "Person";
			break;
		case DB_RV_ITEM_OVERIDE_LEVEL_UNIT:
			return "Unit";
			break;
		case DB_RV_ITEM_OVERIDE_LEVEL_STAY:
			return "Stay";
			break;
		default:
			return $rv_item_overide_level_ind;
	}
}

function db_rv_reservation_item_by_reservation($rv_reservation_id) {
	global $lDB;

	$reservation_items = $lDB->get("
		SELECT
			rv_reservation_item.rv_reservation_item_ix
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_id = '".$rv_reservation_id."'
	",3);
	return $reservation_items;
}

function db_rv_reservation_item_set_discount($rv_reservation_item_ix, $rv_item_amt_sp_discount) {
	global $lDB;

	$rv_res_item_comp_set = $lDB->put("
		UPDATE
			rv_reservation_item
		SET
			rv_item_amt_sp_discount = ".$rv_item_amt_sp_discount."
		WHERE
			rv_reservation_item_ix = '".$rv_reservation_item_ix."'
	");
	return true;
}

function db_rv_reservation_item_set_discount_by_reservation($rv_reservation_id) {
	
	$reservation_items = db_rv_reservation_item_by_reservation($rv_reservation_id);
	
	foreach ($reservation_items as $rv_reservation_item_ix) {
		db_rv_reservation_item_set_discount($rv_reservation_item_ix,0);
	}
}

function db_rv_reservation_item_has_special($rv_reservation_item_id) {
	global $lDB;

	$count = $lDB->get("
		SELECT
			rv_item_amt_sp_discount
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item_ix = '$rv_reservation_item_id'
		",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_rv_reservation_item_set_departure_expiry($rv_reservation_item_id, $rv_alloc_expiry_date) {
	global $lDB;
	if (!db_rv_reservation_item_exists($rv_reservation_item_id)) {
		return false;
	}

	$rv_reservation_item_details = $lDB->get("
		SELECT
			rv_reservation_item.bl_series_id,
			rv_reservation_item.bl_series_sequence_number
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.rv_reservation_item_ix = '$rv_reservation_item_id'
	");

	if (empty($rv_reservation_item_details['bl_series_id'])) {
		return false;
	}

	$lDB->put("
		UPDATE
			rv_reservation_item
		SET
			rv_reservation_item.rv_alloc_expiry_date = '$rv_alloc_expiry_date'
		WHERE
			bl_series_id = '".$rv_reservation_item_details['bl_series_id']."'
	");

	return true;
}

function db_rv_reservation_item_get_folio($rv_reservation_item_id) {
	global $lDB;

	$fn_folio_id = $lDB->get("
		SELECT
			fn_folio_id
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item_ix = '$rv_reservation_item_id'
		",4);
	
	return $fn_folio_id;
}

function db_rv_reservation_item_is_tba($rv_reservation_item_id) {
	global $lDB;

	$compCount = $lDB->get("
		SELECT
			COUNT(*)
		FROM
			rv_res_item_comp
		WHERE
			rv_res_item_comp.rv_reservation_item_id = '$rv_reservation_item_id'

	",4);
	if($compCount < 1) {
		return true;
	} else {
		return false;
	}
}

function db_rv_reservation_item_set_commission($rv_reservation_item_id, $rv_item_comm_perc) {
	global $lDB;

	if(!db_rv_reservation_item_exists($rv_reservation_item_id)) {
		return false;
	}

	$lDB->put("
		UPDATE rv_reservation_item SET
			rv_item_comm_perc = '" . $lDB->escape($rv_item_comm_perc) . "'
		WHERE
			rv_reservation_item_ix = '" . $lDB->escape($rv_reservation_item_id) . "'
	");

	return true;
}

function db_rv_reservation_item_set_terms($rv_reservation_item_id, $rt_rate_type_id, $rv_item_comm_perc) {
	global $lDB;

	if(!db_rv_reservation_item_exists($rv_reservation_item_id) || !db_rt_rate_type_exists($rt_rate_type_id)) {
		return false;
	}

	$lDB->put("
		UPDATE rv_reservation_item SET
			rt_rate_type_id = '" . $lDB->escape($rt_rate_type_id) . "',
			rv_item_comm_perc = '" . $lDB->escape($rv_item_comm_perc) . "'
		WHERE
			rv_reservation_item_ix = '" . $lDB->escape($rv_reservation_item_id) . "'
	");

	return true;
}

function db_rv_reservation_item_get_desc($rv_reservation_item_id) {
	global $lDB;

	return $GLOBALS['lDB']->get("SELECT
		CONCAT(rv_reservation_item.rv_item_date_arrive, ' to ', rv_reservation_item.rv_item_date_depart, ', ', rv_reservation_item.rv_item_nights, ' nights, ', rv_reservation_item.rv_item_accomm_count, ' rooms, ', rv_reservation_item.rv_item_adult_count, ' adult, ', rv_reservation_item.rv_item_child_count, ' child, ', ac_accomm_type.ac_accomm_desc, ', ', pr_persona.pr_name_last)
	FROM
		rv_reservation_item
		LEFT JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
		LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
	WHERE
		rv_reservation_item_ix = '" . $rv_reservation_item_id . "'",
	4);
}
