<?php

require_once(__DIR__ . "/db.rv_reservation.php");
require_once(__DIR__ . "/db.sp_special.php");

function db_rv_special_exists($rv_special_id) {
	global $lDB;

	$count = $lDB->get("
		SELECT COUNT(rv_special_ix) FROM rv_special WHERE rv_special_ix = '" . $lDB->escape($rv_special_id) . "'
	",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_rv_special_exists_by_reservation($rv_reservation_id) {
	global $lDB;

	$count = $lDB->get("
		SELECT
			COUNT(rv_special.sp_special_id)
		FROM
			rv_special
		WHERE
			rv_special.rv_reservation_id = '" . $lDB->escape($rv_reservation_id) . "'
	",4);

	if($count > 0) {
		return true;
	} else {
		return false;
	}
}

function db_rv_special_insert($rv_reservation_id, $sp_special_id) {
	global $lDB;
	global $dbcode;

	if(!db_rv_reservation_exists($rv_reservation_id) || !db_sp_special_exists($sp_special_id)) {
		return false;
	}

	$createDate = date("Y-m-d H:i:s");
	$createDateTz = date("e");

	$pr_user_id = $GLOBALS['userid'];

	$lDB->put("
		INSERT INTO rv_special (
			rv_special.rv_special_db,
			rv_special.rv_reservation_id,
			rv_special.sp_special_id,
			rv_special.ad_create_date,
			rv_special.ad_create_date_tz,
			rv_special.ad_create_user_id
		) VALUES  (
			'" . $lDB->escape($dbcode) . "',
			'" . $lDB->escape($rv_reservation_id) . "',
			'" . $lDB->escape($sp_special_id) . "',
			'" . $lDB->escape($createDate) . "',
			'" . $lDB->escape($createDateTz) . "',
			'" . $lDB->escape($pr_user_id) . "'
		)
	");

	$rv_special_id = $lDB->insert_id;

	return $rv_special_id;	
}

function db_rv_special_get_by_reservation($rv_reservation_id) {
	global $lDB;

	return $lDB->get("
		SELECT
			rv_special.rv_special_ix
		FROM
			rv_special
		WHERE
			rv_special.rv_reservation_id = '" . $lDB->escape($rv_reservation_id) . "'
	",3);
}

function db_rv_special_get_specials_by_reservation($rv_reservation_id) {
	global $lDB;

	return $lDB->get("
		SELECT DISTINCT
			rv_special.sp_special_id
		FROM
			rv_special
		WHERE
			rv_special.rv_reservation_id = '" . $lDB->escape($rv_reservation_id) . "'
	",3);
}

function db_rv_special_delete($rv_special_id) {
	global $lDB;

	$lDB->put("DELETE FROM rv_special WHERE rv_special_ix = '" . $lDB->escape($rv_special_id) . "'");
}

function db_rv_special_delete_by_reservation($rv_reservation_id) {
	global $dbcode;

	$specials = db_rv_special_get_by_reservation($rv_reservation_id);
	foreach ($specials as $rv_special_id) {
		db_rv_special_delete($rv_special_id);
	}
}

function db_rv_special_id($rv_reservation_id) {
//	die("TODO REMOVE");
	global $lDB;

	$sp_special = $lDB->get("
		SELECT
			rv_special.sp_special_id
		FROM
			rv_special
		WHERE
			rv_special.rv_reservation_id = '".$rv_reservation_id."'
	",4);
	return $sp_special;
}

function db_rv_special_orphaned_check($rv_reservation_id) {
//	die("TODO remove");
	global $lDB;

	$orphaned_special = $lDB->get("
		SELECT
			rv_reservation.rv_reservation_ix
		FROM
			rv_reservation
			LEFT JOIN rv_special ON rv_special.rv_reservation_id = rv_reservation.rv_reservation_ix
		WHERE
			rv_reservation.rv_amt_sp_discount != 0.00
			AND rv_reservation.rv_reservation_ix = '".$rv_reservation_id."'
			AND rv_special.rv_reservation_id IS NULL
	",4);

	return empty($orphaned_special) ? false : true;
}

function db_rv_special_set_discount($rv_special_id, $rv_sp_amt_discount) {
	global $lDB;

	if(!db_rv_special_exists($rv_special_id)) {
		return false;
	}

	$lDB->put("
		UPDATE
			rv_special
		SET
			rv_sp_amt_discount = '" . $lDB->escape($rv_sp_amt_discount) . "'
		WHERE
			rv_special_ix = '" . $lDB->escape($rv_special_id) . "'
	");
	return true;
}

function db_rv_special_set_discount_by_reservation($rv_reservation_id) {

	$list = db_rv_special_get_by_reservation($rv_reservation_id);
	
	foreach($list as $rv_special_id) {
		db_rv_special_set_discount($rv_special_id, 0);
	}
}
