<?php
require_once(__DIR__ . "/db.rf_obj_trip.php");
require_once(__DIR__ . "/db.pr_guest.php");
require_once(__DIR__ . "/db.pr_business.php");
require_once(__DIR__ . "/db.rv_reservation.php");
function db_rv_trip_obj_data_exists($fieldValue, $field='rv_trip_obj_data_ix') {
	global $lDB;

	$check = $lDB->get("
		SELECT
			COUNT(rv_trip_obj_data_ix)
		FROM
			rv_trip_obj_data
		WHERE
			$field = '".$lDB->escape($fieldValue)."'
			AND (
				rv_trip_obj_data != ''
				OR rf_obj_trip_data_id != ''
			)
	",4);
	if($check > 0) { 
		return true; 
	} else { 
		return false; 
	}
}

function db_rv_trip_obj_data_select_by_id($rf_obj_trip_id, $rv_reservation_id, $pr_guest_id, $pr_business_id) {
	global $lDB;
	$rv_trip_obj_data_id = $lDB->get("
		SELECT 
			rv_trip_obj_data_ix 
		FROM 
			rv_trip_obj_data 
		WHERE 
			rf_obj_trip_id = '$rf_obj_trip_id' 
			AND rv_reservation_id = '$rv_reservation_id' 
			AND pr_guest_id = '$pr_guest_id' 
			AND pr_business_id = '$pr_business_id'
	",4);
	if($rv_trip_obj_data_id == '') {
		return 0;
	} else {
		return $rv_trip_obj_data_id;
	}
}

function db_rv_trip_obj_data_field_by_type($rf_obj_trip_type_ind) {
	switch($rf_obj_trip_type_ind) {
	case DB_RF_OBJ_TRIP_TEXTBOX:
	case DB_RF_OBJ_TRIP_TEXTAREA:
	case DB_RF_OBJ_TRIP_NUMERIC:
		return 'rv_trip_obj_data';
	case DB_RF_OBJ_TRIP_RADIO:
	case DB_RF_OBJ_TRIP_SELECTBOX:
	case DB_RF_OBJ_TRIP_CHECKBOX:
		return 'rf_obj_trip_data_id';
	}
}

function db_rv_trip_obj_data_get_all($rv_trip_obj_data_id) {
	global $lDB;

	if(!db_rv_trip_obj_data_exists($rv_trip_obj_data_id)) {
		return false;
	}

	$rv_trip_obj_data = $lDB->get("
		SELECT
			rv_trip_obj_data.rf_obj_trip_id,
			rv_trip_obj_data.rv_trip_obj_data,
			rv_trip_obj_data.rf_obj_trip_data_id,
			rf_obj_trip.rf_obj_trip_type_ind
		FROM
			rv_trip_obj_data
			INNER JOIN rf_obj_trip ON rf_obj_trip.rf_obj_trip_ix = rv_trip_obj_data.rf_obj_trip_id
		WHERE
			rv_trip_obj_data.rv_trip_obj_data_ix = '".$lDB->escape($rv_trip_obj_data_id)."'
	",1);

	$value = $rv_trip_obj_data[db_rv_trip_obj_data_field_by_type($rv_trip_obj_data['rf_obj_trip_type_ind'])];
	return db_rf_obj_trip_get_all($rv_trip_obj_data['rf_obj_trip_id'], $value);
}

function db_rv_trip_obj_data_insert($rf_obj_trip_id, $pr_guest_id, $rv_reservation_id, $pr_business_id, $rv_trip_obj_data, $rf_obj_trip_type_ind) {

	global $lDB;
	global $dbcode;
	
	
	if(!db_rf_obj_trip_exists($rf_obj_trip_id)) {
		return false;
	}
	if($pr_business_id != 0 && !db_pr_business_exists($pr_business_id)) {
		return false;
	}
	if(!db_pr_guest_exists($pr_guest_id)) {
		return false;
	}
	if(!db_rv_reservation_exists($rv_reservation_id)) {
		return false;
	}
	
	
	$rv_trip_obj_data_id = db_rv_trip_obj_data_select_by_id($rf_obj_trip_id, $rv_reservation_id, $pr_guest_id, $pr_business_id);
	if($rv_trip_obj_data_id != '0' && $rf_obj_trip_type_ind != DB_RF_OBJ_TRIP_CHECKBOX) {

		$rv_trip_obj_data_id 			= isset($rv_trip_obj_data_id) ? $rv_trip_obj_data_id : "";
		$rf_obj_trip_type_ind 			= isset($rf_obj_trip_type_ind) ? $rf_obj_trip_type_ind : "";
		$rv_trip_obj_data 				= isset($rv_trip_obj_data) ? $rv_trip_obj_data : "";
		$rv_trip_obj_data_inactive_yn 	= isset($rv_trip_obj_data_inactive_yn) ? $rv_trip_obj_data_inactive_yn : "0";
		
		db_rv_trip_obj_data_update($rv_trip_obj_data_id, $rf_obj_trip_type_ind, $rv_trip_obj_data, $rv_trip_obj_data_inactive_yn);
	} else { 
		$data_field = 'rv_trip_obj_data';
		if($rf_obj_trip_type_ind == DB_RF_OBJ_TRIP_RADIO || $rf_obj_trip_type_ind == DB_RF_OBJ_TRIP_CHECKBOX || $rf_obj_trip_type_ind == DB_RF_OBJ_TRIP_SELECTBOX) {
			$data_field = 'rf_obj_trip_data_id';	
		}
		
		$lDB->put("
			INSERT INTO 
				rv_trip_obj_data (
					rv_trip_obj_data_db,
					$data_field,
					pr_business_id,
					pr_guest_id,
					rf_obj_trip_id,
					rv_reservation_id
				) 
			VALUES (
				'".$lDB->escape($dbcode)."',
				'".$lDB->escape($rv_trip_obj_data)."',
				'".$lDB->escape($pr_business_id)."',
				'".$lDB->escape($pr_guest_id)."',
				'".$lDB->escape($rf_obj_trip_id)."',
				'".$lDB->escape($rv_reservation_id)."'
			)
		");
	
		$rv_trip_obj_data_id = $lDB->insert_id;
	}
	return $rv_trip_obj_data_id;
}

function db_rv_trip_obj_data_update($rv_trip_obj_data_id, $rf_obj_trip_type_ind, $rv_trip_obj_data, $rv_trip_obj_data_inactive_yn=0) {
	global $lDB;
	$data_field = 'rv_trip_obj_data';
	if($rf_obj_trip_type_ind == DB_RF_OBJ_TRIP_RADIO || $rf_obj_trip_type_ind == DB_RF_OBJ_TRIP_CHECKBOX || $rf_obj_trip_type_ind == DB_RF_OBJ_TRIP_SELECTBOX) {
		$data_field = 'rf_obj_trip_data_id';	
	}
		
	$lDB->put("
		UPDATE rv_trip_obj_data SET
			$data_field = '".$lDB->escape($rv_trip_obj_data)."',
			rv_trip_obj_data_inactive_yn = '".$lDB->escape($rv_trip_obj_data_inactive_yn)."'
		WHERE
			rv_trip_obj_data_ix = '".$lDB->escape($rv_trip_obj_data_id)."'
	");
}

function db_rv_trip_obj_data_delete($rv_trip_obj_data_id) {
	global $lDB;
	$res = $lDB->put("
		DELETE 
		FROM 
			rv_trip_obj_data 
		WHERE 
			rv_trip_obj_data_ix = '".$lDB->escape($rv_trip_obj_data_id)."'
	");
	
	return $res;
}

function db_rv_trip_obj_data_delete_by_parent($rf_obj_trip_id) {
	global $lDB;
	if(!db_rf_obj_trip_exists($rf_obj_trip_id)) {
		return false;
	}

	$rv_trip_obj_data_ixs = $lDB->get("
		SELECT 
			rv_trip_obj_data_ix
		FROM 
			rv_trip_obj_data
		WHERE
			rf_obj_trip_id = '$rf_obj_trip_id'
	", 3);

	if(is_array($rv_trip_obj_data_ixs)) {
		foreach($rv_trip_obj_data_ixs as $rv_trip_obj_data_id) {
			db_rv_trip_obj_data_delete($rv_trip_obj_data_id);
		}
	}
}

function db_rv_trip_obj_data_select($rf_obj_trip_id) {
	global $lDB;
	
	$obj_trip_data = $lDB->get("SELECT * FROM rf_obj_trip_data WHERE rf_obj_trip_id = '$rf_obj_trip_id'", 2);

	if(count($obj_trip_data) > 0) {
		return $obj_trip_data; 
	} else { 
		return false; 
	}

}

function db_rv_trip_obj_data_delete_by_guest($pr_guest_id, $rv_reservation_id, $audit = false) {
	global $lDB;
	
	$rv_trip_obj_datas = $lDB->get("
		SELECT 
			rv_trip_obj_data_ix,
			rf_obj_trip_id
		FROM 
			rv_trip_obj_data
		WHERE
			pr_guest_id = '$pr_guest_id'
			AND rv_reservation_id = '$rv_reservation_id'
	", 6);

	foreach($rv_trip_obj_datas as $rv_trip_obj_data) {
		$rv_trip_obj_data_id = $rv_trip_obj_data['rv_trip_obj_data_ix'];
		$rf_obj_trip_id = $rv_trip_obj_data['rf_obj_trip_id'];
		if($audit !== false) {
			$all = db_rv_trip_obj_data_get_all($rv_trip_obj_data_id);
			$audit->addDetail($all['id'], "", $rv_trip_obj_data_id, "", DB_AD_PERSONA_DETAIL_ACTION_DELETE, "tripsheet", "rv_trip_obj_data.", $rf_obj_trip_id, $all['value'], "");
		}
		db_rv_trip_obj_data_delete($rv_trip_obj_data_id);
	}
}
