<?php

define('ENVIRONMENT_TYPE_RESERVATION', 2);
define('ENVIRONMENT_TYPE_PROPERTY', 4);

function checkNotEmpty() {
	global $lDB;
	$count = $lDB->get("SELECT COUNT(*) FROM sc_env_group", 4);
	if ($count == 0) {
		return $lDB->put("
			INSERT INTO sc_env_group (sc_env_group_ix, sc_group_id, rf_database_id)
			SELECT GET_UUID(), sc_group.sc_group_id, rf_database.rf_database_id
			FROM sc_group, rf_database
		");
	}
	return false;
}

function db_sc_env_group_exists($sc_group_id) {
	global $lDB;
	$count = $lDB->get("SELECT COUNT(*) FROM sc_env_group WHERE sc_group_id = $sc_group_id", 2);
	return ($count == 0) ? false : true;
}

function db_sc_env_group_get_list($sc_group_id) {
	global $lDB;
	if (db_sc_env_group_exists($sc_group_id)) {
		return $lDB->get("
			SELECT 
				rf_database_id
			FROM 
				sc_env_group 
			WHERE sc_group_id = $sc_group_id 
		", 3);
	}
	else {
		return false;
	}
}

function db_sc_env_group_get_environment_list() {
	checkNotEmpty();
	global $lDB;
	return $lDB->get("
		SELECT 
			rf_database_id,
			rf_db_code,
			rf_db_description,
			rf_db_env_type_ind,
			rf_db_inactive_yn
		FROM rf_database
		ORDER BY rf_db_env_type_ind, rf_db_code", 6);
}

function db_sc_env_group_delete_group($sc_env_group_ix_array) {
	global $lDB;
	$sql = 'DELETE FROM sc_env_group WHERE sc_env_group_ix IN ("' . implode('", "', $sc_env_group_ix_array) . '")';
	return $lDB->put($sql);
}

function db_sc_env_group_add($sc_group_id, $rf_database_id) {
	global $lDB;
	return $lDB->put(
	   "INSERT INTO sc_env_group (rf_database_id, sc_group_id) 
		VALUES ($rf_database_id, $sc_group_id)"
	);
}

function db_sc_env_group_clone_group($record, $newRecord) {
	global $lDB;
	$envGroupList = db_sc_env_group_get_list($record);
	$groupListCount = count($envGroupList);
	foreach ($envGroupList as $envId) {
		$result = db_sc_env_group_add($newRecord, $envId);
	}
	return true;
}

function db_sc_env_group_update($sc_group_id, $activeEnvironmentList) {
	global $lDB;
	$removeList = [];
	$result = true;
	$activeEnvironments = array_keys($activeEnvironmentList);
	$environmentList = db_sc_env_group_get_list($sc_group_id);
	sort($environmentList);
	$removed = array_diff($environmentList, $activeEnvironments);
	$added   = array_diff($activeEnvironments, $environmentList);
	if (count($removed) > 0) {
		foreach ($removed as $key => $removeId) { // Build id list to delete
			$sc_env_group_ix = $lDB->get("
				SELECT sc_env_group_ix FROM sc_env_group WHERE sc_group_id = $sc_group_id AND rf_database_id = $removeId
			", 4);
			$removeList[] = $sc_env_group_ix;
		}
		$removeListCount = count($removeList);
		$result = ($removeListCount > 0) ? db_sc_env_group_delete_group($removeList) : "";
	}
	if (count($added > 0)) {
		foreach ($added as $key => $addEnvironmentId) {
			$result = db_sc_env_group_add($sc_group_id, $addEnvironmentId);
		}
	}
	return $result;
}

function db_sc_env_group_can_access($sc_group_id) {
	global $lDB;
	return $lDB->get("
		SELECT 
			rf_database.rf_db_code, 
			rf_database.rf_db_description, 
			rf_database.rf_db_env_type_ind, 
			rf_database.rf_db_env_type_web_yn 
		FROM rf_database 
		LEFT JOIN sc_env_group ON sc_env_group.rf_database_id = rf_database.rf_database_id 
		WHERE sc_env_group.sc_group_id = " . $sc_group_id . "
		AND rf_database.rf_db_inactive_yn = 0
		ORDER BY rf_database.rf_db_env_type_ind;", 5);
}

function db_sc_env_group_get_meta() {
	global $lDB;
	return $lDB->get("
		SELECT
			rf_site_title,
			rf_site_description,
			rf_site_keywords
		FROM
			rf_default
	",1);
}
